

<?php $__env->startSection('title', 'قائمة الأخبار'); ?>

<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                <div class="block-card-header d-flex justify-content-between align-items-center px-4 py-3 border-bottom bg-light">
                    <h2 class="widget-title m-0">📰 قائمة الأخبار</h2>
                    <a class="btn btn-success btn-sm px-3" href="<?php echo e(route('news.create')); ?>">
                        <i class="la la-plus me-1"></i> إضافة خبر جديد
                    </a>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success mx-4 mt-3">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="block-card-body p-3">
                    <div class="table-responsive" dir="rtl">
                        <table class="table table-hover align-middle text-center mb-0 table-news">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 5%">#</th>
                                    <th style="width: 25%">تمت الإضافة بواسطة</th>
                                    <th style="width: 25%">العنوان</th>
                                    <th style="width: 20%">الصورة / YouTube</th>
                                    <th style="width: 10%">منشور</th>
                                    <th style="width: 15%">التاريخ</th>
                                    <th style="width: 20%">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($item->id); ?></td>
                                        <td><?php echo e($item->utilisateur ? $item->utilisateur->nom_prenom : 'غير محدد'); ?></td>
                                        <td class="text-end">
                                            <a href="<?php echo e(route('news.show', $item)); ?>" 
                                               class="text-decoration-none text-primary fw-bold" 
                                               style="direction: ltr; display: inline-block;">
                                                <?php echo e($item->title); ?>

                                            </a>
                                        </td>

                                        <td>
                                            <?php if($item->image): ?>
                                                <img src="<?php echo e(asset('storage/' . $item->image)); ?>" 
                                                    alt="صورة الخبر" 
                                                    class="rounded shadow-sm border" 
                                                    style="width: 80px; height: 60px; object-fit: cover;">
                                            <?php elseif($item->youtube_url): ?>
                                                <?php
                                                    if (preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $item->youtube_url, $m)) {
                                                        $youtubeId = $m[2];
                                                    } else {
                                                        $youtubeId = null;
                                                    }
                                                ?>

                                                <?php if($youtubeId): ?>
                                                    <a href="https://www.youtube.com/watch?v=<?php echo e($youtubeId); ?>" target="_blank">
                                                        <img src="https://img.youtube.com/vi/<?php echo e($youtubeId); ?>/hqdefault.jpg"
                                                            alt="معاينة الفيديو"
                                                            class="rounded shadow-sm border"
                                                            style="width: 80px; height: 60px; object-fit: cover;">
                                                    </a>
                                                <?php else: ?>
                                                    <span class="badge bg-danger"><i class="la la-youtube"></i> YouTube</span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                
                                                <span class="text-muted">—</span>
                                            <?php endif; ?>
                                        </td>


                                        <td>
                                            <span class="status-badge 
                                                <?php echo e($item->published ? 'status-badge--success' : 'status-badge--danger'); ?>">
                                                <?php echo e($item->published ? 'نعم' : 'لا'); ?>

                                            </span>
                                        </td>


                                        <td><?php echo e($item->date); ?></td>

                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <button type="button"
                                                        class="btn btn-warning btn-sm"
                                                        onclick="return confirmAction('هل تريد تعديل هذا الخبر؟', '<?php echo e(route('news.edit', $item)); ?>')"
                                                        title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                <form action="<?php echo e(route('news.destroy', $item)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا الخبر؟', null, this.closest('form'))"
                                                            class="btn btn-danger btn-sm"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="py-4 text-muted">لا توجد أخبار حالياً.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="mt-3 d-flex justify-content-center">
                        <?php echo e($news->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-news th, 
.table-news td {
    vertical-align: middle;
    text-align: center;
}

.table-news th:nth-child(2),
.table-news td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.status-badge--success {
    background-color: #e8f9ee; 
    color: #27ae60;           
}

.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}


</style>

<?php else: ?>
<script>window.location.href = "<?php echo e(route('admin')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/news/index.blade.php ENDPATH**/ ?>