<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UtilisateurController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\Investissement\SalleSportController;
use App\Http\Controllers\Investissement\DebutActiviteController;
use App\Http\Controllers\Investissement\JeuneEnfantController;
use App\Http\Controllers\Investissement\JeunesseController;
use App\Http\Controllers\Investissement\FormationStageController;
use App\Http\Controllers\Investissement\ExonarationController;
use App\Http\Controllers\Financement\DocumentFinancementController;
use App\Http\Controllers\Financement\Document2FinancementController;
use App\Http\Controllers\ManifestationSport\ManifestationSportController;
use App\Http\Controllers\ManifestationSport\ManifestationSport2Controller;
use App\Http\Middleware\CheckPermission;
use App\Http\Controllers\Financement\DocumentFinancement2Controller;
use App\Http\Controllers\GestionFrontController;
use App\Http\Controllers\GuideController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\TropheeSportifController;
use App\Http\Controllers\SlidersController;
use App\Http\Controllers\AubergesController;
use App\Http\Controllers\ReservationAubergesController;
use App\Http\Controllers\ReservationAssignController;
use App\Http\Controllers\AvisController;
use App\Http\Controllers\ChambreController;
use App\Http\Controllers\DescGouvrController;
use App\Http\Controllers\BuilderController;
use App\Http\Controllers\ConcoursExtController;
use App\Http\Controllers\FieldDefinitionController;
use App\Http\Controllers\ConcoursController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\FederationController;

/* ********** FrontOffice ********** */
/*Route::get('/', function () {
    return view('backoffice.authentification.signin');
})->name('home');
*/

Route::get('/', function () {
    if (Auth::guard('admin')->check()) {
        return redirect()->route('admin.dashboard');
    }

    return view('backoffice.authentification.signin');
})->name('home');

/*Route::get('/notifications/read/{id}', function ($id) {
    auth()->user()->notifications()->where('id', $id)->first()?->markAsRead();
})->name('notifications.read');
*/

/*Route::post('/notifications/read/{id}', function ($id) {
    $notification = auth()->user()
        ->notifications()
        ->where('id', $id)
        ->first();

    if ($notification && is_null($notification->read_at)) {
        $notification->markAsRead();
    }

    return response()->json(['status' => 'ok']);
})->name('notifications.read');*/

Route::get('/notifications/{id}', function ($id) {
    $notification = auth()->user()
        ->notifications()
        ->where('id', $id)
        ->firstOrFail();
    $notification->markAsRead();
    return redirect($notification->data['url'] ?? url('/'));
})->name('notifications.open');




Route::middleware(['auth'])->group(function () {
    Route::get('newsletters', [NewsletterController::class, 'index'])->name('newsletters.index');
    Route::get('newsletters/{newsletter}/edit', [NewsletterController::class, 'edit'])->name('newsletters.edit');
    Route::put('newsletters/{newsletter}', [NewsletterController::class, 'update'])->name('newsletters.update');
    Route::delete('newsletters/{newsletter}', [NewsletterController::class, 'destroy'])->name('newsletters.destroy');

    Route::get('contacts', [ContactController::class, 'index'])->name('contacts.index');
    Route::get('contacts/{contact}', [ContactController::class, 'show'])->name('contacts.show');
    Route::delete('contacts/{contact}', [ContactController::class, 'destroy'])->name('contacts.destroy');

});


// Route API pour récupérer les délégations par gouvernorat
Route::get('/admin/delegations/{gouvernoratId}', [DashboardController::class, 'getDelegations'])
    ->name('admin.delegations');

Route::get('/gouvernorats', function () {
    return view('FrontOffice.search_gouver');
})->name('gouver');

Route::get('/detail_gouver', function () {
    return view('FrontOffice.detail_gouver');
})->name('detail_gouver');

Route::get('/auberge', function () {
    return view('FrontOffice.auberge');
})->name('auberge');

Route::get('/centres', function () {
    return view('FrontOffice.general');
})->name('centres');

Route::get('/formulaire/{formulaire}', [HomeController::class, 'redirectToForm'])
    ->name('formulaire.access');
Route::get('/delegations/{gouvernoratId}', [SalleSportController::class, 'getDelegations_salle'])->name('delegations.get');

/* ********** BackOffice ********** */

/* Authentification */

// ======================
// Partie Admin
// ======================
Route::get('/oublier_mdp', [AuthController::class, 'showForgotPasswordForm'])
        ->name('admin.password.request'); 
Route::get('/admin', [AuthController::class, 'loginFormadmin'])
    ->middleware('guest:admin')  
   ->name('login');
Route::post('/admin/login', [AuthController::class, 'login_admin'])->name('admin.login.post');
Route::prefix('admin')->group(function () {
    // Login POST
    Route::post('/login', [AuthController::class, 'login_admin'])
        ->name('admin.login.post'); 
    Route::post('/oublier_mdp', [AuthController::class, 'sendResetLinkEmail'])
        ->name('admin.password.email');     
    Route::get('/set-mdp/{utilisateur}', [AuthController::class, 'setMdpForm'])
        ->name('admin.password.reset');     
    Route::post('/set-mdp/{utilisateur}', [AuthController::class, 'setMdp'])
        ->name('admin.password.update');  

         

    // Routes protégées (auth:admin)
    Route::middleware('auth:admin')->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
        Route::post('/logout', [AuthController::class, 'logout_admin'])->name('logout_admin');

Route::get('concours/{concours}/candidates/{candidate}/files/{file}', 
    [App\Http\Controllers\ConcoursExtController::class, 'file'])
    ->name('concours_ext.file');

Route::post('concours', [App\Http\Controllers\ConcoursController::class, 'store'])
 ->middleware(CheckPermission::class .':130')
->name('concours.store');

Route::resource('concours', ConcoursController::class)
    ->parameters(['concours' => 'concours'])
    ->middleware(CheckPermission::class . ':130');
	  
	  
Route::post('concours/{concours}/state', [ConcoursController::class, 'changeState'])
 ->middleware(CheckPermission::class .':130')
->name('concours.change_state');

Route::get('field-definitions-index', [FieldDefinitionController::class, 'index'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.index');

Route::get('field-definitions/create', [FieldDefinitionController::class, 'create'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.create');

Route::post('field-definitions', [FieldDefinitionController::class, 'store'])
 ->middleware(CheckPermission::class .':130')
    ->name('field_definitions.store');

Route::get('field-definitions/{fieldDefinition}/edit', [FieldDefinitionController::class, 'edit'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.edit');

Route::put('field-definitions/{fieldDefinition}', [FieldDefinitionController::class, 'update'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.update');

Route::delete('field-definitions/{fieldDefinition}', [FieldDefinitionController::class, 'destroy'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.destroy');
Route::post('field-definitions/{fieldDefinition}/toggle-visibility', [FieldDefinitionController::class, 'toggleVisibility'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.toggleVisibility');
Route::post('field-definitions/reorder', [FieldDefinitionController::class, 'reorder'])
 ->middleware(CheckPermission::class .':130')
    ->name('backoffice.field_definitions.reorder');
Route::get('concours/{concours}/candidates', [ConcoursExtController::class, 'index'])
 ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.index');

Route::get('concours/{concours}/candidates/create', [ConcoursExtController::class, 'create']) 
->middleware(CheckPermission::class .':130')
    ->name('concours_ext.create');

Route::post('concours/{concours}/candidates', [ConcoursExtController::class, 'store'])
 ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.store');

Route::get('concours/{concours}/candidates/{candidate}', [ConcoursExtController::class, 'show'])
 ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.show');

Route::get('concours/{concours}/candidates/{candidate}/edit', [ConcoursExtController::class, 'edit'])
 ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.edit');

Route::put('concours/{concours}/candidates/{candidate}', [ConcoursExtController::class, 'update'])
 ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.update');

Route::delete('concours/{concours}/candidates/{candidate}', [ConcoursExtController::class, 'destroy'])
  ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.destroy');

Route::post('concours/{concours}/candidates/{candidate}/state', [ConcoursExtController::class, 'changeState'])
 ->middleware(CheckPermission::class .':130')
    ->name('concours_ext.change_state');
	

        //Archive reservation
        Route::get('/reservations/archives', [ReservationAubergesController::class, 'archives'])
            ->name('reservation.archives');

        Route::get('/reservations/archive/{id}', [ReservationAubergesController::class, 'showArchive'])
            ->name('reservation.showArchive');

        //News
        Route::get('news', [NewsController::class, 'index'])
            ->middleware(CheckPermission::class .':97')
            ->name('news.index');            
        
        Route::get('news/create', [NewsController::class, 'create'])
            ->middleware(CheckPermission::class .':98')
            ->name('news.create');   
        
        Route::post('news', [NewsController::class, 'store'])
            ->middleware(CheckPermission::class .':98')
            ->name('news.store');          
        
        Route::get('news/{news}', [NewsController::class, 'show'])
            ->middleware(CheckPermission::class .':99')
            ->name('news.show');      
        
        Route::get('news/{news}/edit', [NewsController::class, 'edit'])
            ->middleware(CheckPermission::class .':100')
            ->name('news.edit');
        
        Route::put('news/{news}', [NewsController::class, 'update'])
            ->middleware(CheckPermission::class .':100')
            ->name('news.update');  
        
        Route::delete('news/{news}', [NewsController::class, 'destroy'])
            ->middleware(CheckPermission::class .':101')
            ->name('news.destroy'); 


        //trophee_sportif
        Route::get('trophee_sportif', [TropheeSportifController::class, 'index'])
            ->middleware(CheckPermission::class .':102')
            ->name('trophee_sportif.index');            
        
        Route::get('trophee_sportif/create', [TropheeSportifController::class, 'create'])
            ->middleware(CheckPermission::class .':103')
            ->name('trophee_sportif.create');   
        
        Route::post('trophee_sportif', [TropheeSportifController::class, 'store'])
            ->middleware(CheckPermission::class .':103')
            ->name('trophee_sportif.store');          
        
        Route::get('trophee_sportif/{trophee_sportif}', [TropheeSportifController::class, 'show'])
            ->middleware(CheckPermission::class .':104')
            ->name('trophee_sportif.show');      
        
        Route::get('trophee_sportif/{trophee_sportif}/edit', [TropheeSportifController::class, 'edit'])
            ->middleware(CheckPermission::class .':105')
            ->name('trophee_sportif.edit');
        
        Route::put('trophee_sportif/{trophee_sportif}', [TropheeSportifController::class, 'update'])
            ->middleware(CheckPermission::class .':105')
            ->name('trophee_sportif.update');  
        
        Route::delete('trophee_sportif/{trophee_sportif}', [TropheeSportifController::class, 'destroy'])
            ->middleware(CheckPermission::class .':106')
            ->name('trophee_sportif.destroy');


            //federation 

        Route::get('federation', [FederationController::class, 'index'])
            ->name('federation.index');  

        Route::get('federation/create', [FederationController::class, 'create'])
            ->name('federation.create');

        Route::post('federation', [FederationController::class, 'store'])
            ->name('federation.store');
        
        Route::get('federation/{federation}/edit', [FederationController::class, 'edit'])
            ->name('federation.edit');

        Route::put('federation/{federation}', [FederationController::class, 'update'])
            ->name('federation.update');

        Route::delete('federation/{federation}', [FederationController::class, 'destroy'])
            ->name('federation.destroy');



        //sliders
        Route::get('/sliders', [SlidersController::class, 'index'])
            ->middleware(CheckPermission::class .':107')
            ->name('sliders.index');
        Route::get('/sliders/create', [SlidersController::class, 'create'])
            ->middleware(CheckPermission::class .':108')
            ->name('sliders.create');
        Route::post('/sliders', [SlidersController::class, 'store'])
            ->middleware(CheckPermission::class .':108')
            ->name('sliders.store');
        Route::get('/sliders/{id}/edit', [SlidersController::class, 'edit'])
            ->middleware(CheckPermission::class .':109')
            ->name('sliders.edit');
        Route::put('/sliders/{id}', [SlidersController::class, 'update'])
            ->middleware(CheckPermission::class .':109')
            ->name('sliders.update');
        Route::delete('/sliders/{id}', [SlidersController::class, 'destroy'])
            ->middleware(CheckPermission::class .':110')
            ->name('sliders.destroy');
        

        //Auberge
        Route::get('auberges', [AubergesController::class, 'index'])
            ->middleware(CheckPermission::class .':115')
            ->name('auberges.index');
        Route::get('auberges/create', [AubergesController::class, 'create'])
            ->middleware(CheckPermission::class .':112')
            ->name('auberges.create');
        Route::post('auberges/store', [AubergesController::class, 'store'])
            ->middleware(CheckPermission::class .':112')
            ->name('auberges.store');
        Route::get('auberges/{id}/edit', [AubergesController::class, 'edit'])
            ->middleware(CheckPermission::class .':113')
            ->name('auberges.edit');
        Route::put('auberges/{id}', [AubergesController::class, 'update'])
            ->middleware(CheckPermission::class .':113')
            ->name('auberges.update'); 
        Route::get('auberges/{id}', [AubergesController::class, 'show'])
            ->middleware(CheckPermission::class .':111')
            ->name('auberges.show');  
        Route::delete('auberges/{id}', [AubergesController::class, 'destroy'])
            ->middleware(CheckPermission::class .':114')
            ->name('auberges.destroy');
			
		//directeur auberge
		Route::get('auberges2/{id}/edit', [AubergesController::class, 'edit2'])
            ->middleware(CheckPermission::class .':128')
            ->name('auberges2.edit');
        Route::put('auberges2/{id}', [AubergesController::class, 'update2'])
            ->middleware(CheckPermission::class .':128')
            ->name('auberges2.update');
		Route::get('auberges2/{id}', [AubergesController::class, 'showauberge'])
            ->middleware(CheckPermission::class .':129')
            ->name('auberges2.show');
			
        //Chambre
        Route::get('/auberges/{id}/chambres', [ChambreController::class, 'index'])
            ->name('chambres.index');
        Route::get('/auberges/{id}/chambres/create', [ChambreController::class, 'create'])
            ->name('chambres.create');
        Route::post('/chambres', [ChambreController::class, 'store'])
            ->name('chambres.store');
        Route::get('/chambres/{id_chambre}', [ChambreController::class, 'show'])
            ->name('chambres.show');
        Route::get('/chambres/{id_chambre}/edit', [ChambreController::class, 'edit'])
            ->name('chambres.edit');
        Route::put('/chambres/{id_chambre}', [ChambreController::class, 'update'])
            ->name('chambres.update');
        Route::delete('/chambres/{id_chambre}', [ChambreController::class, 'destroy'])
            ->name('chambres.destroy');
        Route::get('/chambres/{id}/disponibilite', [ChambreController::class, 'disponibilite'])
            ->name('chambres.disponibilite');
        Route::post('chambres/disponibilite/toggle', [ChambreController::class, 'toggleDisponibilite'])->name('chambres.disponibilite.toggle');

        Route::post('chambres/{id}/disponibilite/block', [ChambreController::class, 'blockRoom'])
            ->name('chambres.disponibilite.block');

        // Reservations auberges
        Route::get('/reservations', [ReservationAubergesController::class, 'index'])
			->middleware(CheckPermission::class .':117')
            ->name('reservation.index');
        
		Route::get('/reservations/{reservation}', [ReservationAubergesController::class, 'show'])
			->middleware(CheckPermission::class .':116')
            ->name('reservation.show');
        
		Route::put('/reservation/{id}/status', [ReservationAubergesController::class, 'updateStatus'])
			->middleware(CheckPermission::class .':118')
            ->name('reservation.updateStatus');
        
        //Archive Reservation 
        /*Route::get('/reservations/archives', [ReservationAubergesController::class, 'archives'])
            ->name('reservation.archives');

        Route::get('/reservations/archive/{id}', [ReservationAubergesController::class, 'showArchive'])
            ->name('reservation.showArchive'); */

        //Affectation chambre  
        Route::get('/reservation/{id}/chambres', [ReservationAubergesController::class, 'affecterChambres'])
            ->name('reservation.chambres');
        Route::post('/reservation/{id}/assign-chambre', [ReservationAubergesController::class, 'assignChambre'])
            ->name('reservation.assignChambre');

        //Vider chambre et supprimer reservation
        Route::delete('/reservation/{id}/vider-tout', [ReservationAubergesController::class, 'viderToutesChambres'])
            ->name('reservation.viderToutesChambres');


        //Avis
        Route::get('/avis', [AvisController::class, 'index'])->name('avis.index');
        Route::get('/avis/{id}', [AvisController::class, 'show'])->name('avis.show');
        Route::delete('/avis/{id}', [AvisController::class, 'destroy'])->name('avis.destroy');



        //desc gouvernorat
        Route::get('/desc_gouvr', [DescGouvrController::class, 'index'])
		->middleware(CheckPermission::class .':119')
		->name('desc_gouvr.index');
        Route::get('/desc_gouvr/create', [DescGouvrController::class, 'create'])
		->middleware(CheckPermission::class .':120')
		->name('desc_gouvr.create');
        Route::post('/desc_gouvr/store', [DescGouvrController::class, 'store'])
		->middleware(CheckPermission::class .':120')
		->name('desc_gouvr.store');
        Route::get('/desc_gouvr/{desc_gouvr}', [DescGouvrController::class, 'show'])
		->middleware(CheckPermission::class .':121')
		->name('desc_gouvr.show');
        Route::get('/desc_gouvr/{desc_gouvr}/edit', [DescGouvrController::class, 'edit'])
		->middleware(CheckPermission::class .':122')
		->name('desc_gouvr.edit');
        Route::put('/desc_gouvr/{desc_gouvr}', [DescGouvrController::class, 'update'])
		->middleware(CheckPermission::class .':122')
		->name('desc_gouvr.update');
        Route::delete('/desc_gouvr/{desc_gouvr}', [DescGouvrController::class, 'destroy'])
		->middleware(CheckPermission::class .':123')
		->name('desc_gouvr.destroy');
        
        
        Route::resource('permissions', PermissionController::class);



        //permissions
        Route::get('/permissions', [PermissionController::class, 'index'])
        ->name('permissions.index');
        Route::get('/permissions/create', [PermissionController::class, 'create'])
            ->name('permissions.create');
        Route::post('/permissions', [PermissionController::class, 'store'])
            ->name('permissions.store');
        Route::get('/permissions/{permission}/edit', [PermissionController::class, 'edit'])
            ->name('permissions.edit');
        Route::put('/permissions/{permission}', [PermissionController::class, 'update'])
            ->name('permissions.update');
        Route::delete('/permissions/{permission}', [PermissionController::class, 'destroy'])
            ->name('permissions.destroy');


        // Gestion utilisateurs
        /*Route::resource('utilisateurs', UtilisateurController::class);*/
        Route::get('utilisateurs/{utilisateur}/profil', [UtilisateurController::class, 'profil']) 
            ->name('utilisateurs.profil');

        Route::patch('utilisateurs/{utilisateur}/activation', [UtilisateurController::class, 'toggleActivation'])
            ->middleware(CheckPermission::class .':6') 
            ->name('utilisateurs.activation');

        Route::get('mon-profil/edit', [UtilisateurController::class, 'editProfil'])
            ->name('utilisateurs.editprofil');

        Route::patch('mon-profil/update', [UtilisateurController::class, 'updateProfil'])
            ->name('utilisateurs.updateprofil');


Route::get('utilisateurs', [UtilisateurController::class, 'index'])
    ->middleware(CheckPermission::class .':3')  
    ->name('utilisateurs.index');

Route::get('utilisateurs/create', [UtilisateurController::class, 'create'])
    ->middleware(CheckPermission::class .':1')  
    ->name('utilisateurs.create');

    Route::post('utilisateurs', [UtilisateurController::class, 'store'])
    ->middleware(CheckPermission::class .':1')  
    ->name('utilisateurs.store');

Route::get('utilisateurs/{utilisateur}/edit', [UtilisateurController::class, 'edit'])
    ->middleware(CheckPermission::class .':4') 
    ->name('utilisateurs.edit');

    Route::put('utilisateurs/{utilisateur}', [UtilisateurController::class, 'update'])
    ->middleware(CheckPermission::class .':4') 
    ->name('utilisateurs.update');

    Route::get('utilisateurs/{utilisateur}/show', [UtilisateurController::class, 'show'])
    ->middleware(CheckPermission::class .':18') 
    ->name('utilisateurs.show');

Route::delete('utilisateurs/{utilisateur}', [UtilisateurController::class, 'destroy'])
    ->middleware(CheckPermission::class .':5') 
    ->name('utilisateurs.destroy');


        // Gestion rôles
   
        Route::get('/roles', [RoleController::class, 'index'])
            ->middleware(CheckPermission::class .':10')
            ->name('roles.index');
        Route::get('/roles/create', [RoleController::class, 'create'])
            ->middleware(CheckPermission::class .':11')
            ->name('roles.create');
        Route::post('/roles', [RoleController::class, 'store'])
            ->middleware(CheckPermission::class .':11')
            ->name('roles.store');

    Route::get('roles/{role}/edit', [RoleController::class, 'edit'])
    ->middleware(CheckPermission::class .':12') 
    ->name('roles.edit');

    Route::put('roles/{role}', [RoleController::class, 'update'])
    ->middleware(CheckPermission::class .':19') 
    ->name('roles.update');

    Route::delete('roles/{role}', [RoleController::class, 'destroy'])
        ->middleware(CheckPermission::class .':13') 
        ->name('roles.destroy');



        /*Route::resource('roles', RoleController::class);*/
        Route::get('roles/{role}/permissions', [RoleController::class, 'editPermissions'])
            ->middleware(CheckPermission::class .':14')  
            ->name('admin.roles.permissions.edit');
        
        Route::put('roles/{role}/permissions', [RoleController::class, 'updatePermissions'])
            ->middleware(CheckPermission::class .':15')  
            ->name('admin.roles.permissions.update');

        

        // Investissements 
        Route::prefix('investissement')->group(function() {
            // Salle de sport routes
            Route::get('salle-sport', [SalleSportController::class, 'index'])
                ->middleware(CheckPermission::class .':20') 
                ->name('salle-sport.index');

            Route::get('salle-sport/create', [SalleSportController::class, 'create'])
                ->middleware(CheckPermission::class .':21') 
                ->name('salle-sport.create');

            Route::post('salle-sport', [SalleSportController::class, 'store'])
                ->middleware(CheckPermission::class .':21') 
                ->name('salle-sport.store');

            Route::get('salle-sport/{id}', [SalleSportController::class, 'show'])
                ->middleware(CheckPermission::class .':26') 
                ->name('salle-sport.show');

            Route::get('salle-sport/{id}/edit', [SalleSportController::class, 'edit'])
                ->middleware(CheckPermission::class .':22') 
                ->name('salle-sport.edit');

            Route::put('salle-sport/{id}', [SalleSportController::class, 'update'])
                ->middleware(CheckPermission::class .':23') 
                ->name('salle-sport.update');

            Route::delete('salle-sport/{id}', [SalleSportController::class, 'destroy'])
                ->middleware(CheckPermission::class .':24') 
                ->name('salle-sport.destroy');


            Route::get('/immobilier/{id}/download', [SalleSportController::class, 'download'])->name('immobilier.download');


            //Route::patch('salle-sport/{id}/toggle-statut', [SalleSportController::class, 'toggleStatut'])->name('salle-sport.toggle-statut');
            Route::patch('/salle-sport/{salle}/acceptation', [SalleSportController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':25') 
                ->name('salle-sport.acceptation');


            Route::get('/salle-sport/{id_imm}/exoneration/create', [SalleSportController::class, 'createExoneration'])
                ->middleware(CheckPermission::class .':28') 
                ->name('salle-sport.exoneration.create');

            Route::post('/salle-sport/{id_imm}/exoneration/store', [SalleSportController::class, 'storeExoneration'])
                ->middleware(CheckPermission::class .':28') 
                ->name('salle-sport.exoneration.store');

            Route::get('/salle-sport/exoneration/{id}/edit', [SalleSportController::class, 'editExoneration'])
                ->middleware(CheckPermission::class .':29') 
                ->name('salle-sport.exoneration.edit');

            Route::put('/salle-sport/exoneration/{id}/update', [SalleSportController::class, 'updateExoneration'])
                ->middleware(CheckPermission::class .':29') 
                ->name('salle-sport.exoneration.update');

            Route::get('/salle-sport/exoneration/{id}/show', [SalleSportController::class, 'showExoneration'])
                ->middleware(CheckPermission::class .':27') 
                ->name('salle-sport.exoneration.show');

			Route::get('/exoneration/{id}/pdf', [SalleSportController::class, 'pdfExoneration'])
				->name('admin.exoneration.pdf');
	
            Route::get('/delegations/{gouvernoratId}', [SalleSportController::class, 'getDelegations']);
            Route::get('salle-sport/export/excel', [SalleSportController::class, 'exportExcel'])
                 ->name('salle-sport.export.excel');

             Route::get('salle-sport/export/pdf',
                    [SalleSportController::class, 'exportPdf'])->name('salle-sport.export.pdf');    
            Route::get('/salle-sport/{id}/pdf',[SalleSportController::class, 'pdf'])
                ->name('salle-sport.pdf');

            
            // Salle de sport _ Début activité
            Route::get('debut-activite', [DebutActiviteController::class, 'index']) 
            ->middleware(CheckPermission::class .':31') 
            ->name('admin.debut_activite.index');

            Route::get('debut-activite/create', [DebutActiviteController::class, 'create'])
                ->middleware(CheckPermission::class .':32') 
            ->name('admin.debut_activite.create');

            Route::post('debut-activite/store', [DebutActiviteController::class, 'store'])
                ->middleware(CheckPermission::class .':32') 
                ->name('admin.debut_activite.store');
            Route::post('debut-activite/verifier-identite', [DebutActiviteController::class, 'verifierIdentite'])
            ->name('admin.debut_activite.verifier_identite');

            Route::get('debut-activite/{id}/edit', [DebutActiviteController::class, 'edit'])
              ->middleware(CheckPermission::class .':33')   
                ->name('admin.debut_activite.edit');

            Route::put('debut-activite/{id}', [DebutActiviteController::class, 'update'])
            ->middleware(CheckPermission::class .':33')
            ->name('admin.debut_activite.update');

            Route::get('debut-activite/{id}', [DebutActiviteController::class, 'show'])
			->name('debut_activite.show');
			
			Route::get('debut-activite/{id}/download/{field}', [DebutActiviteController::class, 'download'])
			->name('debutActivite.download');

            Route::patch('debut-activite/{id}/toggle-statut', [DebutActiviteController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':35')      
                 ->name('admin.debut_activite.toggle_statut');

            Route::delete('debut-activite/{id}', [DebutActiviteController::class, 'destroy'])
                ->middleware(CheckPermission::class .':34')
                ->name('admin.debut_activite.destroy');

                Route::get('admin/debut_activite/export-excel', [DebutActiviteController::class, 'exportExcel'])
                ->middleware(CheckPermission::class .':31') 
                ->name('admin.debut_activite.export.excel');

                Route::get('admin/debut_activite/export-pdf', [DebutActiviteController::class, 'exportPdf'])
                ->middleware(CheckPermission::class .':31') 
                ->name('admin.debut_activite.export.pdf');

			Route::get('/debut-activite/{id}/pdf', [DebutActiviteController::class, 'pdf'])
				->name('admin.debut_activite.pdf');
				

            // Jeune _ Enfant
            Route::get('jeune_enfant', [JeuneEnfantController::class, 'index'])
                ->middleware(CheckPermission::class .':36')
                ->name('admin.jeune_enfant.index');

            Route::get('jeune_enfant/create', [JeuneEnfantController::class, 'create'])
                ->middleware(CheckPermission::class .':37')
                ->name('admin.jeune_enfant.create');

            Route::post('jeune_enfant/store', [JeuneEnfantController::class, 'store'])
                ->middleware(CheckPermission::class .':37')
                ->name('admin.jeune_enfant.store');

            Route::get('jeune_enfant/{id}/show', [JeuneEnfantController::class, 'show'])
                ->middleware(CheckPermission::class .':38')
                ->name('admin.jeune_enfant.show');

            Route::patch('jeune_enfant/{id}/toggle-statut', [JeuneEnfantController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':40')
                ->name('admin.jeune_enfant.toggle_statut');

            Route::get('jeune_enfant/{id}/edit', [JeuneEnfantController::class, 'edit'])
               ->middleware(CheckPermission::class .':39') 
                ->name('admin.jeune_enfant.edit');

            Route::put('jeune_enfant/{id}', [JeuneEnfantController::class, 'update'])
                ->middleware(CheckPermission::class .':39')
                ->name('admin.jeune_enfant.update');

            Route::delete('jeune_enfant/{id}', [JeuneEnfantController::class, 'destroy'])
                ->middleware(CheckPermission::class .':41')
                ->name('admin.jeune_enfant.destroy');

                Route::get('jeune-enfant/export/pdf', [JeuneEnfantController::class, 'exportPdf'])
                ->middleware(CheckPermission::class .':36')
                    ->name('admin.jeune_enfant.export.pdf');

                Route::get('jeune-enfant/export/excel', [JeuneEnfantController::class, 'exportExcel'])
                ->middleware(CheckPermission::class .':36')
                    ->name('admin.jeune_enfant.export.excel');

                    Route::get(
				'/jeune-enfant/{id}/pdf',
				[JeuneEnfantController::class, 'pdf']
			)->name('jeune_enfant.pdf');
			

            // Jeunesse
            Route::get('jeunesse', [JeunesseController::class, 'index'])
                ->middleware(CheckPermission::class .':42')
                ->name('admin.jeunesse.index');

            Route::get('jeunesse/create', [JeunesseController::class, 'create'])
                ->middleware(CheckPermission::class .':43')
                ->name('admin.jeunesse.create');

            Route::post('jeunesse/store', [JeunesseController::class, 'store'])
                ->middleware(CheckPermission::class .':43')
                ->name('admin.jeunesse.store');

            Route::get('jeunesse/{id}/show', [JeunesseController::class, 'show'])
                ->middleware(CheckPermission::class .':44')
                ->name('admin.jeunesse.show');

            Route::patch('jeunesse/{id}/toggle-statut', [JeunesseController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':45')
                ->name('admin.jeunesse.toggle_statut');

            Route::get('jeunesse/{id}/edit', [JeunesseController::class, 'edit'])
                ->middleware(CheckPermission::class .':46')
                ->name('admin.jeunesse.edit');

            Route::put('jeunesse/{id}', [JeunesseController::class, 'update'])
                ->middleware(CheckPermission::class .':46')
                ->name('admin.jeunesse.update');

            Route::delete('jeunesse/{id}', [JeunesseController::class, 'destroy'])
                ->middleware(CheckPermission::class .':47')
                ->name('admin.jeunesse.destroy');
            Route::get('jeunesse/export-excel', [JeunesseController::class, 'exportExcel'])
            ->middleware(CheckPermission::class .':42')
                ->name('admin.jeunesse.export.excel');

            Route::get('jeunesse/export-pdf', [JeunesseController::class, 'exportPdf'])
            ->middleware(CheckPermission::class .':42')
                ->name('admin.jeunesse.export.pdf');
            Route::get('/jeunesse/{id}/pdf', [JeunesseController::class, 'pdf'] )
                ->name('jeunesse.pdf');


            Route::get('jeunesse2', [JeunesseController::class, 'index2'])
                ->middleware(CheckPermission::class .':48')
                ->name('admin.jeunesse2.index');

            Route::get('jeunesse2/create', [JeunesseController::class, 'create2'])
                ->middleware(CheckPermission::class .':49')
                ->name('admin.jeunesse2.create');

            Route::post('jeunesse2/store', [JeunesseController::class, 'store2'])
                ->middleware(CheckPermission::class .':49')
                ->name('admin.jeunesse2.store');

            Route::get('jeunesse2/{id}/show', [JeunesseController::class, 'show2'])
               ->middleware(CheckPermission::class .':50')
                ->name('admin.jeunesse2.show');

            Route::patch('jeunesse2/{id}/toggle-statut', [JeunesseController::class, 'toggleStatut2'])
               ->middleware(CheckPermission::class .':51') 
                ->name('admin.jeunesse2.toggle_statut');

            Route::get('jeunesse2/{id}/edit', [JeunesseController::class, 'edit2'])
                ->middleware(CheckPermission::class .':52')
                ->name('admin.jeunesse2.edit');

            Route::put('jeunesse2/{id}', [JeunesseController::class, 'update2'])
               ->middleware(CheckPermission::class .':52') 
                ->name('admin.jeunesse2.update');

            Route::delete('jeunesse2/{id}', [JeunesseController::class, 'destroy2'])
                ->middleware(CheckPermission::class .':53')
                ->name('admin.jeunesse2.destroy');

                Route::get('jeunesse2/export-excel', [JeunesseController::class, 'exportExcel2'])
            ->middleware(CheckPermission::class .':48')
                ->name('admin.jeunesse2.export.excel');

            Route::get('jeunesse2/export-pdf', [JeunesseController::class, 'exportPdf2'])
            ->middleware(CheckPermission::class .':48')
                ->name('admin.jeunesse2.export.pdf');

                Route::get('/jeunesse2/{id}/pdf', [JeunesseController::class, 'pdf2'] )
                ->name('jeunesse2.pdf');

        // Formation _ Stage
            Route::get('formation', [FormationStageController::class, 'index'])
               ->middleware(CheckPermission::class .':54')
                ->name('admin.formation.index');

            Route::get('formation/create', [FormationStageController::class, 'create'])
                ->middleware(CheckPermission::class .':55')
                ->name('admin.formation.create');

            Route::post('formation/store', [FormationStageController::class, 'store'])
                ->middleware(CheckPermission::class .':55')
                ->name('admin.formation.store');

            Route::get('formation/{id}/show', [FormationStageController::class, 'show'])
                ->middleware(CheckPermission::class .':56')
                ->name('admin.formation.show');

            Route::patch('formation/{id}/toggle-statut', [FormationStageController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':57')
                ->name('admin.formation.toggle_statut');

            Route::get('formation/{id}/edit', [FormationStageController::class, 'edit'])
                ->middleware(CheckPermission::class .':58')
                ->name('admin.formation.edit');

            Route::put('formation/{id}', [FormationStageController::class, 'update'])
                ->middleware(CheckPermission::class .':58')
                ->name('admin.formation.update');

            Route::delete('formation/{id}', [FormationStageController::class, 'destroy'])
                ->middleware(CheckPermission::class .':59')
                ->name('admin.formation.destroy');

                Route::get('admin/formation/export-excel', [FormationStageController::class, 'exportExcel'])
                 ->middleware(CheckPermission::class .':54')
                ->name('admin.formation.export.excel');

            Route::get('admin/formation/export-pdf', [FormationStageController::class, 'exportPdf'])
             ->middleware(CheckPermission::class .':54')
                ->name('admin.formation.export.pdf');
            Route::get('/formation/{id}/pdf', [FormationStageController::class, 'pdf'])
                ->name('formation.pdf');
        
            // Exonération
            Route::get('exoneration', [ExonarationController::class, 'index'])
                ->middleware(CheckPermission::class .':60')
            ->name('admin.exoneration.index');

            Route::get('exoneration/create', [ExonarationController::class, 'create'])
                ->middleware(CheckPermission::class .':61')
                ->name('admin.exoneration.create');
            
            Route::post('exoneration/store', [ExonarationController::class, 'store'])
                ->middleware(CheckPermission::class .':61')
                ->name('admin.exoneration.store');
            
            Route::get('exoneration/{id}/show', [ExonarationController::class, 'show'])
                ->middleware(CheckPermission::class .':62')
                ->name('admin.exoneration.show');
            
            Route::patch('exoneration/{id}/toggle-statut', [ExonarationController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':63')
                ->name('admin.exoneration.toggle_statut');
            
            Route::get('exoneration/{id}/edit', [ExonarationController::class, 'edit'])
                ->middleware(CheckPermission::class .':64')
                ->name('admin.exoneration.edit');
            
            Route::put('exoneration/{id}', [ExonarationController::class, 'update'])
                ->middleware(CheckPermission::class .':64')
                ->name('admin.exoneration.update');
            
            Route::delete('exoneration/{id}', [ExonarationController::class, 'destroy'])
                ->middleware(CheckPermission::class .':65')
                ->name('admin.exoneration.destroy');

            Route::get('/admin/exoneration/export/excel', [ExonarationController::class, 'exportExcel'])
            ->middleware(CheckPermission::class .':60')
                ->name('admin.exoneration.export.excel');

            Route::get('/admin/exoneration/export/pdf', [ExonarationController::class, 'exportPdf'])
            ->middleware(CheckPermission::class .':60')
                ->name('admin.exoneration.export.pdf');

            Route::get(
                '/exoneration/{id}/pdf',
                [ExonarationController::class, 'exonerationPdf']
            )->name('exoneration.pdf');
        Route::get('/documents/{id}/{field}', [ExonarationController::class, 'showFile2'])
    ->name('documents.show');

            // Financement
            Route::get('doc_fin', [DocumentFinancement2Controller::class, 'index'])
                ->middleware(CheckPermission::class .':66')
                ->name('doc_fin.index');

            Route::get('doc_fin/create', [DocumentFinancement2Controller::class, 'create'])
                ->middleware(CheckPermission::class .':67')
                ->name('stepper.create');
            
            Route::post('/doc_fin/store-all', [DocumentFinancement2Controller::class, 'storeAll'])
                ->middleware(CheckPermission::class .':67')
                ->name('financement.storeAll');
  
            Route::get('doc_fin/{id}', [DocumentFinancement2Controller::class, 'show'])
                ->middleware(CheckPermission::class .':68')
                ->name('doc_fin.show');
            
            Route::get('doc_fin/{id}/edit2', [DocumentFinancement2Controller::class, 'edit'])
                ->middleware(CheckPermission::class .':69')
                ->name('doc_fin.edit');
            
            Route::put('doc_fin/{id}', [DocumentFinancement2Controller::class, 'update'])
                ->middleware(CheckPermission::class .':69')
                ->name('doc_fin.update');
            
            Route::delete('doc_fin/{id}', [DocumentFinancement2Controller::class, 'destroy'])
                ->middleware(CheckPermission::class .':70')
                ->name('doc_fin.destroy');
            
            Route::patch('doc_fin/{id_projet}/toggle-statut2', [DocumentFinancement2Controller::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':71')
                ->name('doc_fin.toggle_statut');

			Route::get('/documents-financement/{id}/file', [DocumentFinancement2Controller::class, 'showFile'])
							->name('documents_financement.file');

            Route::get('/documents-financement/export/pdf', 
                    [DocumentFinancement2Controller::class, 'exportPdf']
                )->name('doc_fin.export.pdf');

                Route::get('/documents-financement/export/excel', 
                    [DocumentFinancement2Controller::class, 'exportExcel']
                )->name('doc_fin.export.excel');
Route::get('/doc_fin/{id}/pdf', [DocumentFinancement2Controller::class, 'pdf'] )
                ->name('doc_fin.show.pdf');


            /* Document22 financement public */
            Route::get('doc_fin2', [Document2FinancementController::class, 'index'])
                ->middleware(CheckPermission::class .':72')
                ->name('admin.doc_fin2.index');
            
            Route::get('doc_fin2/{id}/show', [Document2FinancementController::class, 'show'])
                ->middleware(CheckPermission::class .':73')
                ->name('admin.doc_fin2.show');
            
            Route::patch('doc_fin2/{id}/toggle-statut', [Document2FinancementController::class, 'toggleStatut'])
               ->middleware(CheckPermission::class .':74')
                ->name('admin.doc_fin2.toggle_statut');
            
            Route::get('doc_fin2/{id}/edit', [Document2FinancementController::class, 'edit'])
                ->middleware(CheckPermission::class .':75')
                ->name('admin.doc_fin2.edit');
            
            Route::put('doc_fin2/{id}', [Document2FinancementController::class, 'update'])
               ->middleware(CheckPermission::class .':75')
                ->name('admin.doc_fin2.update');
            
            Route::delete('doc_fin2/{id}', [Document2FinancementController::class, 'destroy'])
               ->middleware(CheckPermission::class .':76')
                ->name('admin.doc_fin2.destroy');
               
			Route::get('/decision-final/{id}', [Document2FinancementController::class, 'showDecision'])->name('decision_finale.show');

            Route::get('/documents-financement2/export/pdf', 
                    [Document2FinancementController::class, 'exportPdf']
                )->name('doc_fin2.export.pdf');
				Route::get('/doc_fin2/{id}/pdf', [Document2FinancementController::class, 'pdf'] )
                ->name('doc_fin2.show.pdf');

                Route::get('/documents-financement2/export/excel', 
                    [Document2FinancementController::class, 'exportExcel']
                )->name('doc_fin2.export.excel');
Route::get('/documents-financement/{id}/view', function ($id) {
    $doc = \App\Models\DocumentsFinancement::findOrFail($id);

    if (!$doc->file) {
        abort(404);
    }

    return response($doc->file)
        ->header('Content-Type', $doc->mime_type ?? 'application/octet-stream')
        ->header(
            'Content-Disposition',
            'inline; filename="'.$doc->file_name.'"'
        );
})->name('documents_financement.view');

            //Manifetation sportif
            Route::get('/manifestation', [ManifestationSportController::class, 'index'])
                ->middleware(CheckPermission::class .':77')
                ->name('admin.manifestation.index');
            
            Route::get('/manifestation/create', [ManifestationSportController::class, 'create'])
                ->middleware(CheckPermission::class .':78')
                ->name('admin.manifestation.create');
            
            Route::post('/manifestation/store', [ManifestationSportController::class, 'store'])
                ->middleware(CheckPermission::class .':78')
                ->name('admin.manifestation.store');
            
            Route::get('/manifestation/{id}/edit', [ManifestationSportController::class, 'edit'])
                ->middleware(CheckPermission::class .':79')
                ->name('admin.manifestation.edit');
        
            Route::put('/manifestation/{id}', [ManifestationSportController::class, 'update'])
                ->middleware(CheckPermission::class .':79')
                ->name('admin.manifestation.update');
            
            Route::get('/manifestation/{id}/show', [ManifestationSportController::class, 'show'])
                ->middleware(CheckPermission::class .':80')
                ->name('admin.manifestation.show');
            
            Route::delete('manifestation/{id}', [ManifestationSportController::class, 'destroy'])
                ->middleware(CheckPermission::class .':81')
                ->name('admin.manifestation.destroy'); 
            
            Route::patch('/manifestation/{id}/toggle-statut', [ManifestationSportController::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':82')
                ->name('admin.manifestation.toggle_statut');

           Route::get('/manifestation/export/excel', [ManifestationSportController::class, 'exportExcel'])
            ->middleware(CheckPermission::class .':77')
                ->name('admin.manifestation.export.excel');

            Route::get('/manifestation/export/pdf', [ManifestationSportController::class, 'exportPdf'])
            ->middleware(CheckPermission::class .':77')
                ->name('admin.manifestation.export.pdf');
              
                Route::get('/manifestation/demande/{id}/pdf', [ManifestationSportController::class, 'pdf'] )
                ->name('manifestation.demande.pdf');
            Route::get( '/manifestation/attachment/{id}', [ManifestationSportController::class, 'showfile'] )
                ->name('manifestation.attachment.show');
			Route::get('/manifestation/decision/{id}', [ManifestationSportController::class, 'showDecision'])
                ->name('manifestation.decision.show');
            Route::get('/manifestation/file/download/{id}', [ManifestationSportController::class, 'downloadDemandeFile'])
                ->name('manifestation.file.download');

            //Manifetation sportif Intern
            Route::get('/manifestation2', [ManifestationSport2Controller::class, 'index'])
               ->middleware(CheckPermission::class .':83') 
                ->name('admin.manifestation2.index');
            
            Route::get('/manifestation2/create', [ManifestationSport2Controller::class, 'create'])
                ->middleware(CheckPermission::class .':84')
                ->name('admin.manifestation2.create');
            
            Route::post('/manifestation2/store', [ManifestationSport2Controller::class, 'store'])
                ->middleware(CheckPermission::class .':84')
                ->name('admin.manifestation2.store');
            
            Route::get('/manifestation2/{id}/edit', [ManifestationSport2Controller::class, 'edit'])
                ->middleware(CheckPermission::class .':85')
                ->name('admin.manifestation2.edit');
            
            Route::put('/manifestation2/{id}', [ManifestationSport2Controller::class, 'update'])
                ->middleware(CheckPermission::class .':85')
                ->name('admin.manifestation2.update');
            
            Route::get('/manifestation2/{id}/show', [ManifestationSport2Controller::class, 'show'])
                ->middleware(CheckPermission::class .':86')
                ->name('admin.manifestation2.show');
            
            Route::delete('manifestation2/{id}', [ManifestationSport2Controller::class, 'destroy'])
                ->middleware(CheckPermission::class .':87')
                ->name('admin.manifestation2.destroy');
            
            Route::patch('/manifestation2/{id}/toggle-statut', [ManifestationSport2Controller::class, 'toggleStatut'])
                ->middleware(CheckPermission::class .':88')
                ->name('admin.manifestation2.toggle_statut');
            
            Route::get('/manifestationsport/export/pdf', [ManifestationSport2Controller::class, 'exportPdf'])
            ->middleware(CheckPermission::class .':83')
                ->name('admin.manifestationsport.export.pdf');

            Route::get('/manifestationsport/export/excel', [ManifestationSport2Controller::class, 'exportExcel'])
            ->middleware(CheckPermission::class .':83')
                ->name('admin.manifestationsport.export.excel');

                Route::get('/manifestation2/demande/{id}/pdf', [ManifestationSport2Controller::class, 'pdf'] )
                ->name('manifestation2.demande.pdf');
            Route::get( '/manifestation2/attachment/{id}', [ManifestationSport2Controller::class, 'showfile'] )
                ->name('manifestation2.attachment.show');
            Route::get('/manifestation2/decision/{id}', [ManifestationSport2Controller::class, 'showDecision'])
                ->name('manifestation2.decision.show');
            //GestionFront
            Route::get('/guides', [GestionFrontController::class, 'index'])
                ->middleware(CheckPermission::class .':93')
                ->name('guides.index');
            
            Route::get('/guides/create', [GestionFrontController::class, 'create'])
                ->middleware(CheckPermission::class .':94')
                ->name('guides.create');
            
            Route::post('/guides/store', [GestionFrontController::class, 'store'])
                ->middleware(CheckPermission::class .':94')
                ->name('guides.store');
            
            Route::get('/guides/{id}/edit', [GestionFrontController::class, 'edit'])
                ->middleware(CheckPermission::class .':95')
                ->name('guides.edit');
            
            Route::put('/guides/{id}', [GestionFrontController::class, 'update'])
                ->middleware(CheckPermission::class .':95')
                ->name('guides.update');
            
            Route::delete('/guides/{id}', [GestionFrontController::class, 'destroy'])
                ->middleware(CheckPermission::class .':96')
                ->name('guides.destroy');


            //Builder
            Route::get('/builder', [BuilderController::class, 'index'])
			->middleware(CheckPermission::class .':124')
			->name('builder.index');
            Route::get('/builder/create', [BuilderController::class, 'create'])
			->middleware(CheckPermission::class .':125')
			->name('builder.create');
            Route::post('/builder/store', [BuilderController::class, 'store'])
			->middleware(CheckPermission::class .':125')
			->name('builder.store');
            Route::get('/builder/{id}/edit', [BuilderController::class, 'edit'])
			->middleware(CheckPermission::class .':126')
			->name('builder.edit');
            Route::put('/builder/{id}', [BuilderController::class, 'update'])
			->middleware(CheckPermission::class .':126')
			->name('builder.update');
            Route::delete('/builder/{id}', [BuilderController::class, 'destroy'])
			->middleware(CheckPermission::class .':127')
			->name('builder.destroy');
 



            /*Route::get('/guides/{tp}', [GestionFrontController::class, 'index'])
                ->middleware(CheckPermission::class .':93')
                ->name('guides.index');
            
            Route::get('/guides/create/{type}', [GestionFrontController::class, 'create'])
                ->middleware(CheckPermission::class .':94')
                ->name('guides.create');
            
            Route::post('/guides/store', [GestionFrontController::class, 'store'])
                ->middleware(CheckPermission::class .':94')
                ->name('guides.store');
            
            Route::get('/guides/{id}/edit', [GestionFrontController::class, 'edit'])
                ->middleware(CheckPermission::class .':95')
                ->name('guides.edit');
            
            Route::put('/guides/{id}', [GestionFrontController::class, 'update'])
                ->middleware(CheckPermission::class .':95')
                ->name('guides.update');
            
            Route::delete('/guides/{id}', [GestionFrontController::class, 'destroy'])
                ->middleware(CheckPermission::class .':96')
                ->name('guides.destroy');
*/


            //gestion menus
            Route::get('/types', [GuideController::class, 'index'])
                ->middleware(CheckPermission::class .':89')
                ->name('types.index');
            
            Route::get('/types/create', [GuideController::class, 'create'])
                ->middleware(CheckPermission::class .':90')
                ->name('types.create');
            
            Route::post('/types', [GuideController::class, 'store'])
                ->middleware(CheckPermission::class .':90')
                ->name('types.store');
            
            Route::get('/types/{id}/edit', [GuideController::class, 'edit'])
                ->middleware(CheckPermission::class .':91')
                ->name('types.edit');
            
            Route::put('/types/{id}', [GuideController::class, 'update'])
                ->middleware(CheckPermission::class .':91')
                ->name('types.update');
            
            Route::delete('/types/{id}', [GuideController::class, 'destroy'])
                ->middleware(CheckPermission::class .':92')
                ->name('types.destroy');
        });
    });
});

/* API cin exemple */
$cin_list = [
    '12345678' => ['date_delivrance_cin' => '2025-01-01', 'nom_prenom' => 'علي بن أحمد', 'lieu_delivrance_cin' => 'تونس'],
    '87654321' => ['date_delivrance_cin' => '2024-05-10', 'nom_prenom' => 'سارة الرمضاني', 'lieu_delivrance_cin' => 'بنزرت'],
    '11223344' => ['date_delivrance_cin' => '2023-12-15', 'nom_prenom' => 'محمد خالد', 'lieu_delivrance_cin' => 'بن عروس'],
    '10785468' => ['date_delivrance_cin' => '2025-01-01', 'nom_prenom' => 'آدم صياري', 'lieu_delivrance_cin' => 'منوبة'],
    '80179632' => ['date_delivrance_cin' => '2024-05-10', 'nom_prenom' => 'سلمى مسعودي', 'lieu_delivrance_cin' => 'أريانة'],
    '10025412' => ['date_delivrance_cin' => '2023-12-15', 'nom_prenom' => 'مراد عوني', 'lieu_delivrance_cin' => 'المهدية'],
    '44987401' => ['date_delivrance_cin' => '2025-03-20', 'nom_prenom' => 'نور بن علي', 'lieu_delivrance_cin' => 'باجة'],
    '07845120' => ['date_delivrance_cin' => '2022-08-30', 'nom_prenom' => 'راوية بن سالم', 'lieu_delivrance_cin' => 'سوسة'],
];

Route::post('/api/check-cin', function (Request $request) use ($cin_list) {
    $request->validate([
        'cin' => 'required|size:8',
        'date_delivrance_cin' => 'required|date',
    ]);

    if (isset($cin_list[$request->cin]) && $cin_list[$request->cin]['date_delivrance_cin'] === $request->date_delivrance_cin) {
        return response()->json([
            'status' => 'success',
            'message' => 'CIN vérifié avec succès',
            'data' => [
                'cin' => $request->cin,
                'date_delivrance_cin' => $cin_list[$request->cin]['date_delivrance_cin'],
                'nom_prenom' => $cin_list[$request->cin]['nom_prenom'],
                'lieu_delivrance_cin' => $cin_list[$request->cin]['lieu_delivrance_cin'],
            ],
        ]);
    }

    return response()->json([
        'status' => 'error',
        'message' => 'رقم بطاقة التعريف غير صالح أو تاريخ الإصدار غير صحيح',
    ], 422);
});


Route::prefix('investissement')->group(function () {
    Route::get('debut-activite/create', [DebutActiviteController::class, 'create2'])
        ->name('debut_activite.create2'); 
});
    Route::get('/investissement/salle-sport2', [SalleSportController::class, 'index2'])->name('salle-sport.index2');