<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>تحديث حالة طلب قاعة الرياضة</title>
</head>
<body>
    <div class="email-wrapper" style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 600px; margin: 20px auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px;">
        <div class="header" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center;">
            تحديث حالة طلب قاعة الرياضة
        </div>

        <div class="content" style="line-height: 1.6; color: #222;">
            <p>مرحباً <strong>{{ $user->nom_prenom ?? 'المستخدم' }}</strong>،</p>



<div style="margin-bottom: 10px;">
    @if($type === 'accepte')
        <p>نحن سعداء بإبلاغكم أن طلبكم <strong>تم قبوله</strong>.</p>
        @if(!empty($commentaire))
            <p><strong>ملاحظة:</strong><br>{{ $commentaire }}</p>
        @endif
        <p>يمكنكم الآن متابعة استكمال إجراءات بداية النشاط.</p>

    @elseif($type === 'refuse')
        <p>نأسف لإبلاغكم أن طلبكم <strong>تم رفضه</strong>.</p>
        @if(!empty($commentaire))
            <p><strong>سبب الرفض :</strong><br>{{ $commentaire }}</p>
        @endif

    @elseif($type === 'incomplet')
        <p>طلبكم <strong>غير مكتمل</strong>. يرجى استكمال النواقص التالية:</p>
        @if(!empty($commentaire))
            <p><strong>النواقص المطلوبة :</strong><br>{{ $commentaire }}</p>
        @else
            <p>يرجى الرجوع للمنصة لمعرفة النواقص.</p>
        @endif

    @elseif($type === 'deferre')
        <p>تم <strong>إرجاء</strong> طلبكم لإبداء الرأي.</p>
        @if(!empty($commentaire))
            <p><strong>الملاحظة :</strong><br>{{ $commentaire }}</p>
        @else
            <p>سيتم إبلاغكم بالإجراءات التالية لاحقاً.</p>
        @endif

    @else
        <p>تم تحديث حالة ملفكم. الرجاء مراجعة المنصة لمزيد من التفاصيل.</p>
        @if(!empty($commentaire))
            <p><strong>ملاحظة :</strong><br>{{ $commentaire }}</p>
        @endif
    @endif
</div>





            <p style="margin-top: 15px;">نشكركم على تعاونكم واهتمامكم.</p>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #eee;">

        <div class="footer" style="text-align: center; font-size: 12px; color: #555;">
            <div class="app-name"> وزارة الشباب والرياضة </div>
        </div>
    </div>
</body>
</html>
