<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>حالة المشروع</title>
</head>
<body>
    <div class="email-wrapper" style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 600px; margin: 20px auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px;">
        <div class="header" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center;">
            إشعار بخصوص حالة طلب الاستثمار
        </div>

        <div class="content" style="line-height: 1.6; color: #222;">
            <p>مرحباً <strong>{{ $user->nom_prenom ?? 'مستخدم' }}</strong>،</p>

            @if(isset($type) && $type === 'accepte')
                <p>يسعدنا إعلامكم بأن طلب الاستثمار الخاص بكم في <strong>الأنشطة/المؤسسات الخاصة بالشباب و الأطفال</strong> قد تم <strong>القبول</strong>.</p>
                <p>سيتم التواصل معكم لاحقًا لمتابعة إجراءات استكمال الملف.</p>

            @elseif(isset($type) && $type === 'refuse')
                <p>نأسف لإعلامكم أن طلب الاستثمار الخاص بكم في <strong>الأنشطة/المؤسسات الخاصة بالشباب و الأطفال</strong> قد تم <strong>الرفض</strong>.</p>
                @if(!empty($motif))
                    <div style="margin-top:10px;">
                        <strong>سبب الرفض:</strong>
                        <div style="margin-top:6px;">{{ $motif }}</div>
                    </div>
                @endif

            @elseif(isset($type) && $type === 'incomplet')
                <p>تم تصنيف طلبكم على أنه <strong>غير مكتمل</strong>. الرجاء استكمال الوثائق أو المعلومات التالية:</p>
                @if(!empty($motif))
                    <div style="margin-top:10px;">{{ $motif }}</div>
                @else
                    <div style="margin-top:10px;">(الرجاء مراجعة حسابكم أو مراسلة الإدارة لمعرفة التفاصيل)</div>
                @endif

            @elseif(isset($type) && $type === 'deferre')
                <p>تم إرجاء القرار المتعلق بطلبكم لــ <strong>إبداء الرأي</strong> أو لمزيد من الدراسة.</p>
                @if(!empty($motif))
                    <div style="margin-top:10px;"><strong>ملاحظة:</strong><br>{{ $motif }}</div>
                @endif

            @else
                <p>تم تحديث حالة طلبكم. يرجى التحقق من حسابكم للمزيد من التفاصيل.</p>
            @endif

            <p style="margin-top: 15px;">شكراً لتعاونكم،<br>وزارة الشباب والرياضة</p>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #eee;">
        <div class="footer" style="text-align: center; font-size: 12px; color: #555;">
            وزارة الشباب والرياضة
        </div>
    </div>
</body>
</html>
