<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>تحديث حالة المشروع</title>
</head>
<body>
    <div class="email-wrapper" style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 600px; margin: 20px auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px;">
        <div class="header" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center;">
            تحديث حالة طلب الاستثمار  في مجال مركز التربصات وتكوين الرياضيين
        </div>

        <div class="content" style="line-height: 1.6; color: #222;">
            <p>مرحباً <strong>{{ $user->nom_prenom ?? 'المستخدم' }}</strong>،</p>

            @if($type === 'accepte')
                <p>نحيطكم علماً بأنه تم <strong>قبول</strong> مشروعكم ضمن مجال الاستثمار الرياضي. يمكنك/يمكنكِ متابعة الإجراءات التالية واستلام الإرشادات من خلال لوحة المستخدم.</p>

            @elseif($type === 'refuse')
                <p>نأسف لإبلاغكم أن طلبكم <strong>لم يتم قبوله</strong>.</p>
                @if(!empty($motif))
                    <div style="margin-top:10px;">
                        <strong>سبب القرار:</strong>
                        <div style="margin-top:6px;">{{ $motif }}</div>
                    </div>
                @endif

            @elseif($type === 'incomplet')
                <p>طلبكم مصنّف على أنه <strong>غير مكتمل</strong>. الرجاء استكمال الوثائق أو المعلومات التالية:</p>
                @if(!empty($motif))
                    <div style="margin-top:10px;">{{ $motif }}</div>
                @else
                    <div style="margin-top:10px;">يرجى مراجعة طلبكم وإضافة الوثائق المطلوبة ثم إعادة الإرسال.</div>
                @endif

            @elseif($type === 'deferre')
                <p>تم إرجاء قرار طلبكم لمزيد من الدراسة.</p>
                @if(!empty($motif))
                    <p style="margin-top:10px;"><strong>ملاحظة من اللجنة:</strong><br>{{ $motif }}</p>
                @endif

            @else
                <p>تم تحديث حالة طلبكم. يرجى التحقق من حسابكم للحصول على مزيد من التفاصيل.</p>
            @endif

            <p style="margin-top: 15px;">نشكركم على تعاونكم واهتمامكم.</p>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #eee;">

        <div class="footer" style="text-align: center; font-size: 12px; color: #555;">
            وزارة الشباب والرياضة
        </div>
    </div>
</body>
</html>
