@extends('backoffice.dashboard')

@section('title', $trophee_sportif->title)

@section('content')
<div class="container mt-4" dir="rtl">
    <div class="card shadow-sm border-0">
        <div class="card-body">
            {{-- العنوان --}}
            <h2 class="text-center mb-4" style="color:#a52a2a; font-weight:bold;">
                {{ $trophee_sportif->title }}
            </h2>

            {{-- الصورة --}}
            @if($trophee_sportif->image)
                <div class="text-center mb-4">
                    <img 					src="data:image/*;base64,{{ base64_encode($trophee_sportif->image) }}"
                         class="img-fluid rounded shadow-sm"
                         style="max-height: 250px; width:auto; border: 2px solid #eee;">
                </div>
            @endif

            {{-- الفيديو والمحتوى --}}
            <div class="row align-items-start mt-4" style="text-align: right;">
                {{-- الفيديو --}}
                @if($embed)
                    <div class="col-md-5 mb-4">
                        <div class="ratio ratio-16x9 rounded overflow-hidden shadow-sm">
                            <iframe src="{{ $embed }}" 
                                    title="فيديو يوتيوب"
                                    frameborder="0" 
                                    allowfullscreen></iframe>
                        </div>
                    </div>
                @endif

                {{-- المحتوى --}}
                <div class="col-md-7" style="line-height: 1.9; font-size: 1.1rem; color:#333;">
                    {!! $trophee_sportif->content !!}
                </div>
            </div>

            {{-- زر الرجوع --}}
            <div class="text-center mt-5">
                <a href="{{ route('trophee_sportif.index') }}" 
                   class="btn btn-secondary px-4 py-2" 
                   style="font-size:1rem;">
                    ← الرجوع إلى القائمة
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
