@extends('backoffice.dashboard')

@section('title', 'تعديل مشترك')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">

                    <form method="POST" action="{{ route('newsletters.update', $newsletter) }}">
                        @csrf
                        @method('PUT')

                        {{-- wrapper card (same architecture as guides edit) --}}
                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">تعديل المشترك</h2>
                                <div class="stroke-shape"></div>
                            </div>

                            <div class="block-card-body">

                                {{-- Meta info --}}
                                <div class="row mb-3">
                                    {{-- <div class="col-md-4">
                                        <div class="form-group">
                                            <label>المعرف</label>
                                            <div class="form-control-plaintext">{{ $newsletter->id }}</div>
                                        </div>
                                    </div> --}}

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>تاريخ الإنشاء</label>
                                            <div class="form-control-plaintext">{{ optional($newsletter->created_at)->format('Y-m-d H:i') }}</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        {{-- <div class="form-group">
                                            <label>حالة</label>
                                            <div class="form-control-plaintext">{{ $newsletter->email ? 'موجود' : '—' }}</div>
                                        </div> --}}
                                    </div>
                                </div>

                                {{-- Email field --}}
                                <div class="form-group mb-3">
                                    <label>البريد الإلكتروني <span class="text-danger">*</span></label>
                                    <input type="email"
                                           name="email"
                                           class="form-control @error('email') is-invalid @enderror"
                                           value="{{ old('email', $newsletter->email) }}"
                                           required>
                                    @error('email')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>

                            <div class="block-card-footer mt-3 mb-3 text-center">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-save mr-1"></i> حفظ
                                </button>

                                <a href="{{ route('newsletters.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-times mr-1"></i> إلغاء
                                </a>

                                {{-- حذف سريع --}}
                              
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </section>
</div>

<script>
    // small client-side enhancement: disable submit button after click to avoid double submit
    document.addEventListener('DOMContentLoaded', function () {
        const frm = document.querySelector('form[action="{{ route('newsletters.update', $newsletter) }}"]');
        if (!frm) return;
        frm.addEventListener('submit', function (e) {
            const btn = frm.querySelector('button[type="submit"]');
            if (btn) {
                btn.setAttribute('disabled', 'disabled');
                btn.innerHTML = '<i class="la la-spinner la-spin mr-1"></i> جاري الحفظ...';
            }
        });
    });
</script>

@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
