@csrf
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; box-shadow: 0 0 0 .15rem rgba(217,83,79,.12); }
  .is-valid { border-color: #28a745 !important; box-shadow: 0 0 0 .15rem rgba(40,167,69,.08); }
  .validation-summary { display:none; margin-bottom:1rem; padding: .75rem 1rem; border-radius:6px; background: #fff3f2; color: #b02a37; border:1px solid #f5c2c7; }
</style>

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="validation-summary" id="validationSummary"></div>

<div class="block-card mb-4">
  <div class="block-card-header">
    <h2 class="widget-title">{{ $formTitle ?? 'نموذج الخبر' }}</h2>
    <div class="stroke-shape"></div>
  </div>

  <div class="block-card-body">
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>التاريخ <span class="text-danger">*</span></label>
            <input type="date" name="date" id="date" required
                    class="form-control @error('date') is-invalid @enderror"
                    value="{{ old('date', $news->date ?? '') }}">
            <span id="error_date" class="field-error">الرجاء تحديد التاريخ.</span>
            @error('date')
                <span class="field-error d-block">{{ $message }}</span>
            @enderror
        </div>

      <div class="col-md-6">
        <label>العنوان بالعربية <span class="text-danger">*</span></label>
        <input type="text" required maxlength="255" name="title" id="title" class="form-control" value="{{ old('title', $news->title ?? '') }}">
        <span id="error_title" class="field-error">الرجاء إدخال العنوان بالعربية.</span>
        @error('title')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
      </div>
    </div>

    <div class="form-group row mb-3">
      <div class="col-md-6">
        <label>العنوان بالفرنسية <span class="text-danger">*</span></label>
        <input type="text" required maxlength="255" name="title_fr" id="title_fr" class="form-control" value="{{ old('title_fr', $news->title_fr ?? '') }}">
        <span id="error_title_fr" class="field-error">الرجاء إدخال العنوان بالفرنسية.</span>
        @error('title_fr')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
      </div>

      <div class="col-md-6">
        <label>العنوان بالإنجليزية <span class="text-danger">*</span></label>
        <input type="text" required maxlength="255" name="title_en" id="title_en" class="form-control" value="{{ old('title_en', $news->title_en ?? '') }}">
        <span id="error_title_en" class="field-error">الرجاء إدخال العنوان بالإنجليزية.</span>
        @error('title_en')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
      </div>
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">المحتوى بالعربية<span class="text-danger">*</span></label>
      <textarea name="content" required maxlength="100000" id="editor_ar" class="form-control" rows="10">{{ old('content', $news->content ?? '') }}</textarea>
      <span id="error_content_ar" class="field-error">الرجاء إدخال المحتوى بالعربية.</span>
      @error('content')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالعربية<span class="text-danger">*</span></label>
      <textarea name="resume_ar"  maxlength="255" id="resume_ar" class="form-control" rows="3" required>{{ old('resume_ar', $news->resume_ar ?? '') }}</textarea>
      <span id="error_resume_ar" class="field-error">الرجاء إدخال الملخّص بالعربية.</span>
      @error('resume_ar')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3">
      <label class="fw-bold mb-2">المحتوى بالفرنسية<span class="text-danger">*</span></label>
      <textarea name="content_fr" required maxlength="100000" id="editor_fr" class="form-control" rows="10">{{ old('content_fr', $news->content_fr ?? '') }}</textarea>
      <span id="error_content_fr" class="field-error">الرجاء إدخال المحتوى بالفرنسية.</span>
      @error('content_fr')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالفرنسية<span class="text-danger">*</span></label>
      <textarea name="resume_fr" id="resume_fr" required maxlength="255" class="form-control" rows="3" >{{ old('resume_fr', $news->resume_fr ?? '') }}</textarea>
      <span id="error_resume_fr" class="field-error">الرجاء إدخال الملخّص بالفرنسية.</span>
      @error('resume_fr')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3">
      <label class="fw-bold mb-2">المحتوى بالانقليزية<span class="text-danger">*</span></label>
      <textarea name="content_en" required maxlength="100000" id="editor_en" class="form-control" rows="10">{{ old('content_en', $news->content_en ?? '') }}</textarea>
      <span id="error_content_en" class="field-error">الرجاء إدخال المحتوى بالإنجليزية.</span>
      @error('content_en')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالانقليزية<span class="text-danger">*</span></label>
      <textarea name="resume_en" id="resume_en" class="form-control" rows="3" required maxlength="255">{{ old('resume_en', $news->resume_en ?? '') }}</textarea>
      <span id="error_resume_en" class="field-error">الرجاء إدخال الملخّص بالإنجليزية.</span>
      @error('resume_en')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

   <div class="form-group mb-3">
  <label>صورة الخبر</label>
  <input type="file" name="image" id="image" class="form-control" accept="image/*">
  <span id="error_image" class="field-error">صورة غير صالحة أو أكبر من 2 ميغابايت.</span>

  @if(!empty($news->imageSrc))
    <div class="mt-2">
      <img
        src="{{ $news->imageSrc }}"
        alt="{{ function_exists('trans_field') ? (trans_field($news,'title') ?? __('site.no_image_alt')) : ($news->title ?? __('site.no_image_alt')) }}"
        style="height:100px; border-radius:8px; object-fit:cover;">
    </div>
  @elseif(!empty($news->image) && is_string($news->image) && preg_match('/^data:/', $news->image))
    {{-- fallback if stored value itself is a data: URI --}}
    <div class="mt-2">
      <img src="{{ $news->image }}" alt="صورة الخبر" style="height:100px; border-radius:8px; object-fit:cover;">
    </div>
  @endif
</div>


    <div class="form-group mb-3">
      <label>رابط YouTube</label>
      <input type="text" name="youtube_url" id="youtube_url" class="form-control" value="{{ old('youtube_url', $news->youtube_url ?? '') }}" placeholder="https://www.youtube.com/watch?v=...">
      <span id="error_youtube" class="field-error">الرجاء إدخال رابط YouTube صالح أو إزالته.</span>
    </div>

    <div class="form-check mb-3">
      <input type="hidden" name="published" value="0">
      <input type="checkbox" name="published" value="1" class="form-check-input" id="published" {{ old('published', $news->published ?? false) ? 'checked' : '' }}>
      <label for="published" class="form-check-label">منشور</label>
    </div>
  </div>

  <div class="block-card-footer mt-3 mb-3 text-center">
    <button type="submit" id="submitBtn" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-save mr-1"></i> حفظ
    </button>
    <a href="{{ route('news.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-times mr-1"></i> إلغاء
    </a>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js" referrerpolicy="origin"></script>
<!-- Add / replace this CSS + script block after your form -->
<!-- Single CSS + script block: paste once after your form (remove the other validation blocks) -->
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; box-shadow: 0 0 0 .075rem rgba(217,83,79,.15); }
  .is-valid { border-color: #28a745 !important; box-shadow: 0 0 0 .075rem rgba(40,167,69,.15); }
  .validation-summary { display:none; margin-bottom:1rem; padding: .75rem 1rem; border-radius:6px; background: #fff3f2; color: #b02a37; border:1px solid #f5c2c7; }
  .tox-tinymce.is-invalid { outline: 3px solid rgba(217,83,79,.12); }
  .tox-tinymce.is-valid { outline: 3px solid rgba(40,167,69,.12); }
</style>

<div id="validationSummary" class="validation-summary"></div>

<script>
(function(){
  /* small helpers */
  function stripHtml(html){
    const tmp = document.createElement("DIV"); tmp.innerHTML = html || ""; return (tmp.textContent || tmp.innerText || "").trim();
  }
  function ensureErrorSpan(el, id){
    if(!el) return null;
    if(id){
      const e = document.getElementById(id);
      if(e) return e;
    }
    const sibling = el.parentNode.querySelector('.field-error');
    if(sibling) return sibling;
    const span = document.createElement('div'); span.className = 'field-error'; if(id) span.id = id;
    el.parentNode.appendChild(span); return span;
  }
  function markInvalid(el, msg){
    if(!el) return;
    el.classList.remove('is-valid'); el.classList.add('is-invalid');
    const span = ensureErrorSpan(el); if(span){ span.innerText = msg; span.style.display = 'block'; }
  }
  function markValid(el){
    if(!el) return;
    el.classList.remove('is-invalid'); el.classList.add('is-valid');
    const span = ensureErrorSpan(el); if(span){ span.style.display = 'none'; span.innerText = ''; }
  }
  function clearValidation(root){
    root.querySelectorAll('.is-invalid').forEach(i => i.classList.remove('is-invalid'));
    root.querySelectorAll('.is-valid').forEach(i => i.classList.remove('is-valid'));
    root.querySelectorAll('.field-error').forEach(s => { s.style.display = 'none'; s.innerText = ''; });
    document.querySelectorAll('.tox-tinymce.is-invalid, .tox-tinymce.is-valid').forEach(c => { c.classList.remove('is-invalid','is-valid'); });
  }
  function isYouTubeUrl(url){
    if(!url) return false;
    const patterns = [/^https?:\/\/(www\.)?youtube\.com\/watch\?v=[\w-]+(&.*)?$/i, /^https?:\/\/youtu\.be\/[\w-]+$/i];
    return patterns.some(rx => rx.test(url.trim()));
  }

  /* field validators */
  function validateText(selector, friendlyName, required=true, maxLen=null){
    const el = document.querySelector(selector); if(!el) return true;
    const v = (el.value || '').trim();
    if(required && !v){ markInvalid(el, friendlyName + ' مطلوب.'); return false; }
    if(maxLen && v.length > maxLen){ markInvalid(el, friendlyName + ' يجب ألا يتجاوز ' + maxLen + ' حرفاً.'); return false; }
    if(v) markValid(el); else if(!required) markValid(el);
    return true;
  }
  function validateDate(selector, friendlyName){
    const el = document.querySelector(selector); if(!el) return true;
    const v = (el.value || '').trim();
    if(!v){ markInvalid(el, friendlyName + ' مطلوب.'); return false; }
    const d = Date.parse(v); if(isNaN(d)){ markInvalid(el, 'الرجاء تحديد تاريخ صالح.'); return false; }
    markValid(el); return true;
  }
  function validateFile(selector, friendlyName, required=false, maxBytes=2*1024*1024){
    const el = document.querySelector(selector); if(!el) return true;
    if(el.files && el.files.length){
      const f = el.files[0];
      if(!f.type.startsWith('image/')){ markInvalid(el, friendlyName + ' يجب أن يكون صورة.'); return false; }
      if(f.size > maxBytes){ markInvalid(el, friendlyName + ' يجب ألا يتجاوز 2 ميغابايت.'); return false; }
      markValid(el); return true;
    } else {
      if(required){ markInvalid(el, friendlyName + ' مطلوب.'); return false; }
      el.classList.remove('is-invalid','is-valid'); return true;
    }
  }
  function validateYouTube(selector, friendlyName){
    const el = document.querySelector(selector); if(!el) return true;
    const v = (el.value || '').trim();
    if(!v){ el.classList.remove('is-invalid','is-valid'); return true; }
    if(!isYouTubeUrl(v)){ markInvalid(el, friendlyName + ' غير صالح.'); return false; }
    markValid(el); return true;
  }
  function markTinyMCE(editorId, valid, message){
    const ta = document.getElementById(editorId); const ed = tinymce.get(editorId);
    if(ta){ if(valid) markValid(ta); else markInvalid(ta, message); }
    if(ed && ed.getContainer){ const c = ed.getContainer(); if(valid){ c.classList.remove('is-invalid'); c.classList.add('is-valid'); } else { c.classList.remove('is-valid'); c.classList.add('is-invalid'); } }
  }
  function validateEditor(editorId, friendlyName, required=true, maxLen=100000){
    const ed = tinymce.get(editorId); const ta = document.getElementById(editorId);
    const raw = ed ? ed.getContent() : (ta ? ta.value : '');
    const text = stripHtml(raw);
    if(required && !text){ markTinyMCE(editorId, false, friendlyName + ' مطلوب.'); return false; }
    if(maxLen && text.length > maxLen){ markTinyMCE(editorId, false, friendlyName + ' تجاوز الحد الأقصى ('+maxLen+').'); return false; }
    markTinyMCE(editorId, true, ''); return true;
  }

  /* init */
  document.addEventListener('DOMContentLoaded', function(){
    // choose the form (prefer form that contains the submit button)
    let form = document.querySelector('form');
    const submitBtn = document.getElementById('submitBtn');
    if(submitBtn){
      const f = submitBtn.closest('form');
      if(f) form = f;
    }
    if(!form) return;

    // disable browser native validation so our JS runs every time
    form.setAttribute('novalidate','novalidate');

    // wire live validation (fields turn green as user types/changes)
    const liveIds = ['#date','#title','#title_fr','#title_en','#resume_ar','#resume_fr','#resume_en','#youtube_url','input[type="file"][name="image"]'];
    liveIds.forEach(sel=>{
      const el = form.querySelector(sel); if(!el) return;
      const ev = (el.tagName === 'INPUT' && el.type === 'file') ? 'change' : 'input';
      el.addEventListener(ev, function(){
        if(sel === '#date') validateDate('#date','التاريخ');
        else if(sel === '#youtube_url') validateYouTube('#youtube_url','رابط YouTube');
        else if(sel.indexOf('input[type="file"') === 0) validateFile('input[type="file"][name="image"]','صورة الخبر', false);
        else {
          if(sel === '#title' || sel === '#title_fr' || sel === '#title_en') validateText(sel,'العنوان', true, 255);
          else validateText(sel,'الملخّص', true, 1000);
        }
      });
    });

    // tinyMCE live binding (retry until editor ready)
    function bindEditorLive(id){
      const tryBind = () => {
        const ed = tinymce.get(id);
        const ta = document.getElementById(id);
        if(ed){ ed.on('keyup change', ()=> validateEditor(id, id==='editor_ar' ? 'المحتوى بالعربية' : id==='editor_fr' ? 'المحتوى بالفرنسية' : 'المحتوى بالإنجليزية', true, 100000)); }
        else if(ta){ ta.addEventListener('input', ()=> validateEditor(id, 'المحتوى', true, 100000)); }
        else { setTimeout(tryBind, 200); }
      };
      tryBind();
    }
    bindEditorLive('editor_ar'); bindEditorLive('editor_fr'); bindEditorLive('editor_en');

    // submit handler
    form.addEventListener('submit', function(e){
      // copy tinyMCE content into textareas (so validators & server see content)
      if(tinymce.get('editor_ar')) document.querySelector('textarea[name="content"]').value = tinymce.get('editor_ar').getContent();
      if(tinymce.get('editor_fr')) document.querySelector('textarea[name="content_fr"]').value = tinymce.get('editor_fr').getContent();
      if(tinymce.get('editor_en')) document.querySelector('textarea[name="content_en"]').value = tinymce.get('editor_en').getContent();

      clearValidation(form);
      const summary = document.getElementById('validationSummary'); summary.style.display = 'none'; summary.innerText = '';

      let firstInvalid = null;
      if(!validateDate('#date','التاريخ')) firstInvalid = firstInvalid || document.getElementById('date');
      if(!validateText('#title','العنوان بالعربية', true, 255)) firstInvalid = firstInvalid || document.getElementById('title');
      if(!validateText('#title_fr','العنوان بالفرنسية', true, 255)) firstInvalid = firstInvalid || document.getElementById('title_fr');
      if(!validateText('#title_en','العنوان بالإنجليزية', true, 255)) firstInvalid = firstInvalid || document.getElementById('title_en');

      if(!validateText('#resume_ar','الملخّص بالعربية', true, 255)) firstInvalid = firstInvalid || document.getElementById('resume_ar');
      if(!validateText('#resume_fr','الملخّص بالفرنسية', true, 255)) firstInvalid = firstInvalid || document.getElementById('resume_fr');
      if(!validateText('#resume_en','الملخّص بالإنجليزية', true, 255)) firstInvalid = firstInvalid || document.getElementById('resume_en');

      if(!validateEditor('editor_ar','المحتوى بالعربية', true, 100000)) firstInvalid = firstInvalid || (document.getElementById('editor_ar') || document.querySelector('.tox-tinymce'));
      if(!validateEditor('editor_fr','المحتوى بالفرنسية', true, 100000)) firstInvalid = firstInvalid || (document.getElementById('editor_fr') || document.querySelector('.tox-tinymce'));
      if(!validateEditor('editor_en','المحتوى بالإنجليزية', true, 100000)) firstInvalid = firstInvalid || (document.getElementById('editor_en') || document.querySelector('.tox-tinymce'));

      if(!validateYouTube('#youtube_url','رابط YouTube')) firstInvalid = firstInvalid || document.getElementById('youtube_url');
      if(!validateFile('input[type="file"][name="image"]','صورة الخبر', false, 2*1024*1024)) firstInvalid = firstInvalid || document.querySelector('input[type="file"][name="image"]');
// --- mark optional (non-required) fields as valid (but don't override invalid) ---
Array.from(form.querySelectorAll('input,textarea,select')).forEach(el => {
  if (!el) return;
  if (el.disabled || el.type === 'submit' || el.type === 'button' || el.type === 'reset') return;
  if (el.hasAttribute('required')) return; // skip required, they already have state
  // skip TinyMCE textareas handled separately (if they are editors and required/optional you can adapt)
  if (el.tagName === 'TEXTAREA' && (el.id === 'editor_ar' || el.id === 'editor_fr' || el.id === 'editor_en')) {
    // if editors are optional and empty, mark their container valid
    const ed = tinymce.get(el.id);
    if (!ed) { if (!el.classList.contains('is-invalid')) el.classList.add('is-valid'); }
    else {
      const c = ed.getContainer();
      if (c && !c.classList.contains('is-invalid')) c.classList.add('is-valid');
      if (!el.classList.contains('is-invalid')) el.classList.add('is-valid');
    }
    return;
  }

  // file inputs: if no file chosen, consider them valid (optional)
  if (el.type === 'file') {
    if (!(el.files && el.files.length) && !el.classList.contains('is-invalid')) {
      el.classList.remove('is-invalid'); el.classList.add('is-valid');
    }
    return;
  }

  // for checkboxes/radios mark valid (optional)
  if (el.type === 'checkbox' || el.type === 'radio') {
    if (!el.classList.contains('is-invalid')) { el.classList.add('is-valid'); }
    return;
  }

  // generic: if not already invalid, mark valid
  if (!el.classList.contains('is-invalid')) {
    el.classList.remove('is-valid'); // ensure no duplicate state
    el.classList.add('is-valid');
    const span = el.parentNode?.querySelector('.field-error');
    if (span) { span.style.display = 'none'; span.innerText = ''; }
  }
});

      if(firstInvalid){
        e.preventDefault();
        
        try{ firstInvalid.focus(); }catch(_){}
        firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
        return false;
      }
      // all good -> allow submit
      return true;
    });
  });
})();
</script>
