@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">

        
		
		
		<div class="block-card-header px-4 pb-3 border-bottom-0">
            <div class="d-flex flex-wrap align-items-center justify-content-between">
                <h2 class="widget-title mb-0">
                   طلبات التظاهرات الرياضية الدولية
                </h2>
                <div class="d-flex align-items-center gap-2 action-buttons">
                    <a href="{{ route('admin.manifestationsport.export.excel', request()->query()) }}" 
                        class="btn btn-outline-primary btn-icon btn-icon-excel d-flex align-items-center justify-content-center"
                        title="Excel">
                            <i class="fa-solid fa-file-excel"></i>
                        </a>

                    <a href="{{ route('admin.manifestationsport.export.pdf', request()->query()) }}" target="_blank"
                        class="btn btn-outline-danger btn-icon btn-icon-pdf d-flex align-items-center justify-content-center"
                        title="PDF">
                            <i class="fa-solid fa-file-pdf"></i>
                        </a>
                   <!-- <a href="{{ route('admin.manifestation2.create') }}"
                    class="btn btn-success d-flex align-items-center justify-content-center">
                        <i class="la la-plus me-1"></i>
                        إضافة طلب
                    </a>-->
                    <style>
                        .action-buttons .btn {
                            height: 42px;       
                            min-width: 42px;       
                            padding: 0 14px;
                        }

                        .btn-icon-excel {
                            background-color: #fff !important;
                            border: 1px solid #0d6efd !important;   
                            color: #0d6efd !important;               
                        }

                        .btn-icon-excel:hover {
                            background-color: #e3f2fd !important;   
                            color: #0d6efd !important;                
                            border-color: #0d6efd !important;
                        }

                        .btn-icon-excel i {
                            color: inherit !important;
                        }


                        .btn-icon-pdf {
                            background-color: #fff !important;
                            border: 1px solid #e74c3c !important;   
                            color: #e74c3c!important;               
                        }

                        .btn-icon-pdf:hover {
                            background-color: #fde8ea !important;  
                            color: #e74c3c!important;               
                            border-color: #e74c3c !important;
                        }

                        .btn-icon-pdf i {
                            color: inherit !important;
                        }

                </style> 
                </div>
            </div>
        </div>

        <!-- Filtres -->
        <div class="block-card-header px-4 border-bottom-0 pb-0">
          <form method="GET" action="{{ route('admin.manifestation2.index') }}">
            <div class="form-row align-items-center">
              <div class="col-auto" style="width: 200px;">
                <select class="form-control" name="search_option" onchange="showSearchInput(this.value)">
                  <option value="">اختر نوع البحث</option>
                  <option value="date" {{ request('search_option') == 'date' ? 'selected' : '' }}>تاريخ التقديم</option>
                  <option value="type_identite" {{ request('search_option') == 'type_identite' ? 'selected' : '' }}>نوع الهوية</option>
                </select>
              </div>
              <div class="col-auto" id="searchByDate" style="display:none; width: 180px;">
                <input type="date" class="form-control" name="date" value="{{ request('date') }}">
              </div>
              <div class="col-auto" id="searchByTypeIdentite" style="display:none; width: 200px;">
                <select class="form-control" name="type_identite">
                  <option value="">-- اختر نوع الهوية --</option>
                  @foreach($typesIdentite as $type)
                    <option value="{{ $type->id_type }}" {{ request('type_identite') == $type->id_type ? 'selected' : '' }}>
                      {{ $type->type_ar }}
                    </option>
                  @endforeach
                </select>
              </div>
              
			  <div class="col d-flex">
                        <button type="submit" 
                                class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                style="width: 105px;">
                            بحث
                        </button>
                        <a href="{{ route('admin.manifestation2.index') }}"
                        class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                        style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                            <i class="fa-solid fa-rotate-right" style="font-size: 16px;"></i>
                        </a>
                    </div>
            </div>
          </form>
        </div>

        <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
    <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
        <thead class="thead-light">
            <tr>
                <th>المعرف</th>
                <th>رقم الملف</th>
                <th>اسم الهيكل</th>
                <th>اسم التظاهرة</th>
                <th>التاريخ</th>
                <th>الساعة</th>
                <th>الولاية</th>
                <th>البلدية</th>
                <th>الحالة</th>
                <th width="15%">إجراءات</th>
            </tr>
        </thead>
        <tbody>
            @forelse($rows as $i => $row)
            <tr>
                <td>{{ $i + 1 }}</td>
                <td>{{ $row->num_dossier }}</td>
                <td>{{ $row->nom_organisme ?? '-' }}</td>
                <td>{{ $row->nom_evenement ?? '-' }}</td>
                <td>{{ $row->date_even ?? '-' }}</td>
                <td>{{ $row->heure_even ?? '-' }}</td>
                <td>{{ $row->gouvernorat ?? ($row->raw->evenementSportifs->first()?->gouvernorat->nom_ar ?? '-') }}</td>
                <td>{{ $row->delegation ?? ($row->raw->evenementSportifs->first()?->delegation->nom_ar ?? '-') }}</td>
                <td>
                    <span class="status-badge 
                    {{ $row->statut?->statut_ar == 'قبول' ? 'status-badge--success' : 
                       ($row->statut?->statut_ar == 'رفض' ? 'status-badge--danger' : 'status-badge--pending') }}">
                      {{ $row->statut?->statut_ar ?? 'في الانتظار' }}
                  </span>
                </td>
                <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                                <a href="{{ route('admin.manifestation2.show', $row->id_demande) }}"
                                  class="btn-icon btn-icon--info" title="عرض">
                                    <i class="la la-eye"></i> 
                                </a>
                        
                                  <a href="{{ route('admin.manifestation2.edit', $row->id_demande) }}"
                                    class="btn-icon btn-icon--warning" title="تعديل">
                                      <i class="la la-edit"></i> 
                                  </a>

                                  <form action="{{ route('admin.manifestation2.toggle_statut', $row->id_demande) }}" enctype="multipart/form-data"  method="POST" class="d-inline">
                                      @csrf
                                      @method('PATCH')

									  
									    	<button type="button" onclick="confirmStatusChange2(this.closest('form'), '{{ $row->statut?->statut_ar }}')" class="btn-icon btn-icon--secondary" title="تغيير الحالة">
                                                    <i class="la la-toggle-on"></i>
                                                 </button>
                                  </form>

                                 

                                  <form action="{{ route('admin.manifestation2.destroy', $row->id_demande) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" 
                                                        onclick="confirmDelete(this.closest('form'))" 
                                                        class="btn-icon btn-icon--danger"                                          title="حذف">
                                                    <i class="la la-trash"></i>
                                                </button>

                                            </form>
                     

                            </div>
                        </td>
            </tr>
            @empty
            <tr>
                <td colspan="10" class="text-center">لا توجد طلبات تظاهرات رياضية.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

		<div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $demandes->links('pagination::bootstrap-5') }}
                    </div>
    </div>
</div>
</div>
</div>
</div>
<style>
  .btn-icon {
    width: 30px;       /* plus petit */
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;   /* icône plus fine */
    transition: all 0.2s ease;
    border: none;
    background-color: #f8f9fa;
    cursor: pointer;
}

/* Effet hover */
.btn-icon:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.15);
}

/* Couleurs pastel */
.btn-icon--primary {
    background-color: #e3f2fd;
    color: #0d6efd;
}
.btn-icon--warning {
    background-color: #fff3cd;
    color: #ffc107;
}
.btn-icon--danger {
    background-color: #f8d7da;
    color: #dc3545;
}
.btn-icon--secondary {
    background-color: #e2e3e5;
    color: #6c757d;
}
   /* Table globale */
.table th, .table td {
    vertical-align: middle;
    text-align: center;
    font-size: 12px;       /* texte un peu plus petit */
    padding: 6px 8px;      /* moins de padding pour réduire la taille */
}

.table-hover tbody tr:hover {
    background-color: #f9f9f9;
}

/* Badges de statut */
.status-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 3px 6px;      /* réduit le padding */
    font-size: 10px;       /* réduit la taille de la police */
    border-radius: 6px;
    font-weight: 600;
    min-width: 60px;       /* réduit la largeur minimale */
    text-align: center;
}

.status-badge--success { background-color: #e8f9ee; color: #27ae60; }
.status-badge--danger  { background-color: #fde8ea; color: #e74c3c; }
.status-badge--pending { background-color: #fff8e1; color: #d4a017; }

/* Boutons modernes */
.btn-modern {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 4px;
    border: none;
    border-radius: 6px;
    padding: 3px 6px;      /* réduit le padding */
    font-size: 10px;       /* réduit la police */
    font-weight: 600;
    cursor: pointer;
    transition: all 0.25s ease;
}

.btn-modern--info { background-color: #e3f2fd; color: #0d6efd; }
.btn-modern--warning { background-color: #fff8e1; color: #d4a017; }
.btn-modern--danger { background-color: #fde8ea; color: #e74c3c; }

/* Responsive pour petits écrans */
@media (max-width: 768px) {
    .table-responsive { overflow-x: auto; }
    .btn-modern { font-size: 9px; padding: 2px 4px; }
    .status-badge { font-size: 9px; padding: 2px 4px; min-width: auto; }
    .table th, .table td { font-size: 10px; padding: 4px 6px; }
}

</style>

<script>
    function showSearchInput(value) {
        document.getElementById('searchByDate').style.display = (value == 'date') ? 'block' : 'none';
        document.getElementById('searchByTypeIdentite').style.display = (value == 'type_identite') ? 'block' : 'none';
    }
</script>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
async function confirmStatusChange10(form, currentStatus) {
    const formData = new FormData(form);

    // Étape 1️⃣ : الإدارة الفرعية
    const { value: id_statut } = await Swal.fire({
        title: 'تغيير الحالة من قبل الإدارة الفرعية',
        input: 'radio',
        inputOptions: { '1': 'قبول', '3': 'رفض' },
        inputValidator: (v) => !v && 'اختر الحالة الجديدة!',
        showCancelButton: true,
        confirmButtonText: 'التالي',
        cancelButtonText: 'إلغاء',
        reverseButtons: true
    });
    if (!id_statut) return;
    formData.append('id_statut', id_statut);

    if (id_statut == '3') {
        const { value: motif } = await Swal.fire({
            title: 'سبب الرفض من الإدارة الفرعية',
            input: 'textarea',
            inputPlaceholder: 'الرجاء إدخال سبب الرفض',
            inputValidator: (v) => !v && 'يجب إدخال سبب الرفض!',
            showCancelButton: true,
            confirmButtonText: 'تأكيد',
            cancelButtonText: 'إلغاء',
            reverseButtons: true
        });
        if (!motif) return;
        formData.append('commentaire_motif', motif);
        return submitFormData(form.action, formData);
    }

    // Étape 2️⃣ : الجامعة
    const { value: statut_id } = await Swal.fire({
        title: 'تغيير الحالة من قبل الجامعة',
        input: 'radio',
        inputOptions: { '1': 'قبول', '3': 'رفض' },
        inputValidator: (v) => !v && 'اختر الحالة!',
        showCancelButton: true,
        confirmButtonText: 'التالي',
        cancelButtonText: 'إلغاء',
        reverseButtons: true
    });
    if (!statut_id) return;
    formData.append('statut_id', statut_id);

    if (statut_id == '3') {
        const { value: motif2 } = await Swal.fire({
            title: 'سبب الرفض من الجامعة',
            input: 'textarea',
            inputPlaceholder: 'الرجاء إدخال سبب الرفض',
            inputValidator: (v) => !v && 'يجب إدخال سبب الرفض!',
            showCancelButton: true,
            confirmButtonText: 'تأكيد',
            cancelButtonText: 'إلغاء',
            reverseButtons: true
        });
        if (!motif2) return;
        formData.append('commentaire_motif2', motif2);
        return submitFormData(form.action, formData);
    }

    // Étape 3️⃣ : اللجنة الوطنية المختلطة
    const { value: statut2_id } = await Swal.fire({
        title: 'تغيير الحالة من قبل اللجنة الوطنية المختلطة',
        input: 'radio',
        inputOptions: { '1': 'قبول', '3': 'رفض' },
        inputValidator: (v) => !v && 'اختر الحالة!',
        showCancelButton: true,
        confirmButtonText: 'التالي',
        cancelButtonText: 'إلغاء',
        reverseButtons: true
    });
    if (!statut2_id) return;
    formData.append('statut2_id', statut2_id);

    if (statut2_id == '3') {
        const { value: motif3 } = await Swal.fire({
            title: 'سبب الرفض من اللجنة الوطنية المختلطة',
            input: 'textarea',
            inputPlaceholder: 'الرجاء إدخال سبب الرفض',
            inputValidator: (v) => !v && 'يجب إدخال سبب الرفض!',
            showCancelButton: true,
            confirmButtonText: 'تأكيد',
            cancelButtonText: 'إلغاء',
            reverseButtons: true
        });
        if (!motif3) return;
        formData.append('commentaire_motif3', motif3);
        return submitFormData(form.action, formData);
    }

    // Étape 4️⃣ : إدراج الترخيص (fichier réel)
    const { value: file } = await Swal.fire({
        title: 'أضف الترخيص (PDF أو صورة)',
        html: '<input type="file" id="fileInput" class="swal2-input" accept=".pdf,.jpg,.png,.jpeg">',
        showCancelButton: true,
        confirmButtonText: 'رفع الملف',
        cancelButtonText: 'تخطي',
        reverseButtons: true,
        preConfirm: () => {
            const input = document.getElementById("fileInput");
            return input.files.length > 0 ? input.files[0] : null;
        }
    });

    if (file) {
        formData.append('file', file); // 🔥 vrai fichier
    }

    submitFormData(form.action, formData);
}

// 🔹 Envoi du FormData avec Fetch
async function submitFormData(url, formData) {
    const response = await fetch(url, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
            'X-HTTP-Method-Override': 'PATCH'
        }
    });

    if (response.ok) {
        Swal.fire({
            icon: 'success',
            title: 'تم تحديث الحالة بنجاح',
            confirmButtonText: 'حسناً'
        }).then(() => location.reload());
    } else {
        Swal.fire({
            icon: 'error',
            title: 'حدث خطأ أثناء الحفظ',
            confirmButtonText: 'موافق'
        });
    }
}
</script>
<script>
    function confirmEdit(url) {
    Swal.fire({
        icon: 'question',
        title: 'هل تريد حقًا تعديل هذه الوثيقة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-primary mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url; // redirige vers la page edit
        }
    });
}

function confirmDelete(form) {
    Swal.fire({
        icon: 'warning',
        title: 'هل تريد حذف هذه الوثيقة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-danger mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        }
    });
}


</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="{{ asset('assets/js/index.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

@else
<script> window.location.href = "{{ route('admin') }}"; </script>
@endif

@endsection
