@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.manifestation.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
        <input type="hidden" name="type_formulaire_id" value="12">

        <!-- step1 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire2->id_type }}">
            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>
            <h3 style="font-size:25px;">{{ $formulaire2->type_ar }}</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3"  style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label"> اسم الهيكل غير الرياضي </label>
                    <div class="col-sm-10">
                        <input  type="text" class="form-control" name="org[nom]" placeholder=" اسم الهيكل غير الرياضي  " maxlength="100">
                    </div>
                </div> 

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label"> عدد التاشيرة</label>
                    <div class="col-sm-4">
                        <input  type="number" class="form-control" name="org[num_visa]"  max="999999999999" >
                    </div>
                    <label class="col-sm-2 col-form-label"> تاريخ التسجيل س.و.م </label>
                    <div class="col-sm-4">
                        <input  type="date" class="form-control" name="org[date_enregistrement]">
                    </div>
                </div>
                
                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label"> المعرف الجبائي </label>
                    <div class="col-sm-4">
                        <input type="number" name="org[identifiant_fiscal]" class="form-control" placeholder="المعرف الجبائي" max="999999999999">
                    </div>
                    <label class="col-sm-2 col-form-label">  رقم الحساب البنكي </label>
                    <div class="col-sm-4">
                        <input  type="text" class="form-control" name="org[num_compte_bancaire]" placeholder=" xxxx_xxxxxxxxxxxxxxxx" maxlength="20">
                    </div>
                </div>

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label"> العنوان  </label>
                    <div class="col-sm-10">
                        <input  type="text" class="form-control" name="org[adresse]" placeholder=" العنوان " maxlength="150">
                    </div>
                </div>

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label">  رقم الهاتف </label>
                    <div class="col-sm-4">
                        <input  type="text" class="form-control" name="org[tel]" placeholder="216xxxxxxxx+" maxlength="12">
                    </div>
                    <label class="col-sm-2 col-form-label">  رقم الفاكس </label>
                    <div class="col-sm-4">
                        <input  type="text" class="form-control" name="org[fax]" placeholder="216xxxxxxxx+" maxlength="12">
                    </div>
                </div>

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label">  البريد الالكتروني  </label>
                    <div class="col-sm-4">
                        <input  type="email" class="form-control" name="org[email]" placeholder=" xxx@xxx.xxx" maxlength="100">
                    </div>
                </div>
            </div>   
        </div>


        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
            <input type="hidden" name="demande_id" value="">
            <h3 style="font-size:25px;"> ملف التامين الخاص </h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        نسخة من ملف التأمين الخاص بالتظاهرة الرياضية
                    </label>
                    <div class="col-sm-12">
                        <input type="file" class="form-control" name="assurance_file" accept=".pdf,.jpg,.jpeg,.png">
                        @error('assurance_file')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>


        <!-- step2 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
            <input type="hidden" name="demande_id" value="">

            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>
            <h3 style="font-size:25px;">{{ $formulaire3->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label"> اسم التظاهرة </label>
                    <div class="col-sm-10">
                        <input  type="text" class="form-control" name="nom_even" placeholder=" اسم التظاهرة " maxlength="100" value="{{ old('nom_even') }}">
                    </div>
                </div>
                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> الهدف من تنظيم التظاهرة و آثارها الرياضية و الأبعاد الاقتصادية والاجتماعية </label>
                    <div class="col-sm-12">
                        <textarea name="objectifs" class="form-control" rows="3">{{ old('objectifs') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> محتوى التظاهرة و الاختصاصات الرياضية المستهدفة </label>
                    <div class="col-sm-12">
                        <textarea name="contenus" class="form-control" rows="3">{{ old('contenus') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> تاريخ تنظيم التظاهرة </label>
                    <div class="col-sm-4">
                        <input  type="date" class="form-control" name="date" value="{{ old('date') }}">
                        
                    </div>
                    <label class="col-sm-2 col-form-label"> توقيت تنظيم التظاهرة </label>
                    <div class="col-sm-4">
                        <input  type="time" class="form-control" name="heure" value="{{ old('heure') }}">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الولاية </label>
                    <div class="col-sm-4">
                        <select  class="form-control" name="gouvernorat_id" id="gouvernorat_id">
                            <option value="" disabled selected>اختر...</option>
                            @foreach($gouvernorats as $gouv)
                                <option value="{{ $gouv->id_gouver }}" {{ old('gouvernorat_id') == $gouv->id_gouver ? 'selected' : '' }}>{{ $gouv->nom_ar }}</option>
                            @endforeach
                        </select>
                    </div>

                    <label class="col-sm-2 col-form-label"> البلدية </label>
                    <div class="col-sm-4">
                        <select  class="form-control" name="delegation_id" id="delegation_id" disabled>
                            <option value="" disabled selected>اختر...</option>
                        </select>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> المنشئات الرياضية التي ستستغل </label>
                    <div class="col-sm-12">
                        <textarea name="instalation_sportives" class="form-control" rows="2">{{ old('instalation_sportives') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الجامعة الرياضية مرجع الاختصاص </label>
                    <div class="col-sm-4">
                        <input type="text" class="form-control" name="reference" maxlength="100" value="{{ old('reference') }}">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> المداخيل التقديرية الجملية </label>
                    <div class="col-sm-4">
                        <input type="number" step="0.001" class="form-control" name="estimation_evenement" value="{{ old('estimation_evenement') }}">
                    </div>
                    <label class="col-sm-2 col-form-label"> المصاريف التقديرية الجملية </label>
                    <div class="col-sm-4">
                        <input type="number" step="0.001" class="form-control" name="cout_total_evenement" value="{{ old('cout_total_evenement') }}">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الفارق التقديري </label>
                    <div class="col-sm-4">
                        <input type="number" step="0.001" class="form-control" name="difference_estimee" value="{{ old('difference_estimee') }}">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> بيان الجوائز </label>
                    <div class="col-sm-10">
                        <textarea name="recompense" class="form-control" rows="2">{{ old('recompense') }}</textarea>
                    </div>
                </div>
                <input type="hidden" name="user_id" value="{{ Auth::user()->id }}">
            </div>
        </div>

        <!-- step3 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire4->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire4->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة عناصر فريق التنظيم</label>
                    <table id="membres-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="membres-body">
                            <tr>
                                <td data-label="الاسم واللقب">
                                    <input type="text" name="membres[0][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                                </td>
                                <td data-label="الصفة">
                                    <input type="text" name="membres[0][role]"  readonly value="رئيس لجنة التنظيم" class="form-control bg-white" placeholder="الصفة">
                                </td>
                                <td data-label="الجنسية">
                                    <input type="text" name="membres[0][nationalite]" class="form-control" placeholder="الجنسية">
                                </td>
                                <td class="action-buttons">
                                    <div style="width: 40px; height: 31px;"></div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-primary mt-2" onclick="addOrganisateurRow()" style="background-color: #28a745; border-color: #28a745;">
                        إضافة صف
                    </button>
                </div>

                <div class="form-group row mt-4">
                    <label class="col-sm-6 col-form-label">الشخصيات الرسمية المدعوة</label>
                    <table id="invites-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="invites-body">
                            <tr>
                                <td data-label="الاسم واللقب">
                                    <input type="text" name="invites[0][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                                </td>
                                <td data-label="الصفة">
                                    <input type="text" name="invites[0][role]" class="form-control" placeholder="الصفة">
                                </td>
                                <td data-label="الجنسية">
                                    <input type="text" name="invites[0][nationalite]" class="form-control" placeholder="الجنسية">
                                </td>
                                <td class="action-buttons">
                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-primary mt-2" onclick="addInviteRow()" style="background-color: #28a745; border-color: #28a745;">
                        إضافة صف
                    </button>
                </div>
            </div>
        </div>


        <!-- step4 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire5->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire5->type_ar }}</h3>
            <br>

           <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label"> الجمعيات المشاركة </label>
                    <div class="table-responsive">
                        <table id="assoc-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:20%">الجمعيات المشاركة</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                    <th rowspan="2" style="width:8%">إجراء</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            <tbody id="assoc_participantes-body">
                                <tr>
                                    <td class="row-number">1</td>
                                    <td><input type="text" name="assoc_participantes[0][nom]" class="form-control" placeholder="اسم الجمعية"></td>
                                    <td><input type="number" name="assoc_participantes[0][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
                                    <td><input type="number" name="assoc_participantes[0][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
                                    <td><input type="number" name="assoc_participantes[0][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
                                    <td><input type="number" name="assoc_participantes[0][total]" class="form-control text-center" readonly placeholder="0"></td>
                                    <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAssocRow(this)">حذف</button></td>
                                </tr>
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>

                                    <td>
                                        <input type="number" id="total-males" class="form-control text-center" readonly value="0">
                                    </td>
                                    <td>
                                        <input type="number" id="total-females" class="form-control text-center" readonly value="0">
                                    </td>

                                    <td>
                                        <input type="number" id="total-accompagnants" class="form-control text-center" readonly value="0">
                                    </td>

                                    <td>
                                        <input type="number" id="total-general" class="form-control text-center fw-bold" readonly value="0">
                                    </td>

                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <button type="button" class="btn btn-success mt-2" onclick="addAssocRow()">إضافة صف</button>
                </div>
            </div>
        </div>
  


        <!-- step5 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire6->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire6->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label"> الرياضيين المشاركين بصفة فردية  </label>
                    <div class="table-responsive">
                        <table id="athletes-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:25%">اسم و لقب الرياضي المشارك</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                    <th rowspan="2" style="width:8%">إجراء</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            <tbody id="athletes-body">
                                <tr>
                                    <td class="row-number">1</td>
                                    <td><input type="text" name="athletes[0][nom_prenom_sportif]" class="form-control" placeholder="الاسم و اللقب"></td>
                                    <td><input type="number" name="athletes[0][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
                                    <td><input type="number" name="athletes[0][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
                                    <td><input type="number" name="athletes[0][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
                                    <td><input type="number" name="athletes[0][total]" class="form-control text-center" readonly placeholder="0"></td>
                                    <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAthleteRow(this)">حذف</button></td>
                                </tr>
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>
                                    <td><input type="number" id="total2-males" class="form-control text-center" readonly value="0"></td>
                                    <td><input type="number" id="total2-females" class="form-control text-center" readonly value="0"></td>
                                    <td><input type="number" id="total2-accompagnants" class="form-control text-center" readonly value="0"></td>
                                    <td><input type="number" id="total2-general" class="form-control text-center fw-bold" readonly value="0"></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <button type="button" class="btn btn-success mt-2" onclick="addAthleteRow()">إضافة صف</button>
                </div>
            </div>
        </div>

        <!-- step6 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire7->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire7->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label"> الرياضيين المشاركين </label>
                    <div class="table-responsive">
                        <table id="sportifs-table" class="custom-table table table-bordered text-center align-middle">
                            <thead>
                                <tr>
                                    <th>اسم و لقب الرياضي المشارك</th>
                                    <th>الصنف العمري</th>
                                    <th>تاريخ الولادة</th>
                                    <th>رقم بطاقة التعريف</th>
                                    <th>إجراء</th>
                                </tr>
                            </thead>
                            <tbody id="sportifs-body">
                                <tr>
                                    <td data-label="الاسم واللقب">
                                        <input type="text" name="sportifs[0][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                                    </td>
                                    <td data-label="الصنف العمري">
                                        <input type="text" name="sportifs[0][tranch_age]" class="form-control" placeholder="الصنف العمري">
                                    </td>
                                    <td data-label="تاريخ الولادة">
                                        <input type="date" name="sportifs[0][date_naissance]" class="form-control">
                                    </td>
                                    <td data-label="رقم بطاقة التعريف">
                                        <input type="text" name="sportifs[0][num_cin]" class="form-control" placeholder="رقم البطاقة">
                                    </td>
                                    <td class="action-buttons">
                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeSportifRow(this)">حذف</button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <button type="button" class="btn btn-success mt-2" onclick="addSportifRow()">
                            إضافة صف
                        </button>
                    </div>
                </div>
            </div>
        </div>


        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
            <input type="hidden" name="demande_id" value="">  
            <h3 style="font-size:25px;">موافقة مبدئية </h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-10 col-form-label">
                        موافقة مبدئية كتابية لاستغلال مكان إقامة التظاهرة الرياضية من المصالح المختصة
                    </label>
                    <div class="col-sm-12">
                        <input type="file" class="form-control" name="accord_file" accept=".pdf,.jpg,.jpeg,.png">
                        @error('accord_file')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>


        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
            <input type="hidden" name="demande_id" value="">  
            <h3 style="font-size:25px;">الملف الفني </h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        الملف الفني للتظاهرة 
                    </label>
                    <div class="col-sm-12">
                        <input type="file" class="form-control" name="technique_file" accept=".pdf,.jpg,.jpeg,.png">
                        @error('technique_file')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
            <input type="hidden" name="demande_id" value="">

            <h3 style="font-size:25px; text-align:center;">مطلب في إقامة تظاهرة رياضية وطنية بالبلاد التونسية</h3>
            <br>

            <div class="form-section" style="direction: rtl; text-align: right;">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-12 col-form-label" style="font-size: 18px;">
                        الرجاء تحميل المطلب، تعميره يدوياً، إمضاؤه وختمه 
                        ثم إعادة تحميل النسخة الممضاة أدناه.
                    </label>

                    <div class="col-sm-12 mt-2">
                        <a href="{{ asset('storage/manifestations/demande_manifestation.pdf') }}" 
                        class="btn btn-outline-primary" 
                        target="_blank" 
                        style="font-size:16px;">
                            <i class="la la-download me-1"></i> تحميل المطلب 
                        </a>
                    </div>

                    <div class="col-sm-12 mt-4">
                        <label for="demande_file" class="form-label" style="font-size: 16px;">
                            الرجاء إدراج نسخة المطلب الممضاة
                        </label>
                        <input type="file" class="form-control" name="demande_file" accept=".pdf,.jpg,.jpeg,.png">

                        @error('demande_file')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>



        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto">
                <button type="submit" class="btn btn-success font-weight-medium" style="width:100px;margin-right:250px;">إرسال</button>
            </div>
            <div class="col-sm-4 mx-auto">
                <a href="{{ route('admin.manifestation.index') }}" class="btn btn-primary" style="width:100px;margin-left:250px;">
                    <i class="bi bi-arrow-left"></i> رجوع
                </a>
            </div>
        </div>

    </form>
</div>


<script>
    let orgIndex = 1;
    function addOrganisateurRow() {
        let tableBody = document.getElementById('membres-body');
        let newRow = `
            <tr>
                <td data-label="الاسم واللقب">
                    <input type="text" name="membres[${orgIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                </td>
                <td data-label="الصفة">
                    <input type="text" name="membres[${orgIndex}][role]" class="form-control" placeholder="الصفة">
                </td>
                <td data-label="الجنسية">
                    <input type="text" name="membres[${orgIndex}][nationalite]" class="form-control" placeholder="الجنسية">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        orgIndex++;
    }

    let inviteIndex = 1;
    function addInviteRow() {
        let tableBody = document.getElementById('invites-body');
        let newRow = `
            <tr>
                <td data-label="الاسم واللقب">
                    <input type="text" name="invites[${inviteIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                </td>
                <td data-label="الصفة">
                    <input type="text" name="invites[${inviteIndex}][role]" class="form-control" placeholder="الصفة">
                </td>
                <td data-label="الجنسية">
                    <input type="text" name="invites[${inviteIndex}][nationalite]" class="form-control" placeholder="الجنسية">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        inviteIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

<script>
    let assocIndex = 1;

    function addAssocRow() {
        const tbody = document.getElementById('assoc_participantes-body');
        const newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td class="row-number"></td>
            <td><input type="text" name="assoc_participantes[${assocIndex}][nom]" class="form-control" placeholder="اسم الجمعية"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][total]" class="form-control text-center" readonly placeholder="0"></td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAssocRow(this)">حذف</button></td>
        `;
        tbody.appendChild(newRow);
        assocIndex++;
        updateAssocRowNumbers();
        updateTotals();
    }

    function removeAssocRow(button) {
        button.closest('tr').remove();
        updateAssocRowNumbers();
        updateTotals();
    }

    function updateAssocRowNumbers() {
        const rows = document.querySelectorAll('#assoc_participantes-body tr');
        rows.forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }

    document.addEventListener('input', function(e) {
        if (!e.target.closest('#assoc_participantes-body')) return;

        const row = e.target.closest('tr');

        const males = Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
        const females = Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
        const escorts = Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;

        const rowTotal = males + females + escorts;
        const totalInput = row.querySelector('input[name$="[total]"]');
        if (totalInput) totalInput.value = rowTotal;

        updateTotals();
    });

    function updateTotals() {
        let totalMales = 0;
        let totalFemales = 0;
        let totalAccompagnants = 0;
        let totalGeneral = 0;

        document.querySelectorAll('#assoc_participantes-body tr').forEach(row => {
            totalMales += Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
            totalFemales += Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
            totalAccompagnants += Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;
            totalGeneral += Number(row.querySelector('input[name$="[total]"]').value) || 0;
        });

        document.getElementById('total-males').value = totalMales;
        document.getElementById('total-females').value = totalFemales;
        document.getElementById('total-accompagnants').value = totalAccompagnants;
        document.getElementById('total-general').value = totalGeneral;
    }

    updateTotals();
</script>


<script>
let athleteIndex = 1;

function addAthleteRow() {
    const tbody = document.getElementById('athletes-body');
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number"></td>
        <td><input type="text" name="athletes[${athleteIndex}][nom_prenom_sportif]" class="form-control" placeholder="الاسم و اللقب"></td>
        <td><input type="number" name="athletes[${athleteIndex}][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][total]" class="form-control text-center" readonly placeholder="0"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAthleteRow(this)">حذف</button></td>
    `;
    tbody.appendChild(newRow);
    athleteIndex++;
    updateAthleteRowNumbers();
    update2Totals();
}

function removeAthleteRow(button) {
    button.closest('tr').remove();
    updateAthleteRowNumbers();
    update2Totals();
}

function updateAthleteRowNumbers() {
    const rows = document.querySelectorAll('#athletes-body tr');
    rows.forEach((row, index) => {
        row.querySelector('.row-number').textContent = index + 1;
    });
}

document.addEventListener('input', function(e) {
    if (!e.target.closest('#athletes-body')) return;

    const row = e.target.closest('tr');

    const males = Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
    const females = Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
    const escorts = Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;

    const rowTotal = males + females + escorts;
    const totalInput = row.querySelector('input[name$="[total]"]');
    if (totalInput) totalInput.value = rowTotal;

    update2Totals();
});

function update2Totals() {
    let total2Males = 0;
    let total2Females = 0;
    let total2Accompagnants = 0;
    let total2General = 0;

    document.querySelectorAll('#athletes-body tr').forEach(row => {
        total2Males += Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
        total2Females += Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
        total2Accompagnants += Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;
        total2General += Number(row.querySelector('input[name$="[total]"]').value) || 0;
    });

    document.getElementById('total2-males').value = total2Males;
    document.getElementById('total2-females').value = total2Females;
    document.getElementById('total2-accompagnants').value = total2Accompagnants;
    document.getElementById('total2-general').value = total2General;
}

update2Totals();
</script>
<script>document.getElementById('gouvernorat_id').addEventListener('change', function() {    let gouvId = this.value;    let delegationSelect = document.getElementById('delegation_id');    delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>';    delegationSelect.disabled = true;    let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";    url = url.replace("ID_PLACEHOLDER", gouvId);    fetch(url)        .then(response => response.json())        .then(data => {            delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';            data.forEach(d => {                let option = document.createElement('option');                option.value = d.id_delegation;                option.text = d.nom_ar;                delegationSelect.add(option);            });            delegationSelect.disabled = false;        });});</script>

<script>
    let sportifIndex = 1; 

    function addSportifRow() {
        const tbody = document.getElementById('sportifs-body');
        const newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td data-label="الاسم واللقب">
                <input type="text" name="sportifs[${sportifIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
            </td>
            <td data-label="الصنف العمري">
                <input type="text" name="sportifs[${sportifIndex}][tranch_age]" class="form-control" placeholder="الصنف العمري">
            </td>
            <td data-label="تاريخ الولادة">
                <input type="date" name="sportifs[${sportifIndex}][date_naissance]" class="form-control">
            </td>
            <td data-label="رقم بطاقة التعريف">
                <input type="text" name="sportifs[${sportifIndex}][num_cin]" class="form-control" placeholder="رقم البطاقة">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeSportifRow(this)">حذف</button>
            </td>
        `;

        tbody.appendChild(newRow);
        sportifIndex++;
    }

    function removeSportifRow(button) {
        button.closest('tr').remove();
    }

</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection