@extends('backoffice.dashboard')

@section('content')

<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

<style>

    @media print {

    body * {

        visibility: hidden;

    }
    .container, .container * {

        visibility: visible; 

    }
    .no-print {

        display: none !important;

    }
    .container {

        position: absolute;

        left: 0;

        top: 0;

        width: 100%;

    }
}
</style>



@if(Auth::check())

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pO6Faa4sdB7Z3K/ZzF8O1NjcZk7CjJmUjeF3fXxOZbq1dsm7GJxSFeWmyt3E5kzZ+vHVH3K2Yv/Vs1QY7PZ3UQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />



<div class="container printable-content">

    <form action="{{ route('salle-sport.update', $immobilier->id_imm) }}" method="POST" enctype="multipart/form-data" lang="ar">

        @csrf

        @method('PUT')



        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">



        <div class="header-print-container">

    <div class="header-side header-left">

        <span class="delegation-print">

            المندوبية الجهوية للشباب و الرياضة : 

            {{ $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-' }}

        </span>

    </div>



    <div class="header-center">

   

        <h3 class="title-form">استمارة إيداع كراس الشروط لإحداث قاعة خاصة للرياضة</h3>

        <h4 class="title-request">اطلاع على المطلب</h4>

    </div>

<a href="{{ route('salle-sport.pdf', $immobilier->id_imm) }}" target="_blank"
   class="btn btn-danger">
    <i class="fa fa-file-pdf"></i> تحميل PDF
</a>


    

</div>

        <div>

            <div class="d-flex align-items-center mb-3">
    <h5 class="mb-0 fw-bold me-2">الوضعية الحالية:</h5>

    @switch($immobilier->id_statut)

        @case(1)
            <span><strong> قبول</strong></span>
            @break

        @case(2)
            <span><strong>في الانتظار</strong></span>
            @break

        @case(3)
            <span><strong>رفض</strong></span>
            @break

        @case(4)
            <span><strong>موافقة شريطة</strong></span>
            @break

        @case(5)
            <span><strong>إرجاء لإبداء الرأي</strong></span>
            @break

        @case(6)
            <span><strong>مسودّة</strong></span>
            @break

        @default
            <span><strong>غير محدد</strong></span>

    @endswitch
</div>



            @if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif))

                <div class="d-flex align-items-center mb-3">

                    <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>

                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $immobilier->commentaire_motif }}</p>

                </div>

            @endif

        </div>

{{-- Status history card --}}
{{-- Compact status history (RTL, minimal) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h6>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($immobilier->statutHistories->isEmpty())
      <p class="text-muted mb-0 ">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($immobilier->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar
                    ?? optional($hist->fromStatut)->libelle_ar
                    ?? '—';
            $to = optional($hist->toStatut)->statut_ar
                  ?? optional($hist->toStatut)->libelle_ar
                  ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success'
                         : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* Compact timeline styles (RTL) */
.compact-timeline { display: flex; flex-direction: column; gap: 6px; }
.compact-item { padding: 6px 4px; border-bottom: 1px solid rgba(0,0,0,0.06); }

.compact-row { gap: 8px; align-items: flex-start; }

/* left block (date + user) placed on the right visually because of RTL */
.left-block { width: 160px; min-width: 120px; margin-left: 12px; }
.compact-date { font-size: 12px; color: #6c757d; }
.compact-user { font-size: 11px; color: #8a8f94; margin-top: 2px; }

/* main labels */
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color: #6c757d; font-size: 13px; }
.compact-arrow { color: #6c757d; font-size: 14px; margin: 0 4px; }
.compact-to { font-size: 13px; padding: 3px 8px; border-radius: 10px; }

/* small badge color helpers */
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }

/* comment details (very compact) */
.compact-comment summary {
  list-style: none;
  cursor: pointer;
  outline: none;
  padding: 0;
}

</style>


        <div class="form-section">

            <h4 class="mb-3 fw-bold">هوية الباعث</h4>   

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الاسم و اللقب أو الاسم التجاري</label>

                <div class="col-sm-10 pt-2">

                    <span>{{ $immobilier->utilisateur->nom_prenom ?? '-' }}</span>

                </div>

            </div>  

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الهوية الشخصية</label>  

                <div class="col-sm-4 pt-2">

                    <span>

                        {{ $typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first()->type_ar ?? '-' }}

                    </span>

                </div>

                <div class="col-sm-6 pt-2">

                    @if($immobilier->utilisateur->cin)

                        <span>بطاقة تعريف: {{ $immobilier->utilisateur->cin }}</span>

                    @elseif($immobilier->utilisateur->passport)

                        <span>جواز سفر: {{ $immobilier->utilisateur->passport }}</span>

                    @elseif($immobilier->utilisateur->num_fiscal)

                        <span>معرّف جبائي: {{ $immobilier->utilisateur->num_fiscal }}</span>

                    @else

                        <span>-</span>

                    @endif

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">رقم الهاتف الشخصي</label>

                <div class="col-sm-10 pt-2">

                    <span>{{ $immobilier->utilisateur->tel ?? '-' }}</span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">البريد الالكتروني</label>

                <div class="col-sm-10 pt-2">

                    <span>{{ $immobilier->utilisateur->email ?? '-' }}</span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">العنوان الشخصي</label>

                <div class="col-sm-10 pt-2">

                    <span>{{ $immobilier->utilisateur->adresse ?? '-' }}</span>

                </div>

            </div>



            <h4 class="mb-3 fw-bold">هوية العقار</h4> 

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">عنوان العقار</label>

                <div class="col-sm-10 pt-2">

                    <span>{{ $immobilier->adresse_imm ?? '-' }}</span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الولاية</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        {{ $gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first()->nom_ar ?? '-' }}

                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">البلدية</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        {{ $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-' }}

                    </span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">صيغة العقار</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        {{ $typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first()->type_ar ?? '-' }}

                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">المساحة الجملية للعقار بالم2</label>

                <div class="col-sm-4 pt-2">

                    <span>{{ $immobilier->superfici_m2 ? $immobilier->superfici_m2.' م²' : '-' }}</span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">صيغة استغلال العقار</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        {{ $usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first()->usage_ar ?? '-' }}

                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">نسخة العقد/الملكية</label>

                <div class="col-sm-4 pt-2">

                    @if($immobilier->document_propriete)
                         <a href="{{ route('immobilier.download', $immobilier->id_imm) }}?v={{ time() }}"
   target="_blank">
   عرض
</a>
                    @else

                        <span>-</span>

                    @endif

                </div>
				
				

            </div>



            <h4 class="mb-3 fw-bold">مكونات العقار</h4>



<table class="table table-bordered text-center align-middle">

    <thead class="table-light">

        <tr>

            <th>المكوّن</th>

            <th>نعم / لا</th>

            <th>العدد</th>

            <th>المساحة</th>

        </tr>

    </thead>

    <tbody>

        @php

            $components = [

                'salle_exercice'   => 'قاعة التمارين',

                'piscine'          => 'حوض مائي',

                'vestiaire'        => 'حجرات ملابس',

                'unitaires_sanitaire' => 'وحدات صحية',

                'stockage_conservation'  => 'فضاء للخزن وحفظ الأثاث والمعدات',

                'espace_exterieur' => 'فضاء خارجي',

                'garage'           => 'مأوى سيارات'

            ];

        @endphp



        @foreach($components as $comp => $label)

            <tr>

                {{-- المكوّن --}}

                <td>{{ $label }}</td>



                {{-- نعم / لا --}}

                <td>

                    @if($immobilier->$comp == 1)

                        نعم

                    @elseif($immobilier->$comp == 0)

                        لا

                    @else

                        -

                    @endif

                </td>



                {{-- العدد --}}

<td>

    @if($immobilier->$comp == 1)

        @if(in_array($comp, ['salle_exercice','piscine','vestiaire']))

            {{ $immobilier->{'nbr_'.$comp} ?? '-' }}

        @else

            -

        @endif

    @else

        -

    @endif

</td>



{{-- المساحة --}}

<td>

    @if($immobilier->$comp == 1)

        {{ $immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : '-' }}

    @else

        -

    @endif

</td>



            </tr>

        @endforeach

    </tbody>

</table>





            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">مساحات اخرى</label>

                <div class="col-sm-10 pt-2">

                   <span>{{ $immobilier->autres_surfaces ?? '-' }} م²</span>



                </div>

            </div>

        </div>

        <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                   <a href="{{ route('salle-sport.pdf', $immobilier->id_imm) }}" target="_blank"
                    class="btn btn-danger  d-flex align-items-center justify-content-center gap-1 flex-fill">
                        <i class="fa fa-file-pdf"></i> تحميل PDF
                    </a>
                <a href="{{ route('salle-sport.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

    </form>

</div>



@else

    <script>

        window.location.href = "{{ route('admin') }}";

    </script>

@endif

@endsection