<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: rtl;
    text-align: right;
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}
.header h1,h2,h3 {
    margin: 0;
    text-align: center;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-right: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
    display: block;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}
th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}
td {
    border: 1px solid #000;
    padding: 6px;
}

.page-break {
    page-break-before: always;
}

.no-break {
    page-break-inside: avoid;
}
</style>
</head>
<body>

{{-- HEADER --}}
<div class="header">
    <table width="100%" style="border:none;">
        <tr>
            <td style="width:90px; text-align:right; border:none;">
                <img src="{{ public_path('storage/logo.png') }}" style="width:60px;">
            </td>
            <td style="text-align:center; border:none;">
                <h1 style="font-size:18px">الجمهورية التونسية</h1>
                <h2 style="font-size:15px">وزارة الشباب و الرياضة</h2>
                <h3 style="font-size:15px">استمارة إيداع كراس الشروط لإحداث قاعة خاصة للرياضة</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>

{{-- ÉTAT DU DOCUMENT --}}
<h4>الوضعية</h4>
<div class="section row">
    <div class="field">
        <span class="label">حالة المطلب</span>
        <span class="value">
            @if($immobilier->id_statut == 1)
                قبول
            @elseif($immobilier->id_statut == 3)
                رفض
            @else
                في الانتظار
            @endif
        </span>
    </div>
    @if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif))
    <div class="field">
        <span class="label">سبب الرفض</span>
        <span class="value">{{ $immobilier->commentaire_motif }}</span>
    </div>
    @endif
</div>

{{-- IDENTITÉ DU PORTEUR --}}
<h4>هوية الباعث</h4>
<div class="section row">
    <div class="field">
        <span class="label">الاسم و اللقب أو الاسم التجاري</span>
        <span class="value">{{ $immobilier->utilisateur->nom_prenom ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">رقم الهاتف</span>
        <span class="value">{{ $immobilier->utilisateur->tel ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">البريد الإلكتروني</span>
        <span class="value">{{ $immobilier->utilisateur->email ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">العنوان الشخصي</span>
        <span class="value">{{ $immobilier->utilisateur->adresse ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">الهوية الشخصية</span>
        <span class="value">{{ $typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first()->type_ar ?? '-' }}</span>
    </div>
</div>

{{-- IDENTITÉ DU BIEN --}}
<h4>هوية العقار</h4>
<div class="section row">
    <div class="field">
        <span class="label">عنوان العقار</span>
        <span class="value">{{ $immobilier->adresse_imm ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">الولاية</span>
        <span class="value">{{ $gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first()->nom_ar ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">البلدية</span>
        <span class="value">{{ $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">صيغة العقار</span>
        <span class="value">{{ $typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first()->type_ar ?? '-' }}</span>
    </div>
    <div class="field">
        <span class="label">المساحة الجملية للعقار</span>
        <span class="value">{{ $immobilier->superfici_m2 ?? '-' }} م²</span>
    </div>
    <div class="field">
        <span class="label">صيغة استغلال العقار</span>
        <span class="value">{{ $usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first()->usage_ar ?? '-' }}</span>
    </div>
</div>

{{-- COMPOSANTS DU BIEN --}}
<h4>مكونات العقار</h4>
<div class="section row">
    <table>
        <thead>
            <tr>
                <th>المكوّن</th>
                <th>نعم / لا</th>
                <th>العدد</th>
                <th>المساحة</th>
            </tr>
        </thead>
        <tbody>
            @php
            $components = [
                'salle_exercice' => 'قاعة التمارين',
                'piscine' => 'حوض مائي',
                'vestiaire' => 'حجرات ملابس',
                'unitaires_sanitaire' => 'وحدات صحية',
                'stockage_conservation' => 'فضاء للخزن وحفظ الأثاث والمعدات',
                'espace_exterieur' => 'فضاء خارجي',
                'garage' => 'مأوى سيارات'
            ];
            @endphp
            @foreach($components as $comp => $label)
            <tr>
                <td>{{ $label }}</td>
                <td>@if($immobilier->$comp == 1) نعم @elseif($immobilier->$comp == 0) لا @else - @endif</td>
                <td>@if($immobilier->$comp == 1 && in_array($comp, ['salle_exercice','piscine','vestiaire'])) {{ $immobilier->{'nbr_'.$comp} ?? '-' }} @else - @endif</td>
                <td>@if($immobilier->$comp == 1) {{ $immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : '-' }} @else - @endif</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    <p>مساحات اخرى: {{ $immobilier->autres_surfaces ?? '-' }} م²</p>
</div>

</body>
</html>
