@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if(Auth::check())

<div class="container">
    <form action="{{ route('salle-sport.update', $immobilier->id_imm) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')

        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">

        <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>
        <div class="card shadow-lg border-0 mb-4 rounded-4">
           <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
    <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>

    @switch($immobilier->id_statut)

        @case(1)
            <span class="status-badge status-badge--success">مقبول</span>
            @break

        @case(3)
            <span class="status-badge status-badge--danger">مرفوض</span>
            @break

        @case(4)
            <span class="status-badge status-badge--warning">
                موافقة شريطة
            </span>
            @break

        @case(5)
            <span class="status-badge status-badge--info">
                إرجاء لإبداء الرأي
            </span>
            @break

        @case(2)
            <span class="status-badge status-badge--pending">
                في الانتظار
            </span>
            @break

        @case(6)
            <span class="status-badge status-badge--secondary">
                مسودّة
            </span>
            @break

        @default
            <span class="status-badge status-badge--secondary">
                غير محدد
            </span>

    @endswitch
</div>

           <div class="card-body">
                 <p class="text-muted mb-4 text-center fs-6">
                              إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
                 </p>

    {{-- select statut (inchangé sauf onchange) --}}
<div class="form-group row align-items-center mb-3">
  <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
  <div class="col-sm-4">
<select required
        class="form-control"
        id="id_statut"
        name="id_statut"
        onchange="toggleMotifInput()">

    <option value="">اختر...</option>

    @foreach($statuts as $s)
        @php
            $statutId = $s->id_statut ?? $s->id ?? $s->ID ?? null;

            // Exclude Pending (2) and Draft (6)
            if (in_array($statutId, [2, 6])) {
                continue;
            }

            $label = $s->libelle_ar
                    ?? $s->statut_ar
                    ?? $s->label
                    ?? $s->name
                    ?? $s->statut
                    ?? '—';

            $selected = (string) old('id_statut', $immobilier->id_statut ?? '') === (string) $statutId;
        @endphp

        <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>
            {{ $label }}
        </option>
    @endforeach
</select>

  </div>
</div>

{{-- nouveau div (shown when status is 4 or 5) --}}
<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status" maxlength="100"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق"></textarea>
</div>

{{-- reject textarea shown only when status == 3 --}}
<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
  <textarea name="commentaire_refus" maxlength="100"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض"></textarea>
</div>


          </div>
       </div>
        
{{-- Status history card --}}
{{-- Compact status history (RTL, minimal) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h6>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($immobilier->statutHistories->isEmpty())
      <p class="text-muted mb-0 ">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($immobilier->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar
                    ?? optional($hist->fromStatut)->libelle_ar
                    ?? '—';
            $to = optional($hist->toStatut)->statut_ar
                  ?? optional($hist->toStatut)->libelle_ar
                  ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success'
                         : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* Compact timeline styles (RTL) */
.compact-timeline { display: flex; flex-direction: column; gap: 6px; }
.compact-item { padding: 6px 4px; border-bottom: 1px solid rgba(0,0,0,0.06); }

.compact-row { gap: 8px; align-items: flex-start; }

/* left block (date + user) placed on the right visually because of RTL */
.left-block { width: 160px; min-width: 120px; margin-left: 12px; }
.compact-date { font-size: 12px; color: #6c757d; }
.compact-user { font-size: 11px; color: #8a8f94; margin-top: 2px; }

/* main labels */
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color: #6c757d; font-size: 13px; }
.compact-arrow { color: #6c757d; font-size: 14px; margin: 0 4px; }
.compact-to { font-size: 13px; padding: 3px 8px; border-radius: 10px; }

/* small badge color helpers */
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }

/* comment details (very compact) */
.compact-comment summary {
  list-style: none;
  cursor: pointer;
  outline: none;
  padding: 0;
}

</style>


      <div class="form-section">
            <h4>هوية الباعث</h4>  
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom" 
                        placeholder="الاسم و اللقب أو الاسم التجاري" maxlength="50"
                        value="{{ old('nom_prenom', $immobilier->utilisateur->nom_prenom ?? '') }}">
                </div>
            </div>  

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput2()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $immobilier->utilisateur->id_type_identite ?? '') == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-6" id="identite-fields">
                    <input type="text" class="form-control identite-field" id="cin_input" name="cin" 
                        placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8"
                        style="display:none;"
                        value="{{ old('cin', $immobilier->utilisateur->cin ?? '') }}">
                    <input type="text" class="form-control identite-field" id="passport_input" name="passport" 
                        placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                        style="display:none;"
                        value="{{ old('passport', $immobilier->utilisateur->passport ?? '') }}">
                    <!--input type="text" class="form-control identite-field" id="num_fiscal_input" name="num_fiscal" 
                        placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12"
                        style="display:none;"
                        value="{{ old('num_fiscal', $immobilier->utilisateur->num_fiscal ?? '') }}"-->

                        <input type="text"
                            class="form-control identite-field"
                            id="num_fiscal_input"
                            name="num_fiscal"
                            placeholder="مثال: AB12345/A/B/C/789"
                            pattern="^[A-Za-z0-9]{7}/[A-Za-z]/[A-Za-z]/[A-Za-z]/[A-Za-z0-9]{3}$"
                            title="يرجى احترام صيغة المعرف الجبائي"
                            style="display:none;"
                            value="{{ old('num_fiscal', $immobilier->utilisateur->num_fiscal ?? '') }}">

                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">رقم الهاتف الشخصي</label>
                <div class="col-sm-10">
                    <input  type="text" class="form-control" name="tel" placeholder="رقم الهاتف الشخصي" maxlength="12"
                        value="{{ old('tel', $immobilier->utilisateur->tel ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                <div class="col-sm-10">
                    <input required type="email" class="form-control" name="email" placeholder=" "
                        value="{{ old('email', $immobilier->utilisateur->email ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" placeholder=" " maxlength="100"
                        value="{{ old('adresse', $immobilier->utilisateur->adresse ?? '') }}">
                </div>
            </div>

            <h4>هوية العقار</h4> 
            <div class="form-group row">
                <label for="adresse_imm" class="col-sm-2 col-form-label">عنوان العقار</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" id="adresse_imm" name="adresse_imm" placeholder=" "
                        value="{{ old('adresse_imm', $immobilier->adresse_imm ?? '') }}"
                        oninvalid="this.setCustomValidity('يجب ألا يتجاوز عنوان العقار 100 حرفاً')" 
                        oninput="this.setCustomValidity('')">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الولاية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled {{ old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}"
                                {{ old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') == $gouv->id_gouver ? 'selected' : '' }}>
                                {{ $gouv->nom_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label class="col-sm-2 col-form-label">البلدية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" {{ $immobilier->delegation_id ? '' : 'disabled' }}>
                        <option value="" disabled {{ old('delegation_id', $immobilier->delegation_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @if($immobilier->delegation_id)
                            @foreach($delegations as $del)
                                <option value="{{ $del->id_delegation }}"
                                    {{ old('delegation_id', $immobilier->delegation_id ?? '') == $del->id_delegation ? 'selected' : '' }}>
                                    {{ $del->nom_ar }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
            </div>

            <div class="form-group row">
                <label for="type_imm_id" class="col-sm-2 col-form-label">صيغة العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="type_imm_id" name="type_imm_id">
                        <option value="" disabled {{ old('type_imm_id', $immobilier->type_imm_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @foreach($typesImmobilier as $type)
                            <option value="{{ $type->id_type }}"
                                {{ old('type_imm_id', $immobilier->type_imm_id ?? '') == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label for="superfici_m2" class="col-sm-2 col-form-label">المساحة الجملية للعقار بالم2</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" id="superfici_m2" name="superfici_m2" placeholder=" "
                        value="{{ old('superfici_m2', $immobilier->superfici_m2 ?? '') }}"
                        oninvalid="this.setCustomValidity('المساحة يجب ان لا تتجاوز 100م2')" 
                        oninput="this.setCustomValidity('')" min="100">
                    <span>المساحة يجب ان تكون 100م2 على الاقل.</span>
                </div>                
            </div>

            <div class="form-group row">
                <label for="usage_id" class="col-sm-2 col-form-label">صيغة استغلال العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="usage_id" name="usage_id">
                        <option value="" disabled {{ old('usage_id', $immobilier->usage_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @foreach($usagesImmobilier as $usage)
                            <option value="{{ $usage->id_usage_imm }}"
                                {{ old('usage_id', $immobilier->usage_id ?? '') == $usage->id_usage_imm ? 'selected' : '' }}>
                                {{ $usage->usage_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label for="document_propriete" class="col-sm-2 col-form-label">نسخة العقد/الملكية</label>
				<div class="col-sm-4">
					<input type="file" class="form-control" id="document_propriete" name="document_propriete">
					@if(!empty($immobilier->document_propriete))
						<small>الملف الحالي:
							<a href="{{ route('immobilier.download', $immobilier->id_imm) }}?v={{ time() }}"
							   target="_blank">
							   عرض
							</a>
						   
						</small>
					@endif
				</div>

            </div>
            <h4>مكونات العقار</h4>

            @php
              $components = [
    'salle_exercice','piscine','vestiaire','unitaires_sanitaire',
    'stockage_conservation','espace_exterieur','garage'
];

            @endphp
            @foreach($components as $comp)
                <div class="form-group row">
                    <label for="{{ $comp }}" class="col-sm-2 col-form-label">
                        @switch($comp)
                            @case('salle_exercice') قاعة التمارين @break
                            @case('piscine') حوض مائي @break
                            @case('vestiaire') حجرات ملابس @break
                            @case('unitaires_sanitaire') وحدات صحية @break
                            @case('stockage_conservation') فضاء للخزن و حفض الاثاث و المعدات @break
                            @case('espace_exterieur') فضاء خارجي @break
                            @case('garage') ماوى سيارات @break
                        @endswitch
                    </label>
                    <div class="col-sm-4">
                        <select required class="form-control" id="{{ $comp }}" name="{{ $comp }}" onchange="toggleSection('{{ $comp }}','id_{{ $comp }}')">
                            <option value="" disabled {{ old($comp, $immobilier->$comp ?? '') === null ? 'selected' : '' }}>اختر...</option>
                            <option value="1" {{ old($comp, $immobilier->$comp ?? '') == 1 ? 'selected' : '' }}>نعم</option>
                            <option value="0" {{ old($comp, $immobilier->$comp ?? '') == 0 ? 'selected' : '' }}>لا</option>
                        </select>
                    </div>

                    <div class="col-sm-6" id="id_{{ $comp }}" style="display: {{ old($comp, $immobilier->$comp ?? '') == 1 ? 'block' : 'none' }};">
                          @if(in_array($comp, ['salle_exercice','piscine','vestiaire']))
            <div class="mb-2">
                <input type="number" class="form-control" id="nbr_{{ $comp }}" name="nbr_{{ $comp }}" placeholder="عدد"
                    value="{{ old('nbr_'.$comp, $immobilier->{'nbr_'.$comp} ?? '') }}">
            </div>
            <div>
                <input type="number" class="form-control" id="superface_{{ $comp }}" name="superface_{{ $comp }}" placeholder="مساحة"
                    value="{{ old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '') }}">
            </div>
        @else
            <input type="number" class="form-control" id="superface_{{ $comp }}" name="superface_{{ $comp }}" placeholder="مساحة"
                value="{{ old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '') }}">
        @endif
                    </div>
                </div>
            @endforeach
            <div class="form-group row">
                <label for="autres_surfaces" class="col-sm-2 col-form-label">مساحات اخرى</label>
                <div class="col-sm-10">
                    <input required type="number" class="form-control" id="autres_surfaces" name="autres_surfaces" 
                        value="{{ old('autres_surfaces', $immobilier->autres_surfaces ?? '') }}">
                </div>
            </div>
            
        </div>
        <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('salle-sport.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


    </form>
</div><script>document.addEventListener("DOMContentLoaded", function () {    const gouvSelect = document.getElementById('gouvernorat_id');    const delSelect  = document.getElementById('delegation_id');    gouvSelect.addEventListener('change', function () {        let gouvId = this.value;        delSelect.innerHTML = '';        delSelect.disabled = true;        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';        let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";        url = url.replace("ID_PLACEHOLDER", gouvId);        fetch(url)            .then(response => response.json())            .then(data => {                                delSelect.innerHTML = '<option disabled selected>اختر...</option>';                                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text  = d.nom_ar;                    delSelect.appendChild(option);                });                delSelect.disabled = false;            });    });});</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        @foreach($components as $comp)
            toggleSection('{{ $comp }}','id_{{ $comp }}');
        @endforeach
    });
</script>

@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection