@extends('backoffice.dashboard')
@section('content')

<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
<div class="container">
    <div class="header-print-container mb-4">
        <div class="header-center text-center">
            <h3>استمارة الإعلام ببداية النشاط</h3>
        </div>
        <div class="mt-4 text-center no-print">
            <a href="{{ route('admin.debut_activite.pdf', $debutActivite->id_debut) }}" target="_blank" class="btn btn-danger">
                <i class="fa fa-file-pdf"></i> تحميل PDF
            </a>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
            @if($debutActivite->id_statut == 1)
                <span class="status-badge status-badge--success">مقبول</span>
            @elseif($debutActivite->id_statut == 3)
                <span class="status-badge status-badge--danger">مرفوض</span>
            @else
                <span class="status-badge status-badge--pending">في الانتظار</span>
            @endif
        </div>

        @if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif)
            <div class="card-body">
                <p class="text-danger fw-bold">سبب الرفض:</p>
                <p>{{ $debutActivite->commentaire_motif }}</p>
            </div>
        @endif
    </div>

    {{-- history card (compact) --}}
    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header bg-light py-2">
            <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
        </div>

        <div class="card-body p-2" dir="rtl">
            @if($debutActivite->statutHistories->isEmpty())
                <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
            @else
                <div class="compact-timeline">
                    @foreach($debutActivite->statutHistories as $hist)
                        @php
                            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
                            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
                            $toId = optional($hist->toStatut)->id_statut;
                            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
                            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
                        @endphp

                        <div class="compact-item">
                            <div class="compact-row d-flex align-items-center justify-content-between w-100">
                                <div class="left-block text-end">
                                    <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                                    <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
                                </div>

                                <div class="right-block text-right flex-fill">
                                    <span class="compact-from small text-muted">{{ $from }}</span>
                                    <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                                    <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
                                </div>
                            </div>

                            @if($hist->commentaire)
                                <details class="compact-comment mt-1">
                                    <summary class="very-small text-danger">سبب / تعليق</summary>
                                    <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
                                </details>
                            @endif
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>

    <h4 class="mb-3 fw-bold">هوية الباعث</h4>
    
    {{-- Type de relation --}}
    <div class="row mb-3">
        <div class="col-md-12">
            <!--label class="fw-bold">نوع الاستمارة</label-->
            <input hidden type="text" class="form-control" value="{{ $debutActivite->getTypeFormule() }}" readonly>
        </div>
    </div>

    {{-- Informations utilisateur --}}
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">الاسم و اللقب أو الاسم التجاري</label>
            <input type="text" class="form-control" value="{{ $utilisateur ? $utilisateur->nom_prenom : '-' }}" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">رقم الهوية</label>
            <input type="text" class="form-control" 
                value="{{ $utilisateur ? ($utilisateur->cin ?? $utilisateur->passport ?? $utilisateur->num_fiscal ?? '-') : '-' }}" 
                readonly>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">الهاتف</label>
            <input type="text" class="form-control" value="{{ $utilisateur ? $utilisateur->tel : '-' }}" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">البريد الإلكتروني</label>
            <input type="text" class="form-control" value="{{ $utilisateur ? $utilisateur->email : '-' }}" readonly>
        </div>
    </div>

    {{-- Adresse --}}
    @if($utilisateur && $utilisateur->adresse)
    <div class="row mb-3">
        <div class="col-md-12">
            <label class="fw-bold">العنوان</label>
            <input type="text" class="form-control" value="{{ $utilisateur->adresse }}" readonly>
        </div>
    </div>
    @endif

    {{-- Gouvernorat --}}
    @if($gouvernorat)
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">المندوبية الجهوية للشباب و الرياضة</label>
            <input type="text" class="form-control" value="{{ $gouvernorat->nom_ar }}" readonly>
        </div>
    </div>
    @endif

    <h4 class="mb-3 fw-bold">تاريخ بداية النشاط</h4>
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">التاريخ</label>
            <input type="text" class="form-control" 
                value="{{ $debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : '-' }}" 
                readonly>
        </div>
    </div>
    <p class="text-muted">تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.</p>

    <h4 class="mb-3 fw-bold">الوثائق المرفقة</h4>

    @php
        $docs = [
            'preuve_propriete_location' => [
                'label' => 'نسخة من شهادة الملكية أو عقد الكراء',
                'desc'  => 'وثيقة تثبت ملكية أو كراء الفضاء'
            ],
            'plan_architectural' => [
                'label' => 'مخطط معماري',
                'desc'  => 'المخطط الهندسي المعتمد'
            ],
            'declaration_investissement' => [
                'label' => 'شهادة تصريح بالاستثمار',
                'desc'  => 'تصريح رسمي بالاستثمار'
            ],
            'identification' => [
                'label' => 'بطاقة تعريف / جواز سفر',
                'desc'  => 'وثيقة تعريف صاحب المشروع'
            ],
            'extrait_registre_national_entreprise' => [
                'label' => 'السجل الوطني للمؤسسات',
                'desc'  => 'وثيقة تسجيل المؤسسة'
            ],
            'certificat_prevention' => [
                'label' => 'شهادة الوقاية',
                'desc'  => 'وثيقة السلامة والوقاية'
            ],
            'contrat_assurance' => [
                'label' => 'عقد التأمين',
                'desc'  => 'عقد تأمين ساري المفعول'
            ],
            'approbation_autorite_minicipale' => [
                'label' => 'اعتماد السلطة المحلية',
                'desc'  => 'ترخيص من السلطة المحلية'
            ],
        ];
    @endphp

    @foreach($docs as $field => $meta)
        <div class="border rounded-3 p-3 mb-3 bg-light shadow-sm">
            {{-- Label --}}
            <div class="fw-bold mb-1">
                {{ $meta['label'] }}
            </div>

            {{-- Action --}}
            @if(!empty($debutActivite->$field))
                <a href="{{ route('debutActivite.download', ['id' => $debutActivite->id_debut, 'field' => $field]) }}"
                   target="_blank"
                   class="btn btn-sm btn-outline-primary mt-1">
                    <i class="fa fa-eye"></i> عرض الملف
                </a>
            @else
                <span class="text-muted">غير متوفر</span>
            @endif

            {{-- Description --}}
            @if(!empty($meta['desc']))
                <div class="small text-muted mt-2">
                    {{ $meta['desc'] }}
                </div>
            @endif
        </div>
    @endforeach

    <div class="form-group text-center mt-5">
        <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
            <a href="{{ route('admin.debut_activite.pdf', $debutActivite->id_debut) }}" target="_blank" class="btn btn-danger d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="fa fa-file-pdf"></i> تحميل PDF
            </a>
            <a href="{{ route('admin.debut_activite.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
            </a>
        </div>
    </div>
</div>

<style>
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>

@endsection