<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $direction }}">
<head>
<meta charset="utf-8">

<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: {{ $direction }};
    text-align: {{ $direction == 'rtl' ? 'right' : 'left' }};
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* TITRES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-{{ $direction == 'rtl' ? 'right' : 'left' }}: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARQUES */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
}
</style>
</head>

<body>

{{-- HEADER --}}
<div class="header">
    <table width="100%" style="border:none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="{{ public_path('storage/logo.png') }}" style="width:90px;">
            </td>
            <td style="text-align:center; border:none;">
                <h3>{{ $formulaire->type_ar }}</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>

{{-- IDENTITÉ PORTEUR --}}
<h4>المستثمر</h4>
<div class="section">
@php
    $user = $institution->investissements->first()?->utilisateur;
@endphp

    <div class="row">
        <div class="field">
            <span class="label">الاسم و اللقب</span>
            <span class="value">{{ $user->nom_prenom ?? '-' }}</span>
        </div>

       <div class="row">
            <div class="field">
                <span class="label">مكان الولادة</span>
                <span class="value">{{ $user->lieu_naissance ?? '-' }}</span>
            </div>

            <div class="field">
                <span class="label"> 
تاريخ الولادة</span>
                <span class="value">{{ $user->date_naissance ?? '-' }}</span>
            </div>
        </div>


        
        <div class="field">
            <span class="label">العنوان الشخصي</span>
            <span class="value">{{ $user->adresse ?? '-' }}</span>
        </div>
    </div>

    <div class="row">
        <div class="field">
            <span class="label">الهوية الشخصية</span>
            <span class="value">{{ $institution->investissements->first()?->utilisateur->typeIdentite->type_ar ?? '-' }}</span>
        </div>

        <div class="row">
        @if($user->id_type_identite == 1)
            <div class="field">
                <span class="label">رقم بطاقة التعريف الوطنية</span>
                <span class="value">{{ $user->cin ?? '-' }}</span>
            </div>
            <div class="field">
                <span class="label">تاريخ إصدار البطاقة</span>
                <span class="value">{{ $user->date_delivrance_cin ?? '-' }}</span>
            </div>
            <div class="field">
                <span class="label">مكان الإصدار</span>
                <span class="value">{{ $user->lieu_delivrance_cin ?? '-' }}</span>
            </div>
        @elseif($user->id_type_identite == 2)
            <div class="field">
                <span class="label">جواز السفر</span>
                <span class="value">{{ $user->passport ?? '-' }}</span>
            </div>
        @elseif($user->id_type_identite == 3)
            <div class="field">
                <span class="label">الرقم الضريبي</span>
                <span class="value">{{ $user->num_fiscal ?? '-' }}</span>
            </div>
        @endif
    </div>

    <div class="field">
                <span class="label">المستوى التعليمي</span>
                <span class="value">{{ $institution->niveau_etude_user ?? '-' }}</span>
            </div>
 <div class="field">
                <span class="label">آخر شهادة متحصل عليها</span>
                <span class="value">{{ $institution->dernier_diplome_user ?? '-' }}</span>
            </div>

    <div class="field">
                <span class="label">الاقدمية في تعاطي النشاط</span>
                <span class="value">{{ $institution->experience_user ?? '-' }}</span>
            </div>

            

        
    </div>
</div>

{{-- INFORMATIONS INSTITUTION --}}
<h4>خاصيات النشاط</h4>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">المؤسسة الشبابية الخاصة</span>
            <span class="value">{{ $types_espace->firstWhere('id_type', $institution->type_espace_id)?->type_ar ?? 'غير محدد' }}</span>
        </div>

        <div class="field">
            <span class="label">عدد الغرف</span>
            <span class="value">{{ $institution->nbr_chambre ?? __('site.jeunesse.table.no_value') }}</span>
        </div>
        <div class="field">
            <span class="label">عدد القاعات</span>
            <span class="value">{{ $institution->nbr_salles ?? __('site.jeunesse.table.no_value') }}</span>
        </div>
<div class="field">
            <span class="label">طاقة الاستعاب</span>
        </div>
<div class="field">
            <span class="label">بالمبيت</span>
            <span class="value">{{ $institution->capacite_accueil_hebergement ?? __('site.jeunesse.table.no_value') }}</span>
        </div>
  <div class="field">
            <span class="label">تحت الخيام</span>
            <span class="value">{{ $institution->capacite_accueil_sous_tente ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">بفضاءات التنشيط</span>
            <span class="value">{{ $institution->capacite_accueil_espace_animation ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        

    <div class="field">
            <span class="label">الاسم التجاري للمشروع</span>
            <span class="value"> {{ $institution->nom_projet ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">طبيعة المشروع</span>
            <span class="value">  {{ $nature_projet->firstWhere('id_nature_p', $institution->nature_projet_id)?->nature_ar ?? 'غير محدد' }}</span>
        </div>
       

<div class="field">
            <span class="label">عدد مواطن الشغل</span>
            <span class="value">{{ $institution->nbr_emplois ?? __('site.jeunesse.table.no_value') }}</span>
        </div>
</div>

{{-- DIRECTEUR --}}
<h4>مدير المؤسسة</h4>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">الاسم و اللقب</span>
            <span class="value">{{ $institution->directeur->nom_prenom_d ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">رقم بطاقة التعريف الوطنية</span>
            <span class="value">{{ $institution->directeur->num_cin ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">تاريخ إصدار البطاقة</span>
            <span class="value">{{ $institution->directeur->date_delivrance ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">مكان الإصدار</span>
            <span class="value">{{ $institution->directeur->lieu_delivrance ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">المستوى التعليمي</span>
            <span class="value">{{ $institution->directeur->niveau_etude ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

        <div class="field">
            <span class="label">آخر شهادة متحصل عليها</span>
            <span class="value">{{ $institution->directeur->dernier_diplome_obtenu ?? __('site.jeunesse.table.no_value') }}</span>
        </div>

    </div>
</div>

{{-- INVESTISSEMENTS --}}
<h4>جدول الاستثمار و التمويل</h4>
<div class="section">
<table>
    <thead>
        <tr>
            <th>الإستثمار</th>
            <th>مبلغ الإستثمار</th>
            <th>مصادر التمويل</th>
            <th>مبلغ التمويل</th>
        </tr>
    </thead>
    <tbody>
        @foreach($institution->investissements as $inv)
        <tr>
            <td> {{ $secteurs->firstWhere('id_secteur', $inv->secteur_invest_id)?->secteur_ar ?? 'غير محدد' }}</td>
            <td>{{ number_format($inv->montant_inv,2) }}</td>
            <td> {{ $source_fin->firstWhere('id_source', $inv->id_source_financement)?->source_ar ?? 'غير محدد' }}</td>
            <td>{{ number_format($inv->montant_fin, 2) ?? __('site.jeunesse.table.no_value') }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
</div>

{{-- DECLARATION --}}
<div class="section">
    <strong>تصريح على الشرف</strong><br>
    إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
</div>
<div class="remarks-block">
        <strong>ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</strong><br>
        {{ old('remarques', $institution->remarques) ?? '' }}
    </div>
</body>
</html>
