@extends('backoffice.dashboard')

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">

                <div class="block-card-header px-4 pb-3 border-bottom-0">
    <div class="d-flex flex-wrap align-items-center justify-content-between">
        <h2 class="widget-title mb-0">استمارات المؤسسات الخاصة بالشباب و الأطفال</h2>
        <div class="d-flex align-items-center gap-2 action-buttons">
            <a href="{{ route('admin.jeunesse.export.excel', request()->query()) }}"
               class="btn btn-outline-primary btn-icon btn-icon-excel d-flex align-items-center justify-content-center"
               title="Excel">
                <i class="fa-solid fa-file-excel"></i>
            </a>

            <a href="{{ route('admin.jeunesse.export.pdf', request()->query()) }}" target="_blank"
               class="btn btn-outline-danger btn-icon btn-icon-pdf d-flex align-items-center justify-content-center"
               title="PDF">
                <i class="fa-solid fa-file-pdf"></i>
            </a>

          <!--  <a href="{{ route('admin.jeunesse.create') }}"
               class="btn btn-success d-flex align-items-center justify-content-center">
                <i class="la la-plus me-1"></i>
                إضافة استمارة
            </a>-->
        </div>
    </div>
</div>

<style>
.action-buttons .btn {
    height: 42px;
    min-width: 42px;
    padding: 0 14px;
}

.btn-icon-excel {
    background-color: #fff !important;
    border: 1px solid #0d6efd !important;   
    color: #0d6efd !important;               
}
.btn-icon-excel:hover {
    background-color: #e3f2fd !important;   
    color: #0d6efd !important;                
    border-color: #0d6efd !important;
}
.btn-icon-excel i { color: inherit !important; }

.btn-icon-pdf {
    background-color: #fff !important;
    border: 1px solid #e74c3c !important;   
    color: #e74c3c !important;               
}
.btn-icon-pdf:hover {
    background-color: #fde8ea !important;  
    color: #e74c3c !important;               
    border-color: #e74c3c !important;
}
.btn-icon-pdf i { color: inherit !important; }
</style>


<div class="block-card-header px-4 border-bottom-0 pb-0">
    <form method="GET" action="{{ route('admin.jeunesse.index') }}">
        <div class="form-row align-items-center">

            {{-- اختيار نوع البحث --}}
            <div class="col-auto" style="width: 200px;">
                <select id="search-option" class="form-control"
                        name="search_option" onchange="showSearchInputs(this.value)">
                    <option value="">اختر نوع البحث</option>
                    <option value="nom" {{ request('search_option') == 'nom' ? 'selected' : '' }}>الاسم و اللقب</option>
                    <option value="nature" {{ request('search_option') == 'nature' ? 'selected' : '' }}>طبيعة المشروع</option>
                    <option value="identite" {{ request('search_option') == 'identite' ? 'selected' : '' }}>نوع الهوية</option>
                </select>
            </div>

            {{-- البحث بالاسم --}}
            <div class="col-auto" id="searchByName" style="display:none; width: 250px;">
                <input type="text" class="form-control" name="nom"
                       placeholder="أدخل الاسم و اللقب" value="{{ request('nom') }}">
            </div>

            {{-- البحث بطبيعة المشروع --}}
            <div class="col-auto" id="searchByNature" style="display:none; width: 230px;">
                <select class="form-control" name="nature">
					<option value="">-- اختر طبيعة المشروع --</option>
					@foreach($natures as $nature)
						<option value="{{ $nature->id_nature_p }}"
							{{ request('nature') == $nature->id_nature_p ? 'selected' : '' }}>
							{{ $nature->nature_ar }}
						</option>
					@endforeach
				</select>
            </div>

            {{-- البحث بنوع الهوية --}}
            <div class="col-auto" id="searchByIdentite" style="display:none; width: 200px;">
                <select class="form-control" name="type_identite" onchange="showIdentityFields(this.value)">
                    <option value="">-- نوع الهوية --</option>
                    <option value="1" {{ request('type_identite') == 1 ? 'selected' : '' }}>بطاقة تعريف</option>
                    <option value="2" {{ request('type_identite') == 2 ? 'selected' : '' }}>جواز سفر</option>
                    <option value="3" {{ request('type_identite') == 3 ? 'selected' : '' }}>رقم جبائي</option>
                </select>
            </div>

            <div class="col-auto" id="inputCIN" style="display:none; width: 200px;">
                <input type="text" class="form-control" name="cin"
                       placeholder="أدخل رقم البطاقة" value="{{ request('cin') }}">
            </div>

            <div class="col-auto" id="inputPassport" style="display:none; width: 200px;">
                <input type="text" class="form-control" name="passport"
                       placeholder="أدخل رقم الجواز" value="{{ request('passport') }}">
            </div>

            <div class="col-auto" id="inputFiscal" style="display:none; width: 200px;">
                <input type="text" class="form-control" name="num_fiscal"
                       placeholder="أدخل الرقم الجبائي" value="{{ request('num_fiscal') }}">
            </div>

            <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width:110px;">
                    بحث
                </button>
				
				<a href="{{ route('admin.jeunesse.index') }}" class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
					style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
					<i class="fa-solid fa-rotate-right" style="font-size: 16px;"></i>
				</a>
            </div>

        </div>
    </form>
</div>


                  <div class="block-card-body">        
				  @if(session('success'))           
					  <div class="alert alert-success alert-dismissible fade show" role="alert"> 
				  {{ session('success') }}              
				  <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
				  </div>         
				  @endif 
				  
				  <div class="my-table table-responsive" style="direction: rtl; text-align: right;">   
				  <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;"> 
				  <thead class="thead-light">                
				  <tr>
                                     <th>المعرف</th>
                                    <th>الاسم و اللقب </th>
                                    <th>طبيعة المشروع</th>
                                    <th width="15%">وضعية الطلب</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($institutions as $institution)
                                <tr>
                                    <td>{{ $institution->id_inst }}</td>
                                    <td>{{ $institution->investissements->first()?->utilisateur?->nom_prenom ?? '---' }}</td>
                                    <td>{{ $institution->natureProjet?->nature_ar ?? '---' }}</td>
                                    <td>
                                        <span class="status-badge 
                                            {{ $institution->id_statut == 1 ? 'status-badge--success' : ($institution->id_statut == 3 ? 'status-badge--danger' : 'status-badge--pending') }}">
                                            {{ $institution->statut?->statut_ar ?? 'في الانتظار' }}
                                        </span>
                                    </td>

                                    <td class="btn-group">
                                        <a   class="btn-icon btn-icon--info" title="عرض" href="{{ route('admin.jeunesse.show', $institution->id_inst) }}">
                                            <i class="la la-eye"></i>
                                        </a>
                                       @if($institution->id_statut == 2 || $institution->id_statut == 4 || $institution->id_statut == 5)
                                      
                                            <a  class="btn-icon btn-icon--warning" title="تعديل" href="{{ route('admin.jeunesse.edit', $institution->id_inst) }}" 
										
											   
											   >
                                                <i class="la la-edit"></i>
                                            </a>

                                            <form action="{{ route('admin.jeunesse.toggle_statut', $institution->id_inst) }}" 
                                                method="POST" 
                                                class="form-modifier-statut mr-2" 
                                                style="display:inline;">
                                                @csrf
                                                @method('PATCH')

                                            
                                                    
                                                </button>
												<button type="button" onclick="confirmStatusChange2(this.closest('form'), '{{ $institution->statut?->statut_ar }}')" class="btn-icon btn-icon--secondary" title="تغيير الحالة">
                                                    <i class="la la-toggle-on"></i>
                                                 </button>	
												
                                            </form>

                                            <form action="{{ route('admin.jeunesse.destroy', $institution->id_inst) }}" 
                                                  method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" 
                                                        onclick="return confirmAction('هل تريد حذف هذا الاستمارة؟', null, this.closest('form'))" 
                                                        class="btn-icon btn-icon--danger"                                          title="حذف">
                                                    <i class="la la-trash"></i>
                                                </button>
                                            </form>
											
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد استمارات</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
<div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $institutions->links('pagination::bootstrap-5') }}
                    </div>
                   
                </div>

            </div>
        </div>
    </div>
</div>
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('assets/js/index.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function showSearchInputs(option) {
    document.getElementById("searchByName").style.display = "none";
    document.getElementById("searchByNature").style.display = "none";
    document.getElementById("searchByIdentite").style.display = "none";

    if (option === "nom") document.getElementById("searchByName").style.display = "block";
    if (option === "nature") document.getElementById("searchByNature").style.display = "block";
    if (option === "identite") document.getElementById("searchByIdentite").style.display = "block";

    showIdentityFields(null);
}

function showIdentityFields(type) {
    document.getElementById("inputCIN").style.display = "none";
    document.getElementById("inputPassport").style.display = "none";
    document.getElementById("inputFiscal").style.display = "none";

    if (type == 1) document.getElementById("inputCIN").style.display = "block";
    if (type == 2) document.getElementById("inputPassport").style.display = "block";
    if (type == 3) document.getElementById("inputFiscal").style.display = "block";
}

// Rendre persistant après rafraîchissement
document.addEventListener("DOMContentLoaded", function () {
    showSearchInputs("{{ request('search_option') }}");
    showIdentityFields("{{ request('type_identite') }}");
});
</script>

@endsection
