@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.jeunesse2.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h4 style="text-align:center;"> الإدارة العامة للشباب </h4>

        
        <h3>{{ $formulaire->type_ar }}</h3>
        <div class="form-section">
            <h4>المستثمر</h4>
            
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom" placeholder="الاسم و اللقب   " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}">{{ $type->type_ar }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:none;">
                    <input type="text" class="form-control" id="cin_input" name="cin" placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:none;">
                    <input type="text" class="form-control" id="passport_input" name="passport" placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:none;">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:none;">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" placeholder="تاريخ إصدار البطاقة">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" placeholder="مكان الإصدار">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" placeholder="الاقدمية في تعاطي النشاط  " maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> تنظيم الأنشطة الترفيهية للشباب و الطفولة  </strong>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><strong>الإستثمار في هذا النشاط</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" id="id_statut_inv" name="id_statut_inv">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($statut_inv as $statut)
                            <option value="{{ $statut->id_status }}">
                                {{ $statut->statut_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label class="col-sm-2 col-form-label"><strong>طبيعة الأنشطة</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" id="id_nature_activite" name="id_nature_activite">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($nature_activite as $nature)
                            <option value="{{ $nature->id_nature_ac }}">
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="الاسم التجاري للمشروع " maxlength="100">
                </div>
                <label class="col-sm-2 col-form-label" for=""> عنوان المقر الاجتماعي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="عنوان المقر الاجتماعي" maxlength="100">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-2 col-form-label"> الولاية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}">{{ $gouv->nom_ar }}</option>
                        @endforeach
                    </select>
                </div>
                <label class="col-sm-2 col-form-label"> البلدية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" disabled>
                        <option value="" disabled selected>اختر...</option>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الترقيم البريدي </label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="code_postal">
                </div>
            </div>
            
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>  مبلغ الإستثمار </th>
                        <th> التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[0][secteur_invest_id]" id="secteur_invest_id_0">
                                <option value="" disabled selected>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[0][montant_inv]" class="form-control" min=1>
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[0][id_source_financement]" id="id_source_financement">
                                <option value="" disabled selected>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[0][montant_fin]" class="form-control" min=1>
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto">
                <button type="submit" class="btn btn-success font-weight-medium" style="width:100px;margin-right:250px;">إرسال</button>
            </div>
            <div class="col-sm-4 mx-auto">
                <a href="{{ route('admin.jeunesse2.index') }}" class="btn btn-primary" style="width:100px;margin-left:250px;">
                    <i class="bi bi-arrow-left"></i> رجوع
                </a>
            </div>
        </div>
    </form>
</div>

<script>document.getElementById('gouvernorat_id').addEventListener('change', function() {    let gouvId = this.value;   
 let delegationSelect = document.getElementById('delegation_id');  
 delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>'; 
 delegationSelect.disabled = true;  
 let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";   
 url = url.replace("ID_PLACEHOLDER", gouvId);   
 fetch(url)        
 .then(response => response.json())     
 .then(data => {         
 delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';          
 data.forEach(d => {             
 let option = document.createElement('option');       
 option.value = d.id_delegation;          
 option.text = d.nom_ar;              
 delegationSelect.add(option);         
 });           
 delegationSelect.disabled = false;    
 });});
 </script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
            textareaGroup.style.display = checkbox.checked ? "block" : "none";
            checkbox.addEventListener("change", function() {
                textareaGroup.style.display = this.checked ? "block" : "none";
            });
        }
        toggleTextarea("espace_spectacle", "caracteristique_group");
        toggleTextarea("espace_sportif", "caracteristique_sportif_group");
        toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
        toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");

    });
</script>

<script>
    let investIndex = 1; 
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                            <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="المبلغ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection