<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $direction }}">
<head>
<meta charset="utf-8">
<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: {{ $direction }};
    text-align: {{ $direction == 'rtl' ? 'right' : 'left' }};
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* SECTION TITLES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-{{ $direction == 'rtl' ? 'right' : 'left' }}: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARKS */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
    background-color: #fff;
}


</style>
</head>

<body>

{{-- HEADER --}}
<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="{{ public_path('storage/logo.png') }}" style="width:90px; height:auto;">
            </td>
            <td style="text-align:center; border:none;">
                <h3>{{ $formulaire->type_ar }}</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>
@php
    $user = $projet->investissements->first()?->utilisateur;
@endphp

{{-- IDENTITÉ --}}
<h4>المستثمر</h4>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">الاسم و اللقب</span>
            <span class="value">{{ $user->nom_prenom ?? '-' }}</span>
        </div>
        <div class="field">
            <span class="label">مكان الولادة</span>
            <span class="value">{{ $user->lieu_naissance ?? '-' }}</span>
        </div>
    </div>
    <div class="row">
        <div class="field">
            <span class="label">
تاريخ الولادة</span>
            <span class="value">{{ $user->date_naissance ?? '-' }}</span>
        </div>
        <div class="field">
            <span class="label">الهوية الشخصية</span>
            <span class="value">{{ $projet->investissements->first()?->utilisateur->typeIdentite->type_ar ?? '-' }}</span>
        </div>
    </div>

    {{-- Identité spécifique --}}
    <div class="row">
        @if($user->id_type_identite == 1)
            <div class="field">
                <span class="label">رقم بطاقة التعريف الوطنية</span>
                <span class="value">{{ $user->cin ?? '-' }}</span>
            </div>
            <div class="field">
                <span class="label">تاريخ إصدار البطاقة</span>
                <span class="value">{{ $user->date_delivrance_cin ?? '-' }}</span>
            </div>
             <div class="field">
                <span class="label"> مكان الإصدار </span>
                <span class="value"> {{ $user->lieu_delivrance_cin ?? '-' }}</span>
            </div>
        @elseif($user->id_type_identite == 2)
            <div class="field">
                <span class="label">جواز السفر</span>
                <span class="value">{{ $user->passport ?? '-' }}</span>
            </div>
        @elseif($user->id_type_identite == 3)
            <div class="field">
                <span class="label">الرقم الضريبي</span>
                <span class="value">{{ $user->num_fiscal ?? '-' }}</span>
            </div>
        @endif
    </div>

    <div class="row">
        <div class="field">
            <span class="label">العنوان الشخصي</span>
            <span class="value">{{ $user->adresse ?? '-' }}</span>
        </div>
        <div class="field">
            <span class="label">المستوى التعليمي</span>
            <span class="value">{{ $projet->niveau_etude_user ?? __('site.not_specified') }}</span>
        </div>
    </div>

    <div class="row">
        <div class="field">
            <span class="label">آخر شهادة متحصل عليها</span>
            <span class="value">{{ $projet->dernier_diplome_user ?? __('site.not_specified') }}</span>
        </div>
        <div class="field">
            <span class="label">الاقدمية في تعاطي النشاط</span>
            <span class="value">{{ $projet->experience_user ?? __('site.not_specified') }}</span>
        </div>
    </div>
</div>

{{-- PROJECT CHARACTERISTICS --}}
<h4>خصائص المشروع الترفيهي</h4>
<div class="section">
    @foreach([
        ['flag'=>$projet->espace_spectacle, 'label'=>'فضاءات ترفيهية و الهواء الطلق و العروض', 'value'=>$projet->caracteristique_spec],
        ['flag'=>$projet->espace_sportif, 'label'=>'فضاءات ترفيهية رياضية', 'value'=>$projet->caracteristique_sportif],
        ['flag'=>$projet->espace_activite_service, 'label'=>'فضاء الأنشطة الخدماتية', 'value'=>$projet->caracteristique_activite_serv],
        ['flag'=>$projet->espace_activite_culturelle, 'label'=>'فضاء الأنشطة القافية و الفنية و العلمية', 'value'=>$projet->caracteristique_activite_cult],
    ] as $item)
        @if($item['flag'])
            <div class="row">
                <div class="field">
                    <span class="label">✔ {{ $item['label'] }}</span>
                    @if(!empty($item['value']))
                        <span class="value">{{ $item['value'] }}</span>
                    @endif
                </div>
            </div>
        @endif
    @endforeach
    @if(!$projet->espace_spectacle && !$projet->espace_sportif && !$projet->espace_activite_service && !$projet->espace_activite_culturelle)
        <div class="row">
            <span class="value">{{ __('site.not_specified') }}</span>
        </div>
    @endif
</div>

{{-- PROJECT NATURE & NUMBER POSITIONS --}}
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">طبيعة المشروع</span>
            <span class="value"> {{ $projet->natureProjet->nature_ar ?? '-' }}</span>
        </div>
        <div class="field">
            <span class="label">عدد مواطن الشخل المؤملة</span>
        </div>
        <div class="field">
            <span class="label">من حاملي الشهادات العلمية</span>
            <span class="value">{{ $projet->nbr_diplome_universitaire ?? __('site.not_specified') }}</span>
        </div>
    </div>
    <div class="row">
        <div class="field">
            <span class="label">اخرين</span>
            <span class="value">{{ $projet->nbr_autre ?? __('site.not_specified') }}</span>
        </div>
    </div>
</div>

{{-- DIRECTOR --}}
<h4>مدير المؤسسة</h4>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">الاسم و اللقب</span>
            <span class="value">{{ $projet->directeur->nom_prenom_d ?? __('site.not_specified') }}</span>
        </div>
        <div class="field">
            <span class="label">رقم بطاقة التعريف الوطنية</span>
            <span class="value">{{ $projet->directeur->num_cin ?? __('site.not_specified') }}</span>
        </div>
    </div>
    <div class="row">
        <div class="field">
            <span class="label">تاريخ إصدار البطاقة</span>
            <span class="value">{{ $projet->directeur->date_delivrance ?? __('site.not_specified') }}</span>
        </div>
        <div class="field">
            <span class="label">مكان الإصدار</span>
            <span class="value">{{ $projet->directeur->lieu_delivrance ?? __('site.not_specified') }}</span>
        </div>
    </div>
    <div class="row">
        <div class="field">
            <span class="label">المستوى التعليمي</span>
            <span class="value">{{ $projet->directeur->niveau_etude ?? __('site.not_specified') }}</span>
        </div>
        <div class="field">
            <span class="label">آخر شهادة متحصل عليها</span>
            <span class="value">{{ $projet->directeur->dernier_diplome_obtenu ?? __('site.not_specified') }}</span>
        </div>
    </div>
</div>

{{-- INVESTISSEMENTS --}}
<h4>بيانات عن الاستثمار و التمويل
</h4>
<div class="section">
    <table>
        <thead>
            <tr>
                <th>الإستثمار</th>
                <th>المبلغ</th>
                <th>مصادر التمويل</th>
                <th>الملاحظات</th>
            </tr>
        </thead>
        <tbody>
            @foreach($projet->investissements as $inv)
            <tr>
                 <td>{{ $inv->secteur_invest_id }}</td>
                     
                <td>{{ number_format($inv->montant_inv,2) }}</td>
                <td>{{ $inv->source }}</td>
                <td>{{ $inv->remarques }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

{{-- DECLARATION & REMARQUES --}}
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">تصريح على الشرف</span>
            <span class="value">إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.</span>
        </div>
    </div>
    <div class="remarks-block">
        <strong>ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</strong><br>
        {{ old('remarques', $projet->remarques) ?? '' }}
    </div>
</div>

</body>
</html>
