@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.formation.update', $formation->id_inv_sport) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT')
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
          <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

   <div class="form-group row align-items-center mb-3">
  <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
  <div class="col-sm-4">
    <select class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInputSport()">
      <option value="">اختر...</option>
      @foreach($statuts as $s)
        @php
          $statutId = $s->id_statut ?? $s->id ?? $s->ID;
          if (in_array($statutId, [2,6])) continue; // hide pending & draft if desired
          $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
          $selected = (string) old('id_statut', $formation->id_statut ?? '') === (string) $statutId;
        @endphp
        <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>{{ $label }}</option>
      @endforeach
    </select>
  </div>
</div>

<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea maxlength="100" name="commentaire_status" id="commentaire_status" class="form-control border-warning shadow-sm"
            rows="3" placeholder="الرجاء إدخال السبب أو التعليق">{{ old('commentaire_status') }}</textarea>
</div>

<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
  <textarea maxlength="100" name="commentaire_refus" id="commentaire_refus" class="form-control border-danger shadow-sm"
            rows="3" placeholder="الرجاء إدخال سبب الرفض">{{ old('commentaire_refus') }}</textarea>
</div>

<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($formation->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($formation->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to   = optional($hist->toStatut)->statut_ar   ?? optional($hist->toStatut)->libelle_ar   ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId == 1 ? 'badge-success' : ($toId == 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="{{ old('nom_prenom', $formation->investissements->first()?->utilisateur->nom_prenom) }}" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="{{ old('lieu_naissance', $formation->investissements->first()?->utilisateur->lieu_naissance) }}" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="{{ old('date_naissance', $formation->investissements->first()?->utilisateur->date_naissance) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="{{ old('adresse', $formation->investissements->first()?->utilisateur->adresse) }}" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude_user" 
                           value="{{ old('niveau_etude_user', $formation->niveau_etude_user) }}" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_user" 
                           value="{{ old('dernier_diplome_user', $formation->dernier_diplome_user) }}" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience_user" 
                           value="{{ old('experience_user', $formation->experience_user) }}" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات المشروع </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المكونات  </strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center mb-3">
                <div class="col-sm-4">
                    <label for="type_espace_s_id" class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختيار </strong>
                    </label>
                </div>

                <div class="col-sm-4">
                    <select required class="form-control" id="type_espace_s_id" name="type_espace_s_id">
                        <option value="" disabled {{ $formation->type_espace_s_id ? '' : 'selected' }}>اختر...</option>
                        @foreach($types_espace_es as $type)
                            <option value="{{ $type->id_type_es }}"
                                {{ $formation->type_espace_s_id == $type->id_type_es ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_chambre" name="nbr_chambre" min="1" 
                        value="{{ old('nbr_chambre', $formation->nbr_chambre) }}">
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salles" name="nbr_salles" min="1" 
                        value="{{ old('nbr_salles', $formation->nbr_salles) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الملاعب </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_stade" name="nbr_stade" min="1" 
                        value="{{ old('nbr_stade', $formation->nbr_stade) }}">
                </div>

                <label class="col-sm-2 col-form-label"> عدد حجرات الملابس </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_vestiaire" name="nbr_vestiaire" min="1" 
                        value="{{ old('nbr_vestiaire', $formation->nbr_vestiaire) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد مسالك الرياضية </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_stages_sportifs" name="nbr_stages_sportifs" min="1" 
                        value="{{ old('nbr_stages_sportifs', $formation->nbr_stages_sportifs) }}">
                </div>

                <label class="col-sm-2 col-form-label"> قاعة تقوية العضلات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salle_renforcement_musculaire" name="nbr_salle_renforcement_musculaire" min="1" 
                        value="{{ old('nbr_salle_renforcement_musculaire', $formation->nbr_salle_renforcement_musculaire) }}">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> بالمبيت </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_foyer" name="capacite_accueil_foyer" min="1"
                        value="{{ old('capacite_accueil_foyer', $formation->capacite_accueil_foyer) }}">
                </div>

                <label class="col-sm-2 col-form-label"> الملاعب و فضاءات التنشيط </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_stade" name="capacite_accueil_stade" min="1"
                        value="{{ old('capacite_accueil_stade', $formation->capacite_accueil_stade) }}">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" name="heberg_rest" value="1"
                    {{ old('heberg_rest', $formation->heberg_rest) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                    الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="stage_activ" name="stage_activ" value="1"
                    {{ old('stage_activ', $formation->stage_activ) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="stage_activ">
                    إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_exercice" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_exercice" name="espace_exercice" value="1"
                    {{ old('espace_exercice', $formation->espace_exercice) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_exercice">
                    فضاء التمارين
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activite_culturel" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activite_culturel" name="activite_culturel" value="1"
                    {{ old('activite_culturel', $formation->activite_culturel) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="activite_culturel">
                    التنشيط الثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="manifestation_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="manifestation_sportif" name="manifestation_sportif" value="1"
                    {{ old('manifestation_sportif', $formation->manifestation_sportif) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="manifestation_sportif">
                    التظاهرات الرياضية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autres" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autres" name="autres" value="1"
                    {{ old('autres', $formation->autres) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="autres">
                    غير ذلك
                </label>

                <div id="autres_services_wrapper" class="{{ old('autres', $formation->autres) ? 'd-flex align-items-center' : 'd-none' }}">
                    <input
                        class="form-control form-control-sm"
                        type="text"
                        id="autres_services"
                        name="autres_services"
                        placeholder="أدخل الخدمة الأخرى"
                        dir="rtl"
                        value="{{ old('autres_services', $formation->autres_services) }}"
                        style="min-width: 300px;"
                    >
                </div>
            </div>

            <script>
            document.addEventListener('DOMContentLoaded', function () {
                const checkbox = document.getElementById('autres');
                const wrapper  = document.getElementById('autres_services_wrapper');

                if (!checkbox || !wrapper) return;

                function toggleAutres() {
                    if (checkbox.checked) {
                        wrapper.classList.remove('d-none');
                        wrapper.classList.add('d-flex', 'align-items-center');
                    } else {
                        wrapper.classList.add('d-none');
                        wrapper.classList.remove('d-flex', 'align-items-center');
                    }
                }
                checkbox.addEventListener('change', toggleAutres);
                toggleAutres();
            });
            </script>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="الاسم التجاري للمشروع"
                        maxlength="50" value="{{ old('nom_projet', $formation->nom_projet) }}">
                </div>

                <label class="col-sm-2 col-form-label" for="nature_projet_id">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled {{ old('nature_projet_id', $formation->nature_projet_id) ? '' : 'selected' }}>اختر...</option>
                        @foreach($nature_projet as $nature)
                            <option value="{{ $nature->id_nature_p }}"
                                    {{ old('nature_projet_id', $formation->nature_projet_id) == $nature->id_nature_p ? 'selected' : '' }}>
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مواطن الشغل</label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_emplois" name="nbr_emplois" min="1"
                        value="{{ old('nbr_emplois', $formation->nbr_emplois) }}">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>مدير المؤسسة</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" maxlength="50"
                        placeholder="الاسم و اللقب"
                        value="{{ old('nom_prenom_d', $formation->directeur->nom_prenom_d ?? '') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8"
                        value="{{ old('num_cin', $formation->directeur->num_cin ?? '') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance"
                        value="{{ old('date_delivrance', $formation->directeur->date_delivrance ?? '') }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار"
                        value="{{ old('lieu_delivrance', $formation->directeur->lieu_delivrance ?? '') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="niveau_etude" placeholder="المستوى التعليمي"
                        value="{{ old('niveau_etude', $formation->directeur->niveau_etude ?? '') }}">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها"
                        value="{{ old('dernier_diplome_obtenu', $formation->directeur->dernier_diplome_obtenu ?? '') }}">
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    @foreach($formation->investissements as $index => $inv)
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[{{ $index }}][secteur_invest_id]" id="secteur_invest_id_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}" 
                                        {{ $inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : '' }}>
                                        {{ $secteur->secteur_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[{{ $index }}][montant_inv]" 
                                class="form-control" min=1 value="{{ $inv->montant_inv }}">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[{{ $index }}][id_source_financement]" id="id_source_financement_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}" 
                                        {{ $inv->id_source_financement == $source->id_source ? 'selected' : '' }}>
                                        {{ $source->source_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[{{ $index }}][montant_fin]" 
                                class="form-control" min=1 value="{{ $inv->montant_fin }}">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" 
                    style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" maxlength="100" rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $formation->remarques) }}</textarea>
        </div>
       <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('admin.formation.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>



<script>
    document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
            textareaGroup.style.display = checkbox.checked ? "block" : "none";
            checkbox.addEventListener("change", function() {
                textareaGroup.style.display = this.checked ? "block" : "none";
            });
        }
        toggleTextarea("espace_spectacle", "caracteristique_group");
        toggleTextarea("espace_sportif", "caracteristique_sportif_group");
        toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
        toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");

    });
</script>

<script>
    let investIndex = 1; 
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                            <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="الإستثمارالمبلغ ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection