@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">القوائم الرئيسية</h2>
                    <a class="btn btn-success font-weight-medium" href="{{ route('types.create') }}">
                        <i class="la la-plus mr-1"></i> إضافة قائمة
                    </a>
                </div>

                @if(session('ok'))
                    <div class="alert alert-success">{{ session('ok') }}</div>
                @endif

                <div class="block-card-body">
                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th width="10%">#</th>
                                    <th width="30%">الاسم بالعربية</th>
                                    <th width="30%">الاسم بالفرنسية</th>
                                    <th width="30%">الاسم بالإنجليزية</th>
                                    <th width="20%">إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($types as $type)
                                    <tr>
                                        <td>{{ $type->id_type }}</td>
                                        <td>{{ $type->type_ar }}</td>
                                        <td>{{ $type->type_fr }}</td>
                                        <td>{{ $type->type_en }}</td>
                                        <td class="text-center" style="white-space: nowrap;">
                                            <div class="d-flex justify-content-center align-items-center gap-1">
                                             
                                                <button type="button"
                                                        class="btn btn-warning btn-sm"
                                                        onclick="return confirmAction('هل تريد حقًا تعديل هذه القائمة؟', '{{ route('types.edit', $type->id_type) }}', null)"
                                                        title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                <form action="{{ route('types.destroy', $type->id_type) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حقًا حذف هذه القائمة؟', null, this.closest('form'))"
                                                            class="btn btn-danger btn-sm"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="5" class="text-center">لا توجد قوائم.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
<div class="d-flex justify-content-between align-items-center mt-3">                      {{ $types->links('pagination::bootstrap-5') }}                    </div>
                   
                </div>
            </div>
        </div>
    </div>
</div>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if(url) {
                window.location.href = url;
            } else if(form) {
                form.submit(); 
            }
        }
    });
    return false;
}
</script>



@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
