@extends('backoffice.dashboard')
@section('content')

@if(Auth::check())
<div class="container">
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form method="POST" action="{{ route('guides.update', $guide->id_G) }}" class="needs-validation" novalidate>
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id_type" value="{{ $guide->id_type }}">
                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">تعديل الدليل : {{ $guide->titre_G }}</h2>
                                <div class="stroke-shape"></div>
                            </div>
                            <div class="block-card-body">
                                <div class="form-group">
                                    <label>العنوان بالعربية <span class="text-danger">*</span>
                                <small class="text-muted"> (<span id="count_titre_G">0</span>/100) </small>
                                </label>
                                    
                                    <input type="text" name="titre_G" id="titre_G" class="form-control"
                                           value="{{ old('titre_G', $guide->titre_G) }}" maxlength="100" required>
                                           <small id="error_titre_G" class="text-danger d-none">
                                        الحد الأقصى 100 حرف
                                    </small>
                                </div>
                                <div class="form-group">
                                    <label>العنوان بالفرنسية <span class="text-danger">*</span>
                                <small class="text-muted"> (<span id="count_titre_fr">0</span>/100) </small></label>
                                    <input type="text" name="titre_fr" id="titre_fr" class="form-control"
                                           value="{{ old('titre_fr', $guide->titre_fr) }}" maxlength="100" required>
                                           <small id="error_titre_fr" class="text-danger d-none">
                                        الحد الأقصى 100 حرف
                                    </small>
                                </div>
                                <div class="form-group">
                                    <label>العنوان بالإنجليزية <span class="text-danger">*</span>
                                <small class="text-muted"> (<span id="count_titre_en">0</span>/100) </small></label>
                                    <input type="text" name="titre_en" id="titre_en" class="form-control"
                                           value="{{ old('titre_en', $guide->titre_en) }}" maxlength="100" required>
                                           <small id="error_titre_en" class="text-danger d-none">
                                        الحد الأقصى 100 حرف
                                    </small>
                                </div>
                                <div class="form-group">
                                    <label>نوع الدليل <span class="text-danger">*</span></label>
                                    <select id="type" name="type" class="form-control" required>
                                        <option value="menu_principal" {{ old('type', $guide->type) == 'menu_principal' ? 'selected' : '' }}>قائمة رئيسية</option>
                                        <option value="sous_menu" {{ old('type', $guide->type) == 'sous_menu' ? 'selected' : '' }}>قائمة فرعية</option>
                                    </select>
                                </div>
                                <div id="menuPrincipalSection" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الترتيب <span class="text-danger">*</span></label>
                                                <input type="number" name="ordre_menu" class="form-control" max=99
                                                    value="{{ old('ordre', $guide->ordre) }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>نوع المحتوى <span class="text-danger">*</span></label>
                                                <select id="type_contenu_menu" name="type_contenu_menu" class="form-control" required>
                                                    <option value="none" {{ old('type_contenu', $guide->type_contenu) == 'none' ? 'selected' : '' }}>بدون محتوى</option>
                                                    <option value="lien" {{ old('type_contenu', $guide->type_contenu) == 'lien' ? 'selected' : '' }}>رابط خارجي</option>
                                                    <option value="builder" {{ old('type_contenu', $guide->type_contenu) == 'builder' ? 'selected' : '' }}>صفحة داخلية (Builder)</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="lienSection_menu" class="form-group mt-3" style="display: none;">
                                        <label>أدخل الرابط (رابط خارجي)</label>
                                       <input type="url"
                                                name="lien_menu"
                                                class="form-control @error('lien_menu') is-invalid @enderror"
                                                placeholder="https://exemple.com"
                                                value="{{ old('lien_menu', $guide->lien) }}"
                                                maxlength="2050"
                                                inputmode="url"
                                                >
                                        <div class="form-check mt-2">
                                            <input type="hidden" name="open_new_tab" value="0">
                                            <!--input type="checkbox" name="open_new_tab" id="open_new_tab_menu" class="form-check-input" value="1" {{ old('open_new_tab', $guide->open_new_tab ?? 0) ? 'checked' : '' }}-->
											<input type="checkbox" name="open_new_tab_menu" id="open_new_tab_menu" value="1" {{ $guide->open_new_tab ? 'checked' : '' }}>
                                            <label for="open_new_tab_menu" class="form-check-label">فتح الرابط في نافذة جديدة</label>
                                                    
                                        </div>
                                    </div>
                                    <div id="builderSection_menu" class="form-group mt-3" style="display: none;">
										<label>اختيار الصفحة الداخلية (Builder)</label>
										<select name="builder_id_menu" class="form-control">
											<option value="" disabled>اختر صفحة...</option>
											@foreach($builders as $b)
												<option value="{{ $b->id_builder }}"
													{{ old('builder_id_menu', $guide->builder_id) == $b->id_builder ? 'selected' : '' }}>
													{{ $b->titre_ar }}
												</option>
											@endforeach
										</select>
									</div>
                                </div>
                                <div id="sousMenuSection" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الترتيب <span class="text-danger">*</span></label>
                                                <input type="number" name="ordre_sous" class="form-control" max=99
                                                    value="{{ old('ordre', $guide->ordre) }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الدليل الأب (اختياري)</label>
                                                <select name="id_parent" class="form-control">
                                                    <option value="">لا يوجد (دليل رئيسي)</option>
                                                    @foreach($parentGuides as $parent)
                                                        <option value="{{ $parent['id_G'] }}" {{ old('id_parent', $guide->id_parent) == $parent['id_G'] ? 'selected' : '' }}>
                                                            {{ $parent['titre_G'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>نوع المحتوى <span class="text-danger">*</span></label>
                                                <select id="type_contenu_sous" name="type_contenu_sous" class="form-control">
                                                    <option value="none" {{ old('type_contenu', $guide->type_contenu) == 'none' ? 'selected' : '' }}>بدون محتوى</option>
                                                    <option value="lien" {{ old('type_contenu', $guide->type_contenu) == 'lien' ? 'selected' : '' }}>رابط خارجي</option>
                                                    <option value="builder" {{ old('type_contenu', $guide->type_contenu) == 'builder' ? 'selected' : '' }}>صفحة داخلية (Builder)</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6" id="lienSection_sous" style="display: none;">
                                            <div class="form-group">
                                                <label>أدخل الرابط (رابط خارجي)</label>
                                                <input type="url"
                                                name="lien_sous"
                                                class="form-control @error('lien_sous') is-invalid @enderror"
                                                placeholder="https://exemple.com"
                                                value="{{ old('lien_sous', $guide->lien) }}"
                                                maxlength="2050"
                                                inputmode="url"
                                                >
                                                <div class="form-check mt-2">
                                                    <input type="hidden" name="open_new_tab" value="0">
													<input type="checkbox" name="open_new_tab_sous" id="open_new_tab_sous" value="1" {{ $guide->open_new_tab ? 'checked' : '' }}>
                                                    <label for="open_new_tab_menu" class="form-check-label">فتح الرابط في نافذة جديدة</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="builderSection_sous" class="col-md-6" style="display:none;">
											<div class="form-group">
												<label>اختيار الصفحة الداخلية (Builder)</label>
												<select name="builder_id_sous" class="form-control">
													<option value="" disabled>اختر صفحة...</option>
													@foreach($builders as $b)
														<option value="{{ $b->id_builder }}"
															{{ old('builder_id_sous', $guide->builder_id) == $b->id_builder ? 'selected' : '' }}>
															{{ $b->titre_ar }}
														</option>
													@endforeach
												</select>
											</div>
										</div>
                                    </div>
                                </div>
                            </div>
                            <div class="block-card-footer mt-3 mb-3 text-center">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-save mr-1"></i> حفظ
                                </button>
                                <a href="{{ route('guides.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-times mr-1"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
document.addEventListener('DOMContentLoaded', () => {

    const fields = [
        { id: 'titre_G', max: 100 },
        { id: 'titre_fr', max: 100 },
        { id: 'titre_en', max: 100 },
    ];

    fields.forEach(f => {
        const input = document.getElementById(f.id);
        const counter = document.getElementById('count_' + f.id);
        const error = document.getElementById('error_' + f.id);

        if (!input) return;

        input.addEventListener('input', () => {
            if (input.value.length > f.max) {
                input.value = input.value.substring(0, f.max);
            }

            counter.textContent = input.value.length;

            if (input.value.length === f.max) {
                input.classList.add('is-invalid');
                error.classList.remove('d-none');
            } else {
                input.classList.remove('is-invalid');
                error.classList.add('d-none');
            }
        });
    });

    // Bloquer la soumission si dépassement
    document.querySelector('form').addEventListener('submit', e => {
        let valid = true;

        fields.forEach(f => {
            const input = document.getElementById(f.id);
            if (input.value.length > f.max) {
                valid = false;
                input.classList.add('is-invalid');
            }
        });

        if (!valid) {
            e.preventDefault();
            alert('الرجاء احترام الحد الأقصى 100 حرف');
        }
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {

    // Sélectionne tous les inputs URL que tu veux valider
    const urlInputs = document.querySelectorAll('input[name="lien_menu"], input[name="lien_sous"]');

    urlInputs.forEach(input => {
        input.addEventListener('input', () => {
            // Supprime les espaces au début/fin
            input.value = input.value.trim();

            // Validation URL simple
            try {
                if(input.value !== '') new URL(input.value);
                input.classList.remove('is-invalid');
            } catch (e) {
                if (input.value !== '') {
                    input.classList.add('is-invalid');
                }
            }
        });
    });

});
</script>

	<script>
(function () {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function (form) {
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectType = document.getElementById('type');
    const menuPrincipalSection = document.getElementById('menuPrincipalSection');
    const sousMenuSection = document.getElementById('sousMenuSection');
    const typeContenuMenu = document.getElementById('type_contenu_menu');
    const builderMenu = document.getElementById('builderSection_menu');
    const lienMenu = document.getElementById('lienSection_menu');
    const typeContenuSous = document.getElementById('type_contenu_sous');
    const builderSous = document.getElementById('builderSection_sous');
    const lienSous = document.getElementById('lienSection_sous');
    function toggleMainVsSub() {
        const type = selectType.value;
        menuPrincipalSection.style.display = (type === 'menu_principal') ? 'block' : 'none';
        sousMenuSection.style.display = (type === 'sous_menu') ? 'block' : 'none';
    }
    function toggleBuilderMenu() {
        if (typeContenuMenu) {
            builderMenu.style.display = (typeContenuMenu.value === 'builder') ? 'block' : 'none';
            lienMenu.style.display = (typeContenuMenu.value === 'lien') ? 'block' : 'none';
        }
    }
    function toggleBuilderSous() {
        if (typeContenuSous) {
            builderSous.style.display = (typeContenuSous.value === 'builder') ? 'block' : 'none';
            lienSous.style.display = (typeContenuSous.value === 'lien') ? 'block' : 'none';
        }
    }
    selectType.addEventListener('change', toggleMainVsSub);
    if (typeContenuMenu) typeContenuMenu.addEventListener('change', toggleBuilderMenu);
    if (typeContenuSous) typeContenuSous.addEventListener('change', toggleBuilderSous);
    toggleMainVsSub();
    toggleBuilderMenu();
    toggleBuilderSous();
});
</script>
@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif
@endsection