@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.doc_fin.update', $docList->id_doc_list) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')

        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h3 style="font-size:25px;">{{ $formulaire->type_ar }}</h3>
        <br>

        @php 
            $currentStatus = $docList->id_statut1 ?? '';
            $currentMotif = $docList->commentaire_motif1 ?? '';
        @endphp

        <div class="card shadow-lg border-0 mb-4 rounded-4">
            <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
                @if($currentStatus == 1)
                    <span class="badge bg-success fs-6">مقبول</span>
                @elseif($currentStatus == 3)
                    <span class="badge bg-danger fs-6">مرفوض</span>
                @else
                    <span class="badge bg-warning text-dark fs-6">في الانتظار</span>
                @endif
            </div>

            @if($currentStatus == 3 && $currentMotif)
                <div class="card-body">
                    <p class="text-danger fw-bold">سبب الرفض:</p>
                    <p>{{ $currentMotif }}</p>
                </div>
            @endif
        </div>

        <div class="form-section">
    <div class="form-group row">
        <table id="phase-table" class="custom-table table table-bordered text-center">
            <thead>
                <tr>
                    <th>#</th>
                    <th> الوثائق حسب الامر عدد 5183 </th>
                    <th> الوثائق المرفوعة </th>
                    <th> الملاحظات </th>
                </tr>
            </thead>
            <tbody>
@foreach($typedocum as $index => $doc)
    @php
        $existing = $documents->firstWhere('id_doc', $doc->id_type_doc);
    @endphp
    <tr>
        <td>{{ $index + 1 }}</td>

        <td>{{ $doc->type_ar }}</td>

        <td>
            @if($doc->id_type_doc == 17)
                <a href="{{ route('admin.form.show2', $projet->id_projet) }}" target="_blank">
                    📄 اضغط هنا لعرض الملف
                </a>

            @elseif($doc->id_type_doc == 15)
                <a href="{{ route('admin.demande.show2', $projet->demande->id_demande_fin ?? '-') }}" target="_blank">
                    📄 اضغط هنا لعرض الطلب
                </a>

            @else
                @if($existing && $existing->file)
                    <a href="{{ asset('storage/'.$existing->file) }}" target="_blank">
                        📂 عرض الملف
                    </a>
                @else
                    <span>-</span>
                @endif
            @endif
        </td>

        <td>
            <input type="text" class="form-control" 
                   value="{{ $existing->remarques ?? '-' }}" readonly>
        </td>
    </tr>
@endforeach
</tbody>

        </table>
    </div>
</div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto no-print">
                <button type="button" class="btn btn-success font-weight-medium" style="width:120px;" onclick="window.print()">
                    <i class="bi bi-printer me-1"></i> طباعة
                </button>
            </div>
            <div class="col-sm-4 mx-auto no-print">
                <a href="{{ route('admin.doc_fin.index') }}" class="btn btn-primary" style="width:120px;">
                    <i class="bi bi-arrow-left me-1"></i> رجوع
                </a>
            </div>
        </div>


        
    </form>
</div>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

@else
    <script>window.location.href = "{{ route('login') }}";</>
@endif
@endsection
