@extends('backoffice.dashboard')

@section('content')

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">📂 وثائق التمويل العمومي (لجنة التمويل العمومي)</h2>

                    
                    <a class="btn btn-success font-weight-medium" href="{{ route('admin.doc_fin.create') }}">
                        <i class="la la-plus mr-1"></i> إضافة وثائق جديدة
                    </a>
                </div>

                <div class="block-card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>إسم المشروع</th>
                                    <th>الحالة</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($documents as $index => $doc)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $doc->projet?->nom_projet ?? '---' }}</td>
                                    <td>
                                        <span class="badge 
                                            {{ $doc->id_statut1 == 1 ? 'badge-success' : ($doc->id_statut1 == 3 ? 'badge-danger' : 'badge-secondary') }}">
                                            {{ $doc->statut1?->statut_ar ?? 'في الانتظار' }}
                                        </span>
                                    </td>

                                    <td class="btn-group">
                                        <a class="btn btn-info btn-sm mr-2" href="{{ route('admin.doc_fin.show', $doc->id_doc_list) }}">
                                            <i class="la la-eye mr-1"></i> عرض
                                        </a>

                                        @if($doc->id_statut1 == 2)
                                            <a class="btn btn-orange btn-sm mr-2" style="color:white;"											href="{{ route('admin.doc_fin.edit', $doc->id_doc_list) }}" >
                                                <i class="la la-edit mr-1"></i> تعديل
                                            </a>

                                            <form action="{{ route('admin.doc_fin.toggle_statut', $doc->id_doc_list) }}" 
                                                method="POST" 
                                                class="form-modifier-statut mr-2" 
                                                style="display:inline;">
                                                @csrf
                                                @method('PATCH')
                                                <button type="button" 
                                                    onclick="confirmStatusChange4(this.closest('form'), '{{ $doc->statut1?->statut_ar }}')" 
                                                    class="btn btn-sm btn-secondary">
                                                    <i class="la la-toggle-on mr-1"></i>
                                                    تغيير الحالة
                                                </button>
                                            </form>


                                            <form action="{{ route('admin.doc_fin.destroy', $doc->id_doc_list) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" 
                                                        onclick="return confirmAction('هل تريد حذف هذه الوثيقة؟', null, this.closest('form'))" 
                                                        class="btn btn-danger btn-sm mr-2">
                                                    <i class="la la-trash mr-1"></i> حذف
                                                </button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center">لا توجد وثائق حالياً</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                   <div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $documents->links('pagination::bootstrap-5') }}
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

@endsection
