@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.doc_fin2.update', $docList->id_doc_list) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')

        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
       <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>
        <br>

        @php 
            $currentStatus = old('id_statut', $docList->id_statut2 ?? '');
            $currentMotif = old('commentaire_motif2', $docList->commentaire_motif2 ?? '');
        @endphp

        <div class="card shadow-lg border-0 mb-4 rounded-4">
            <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
                @if($currentStatus == 1)
                    <span class="status-badge status-badge--success">مقبول</span>
                @elseif($currentStatus == 3)
                    <span class="status-badge status-badge--danger">مرفوض</span>
                @else
                    <span class="status-badge status-badge--pending">في الانتظار</span>
                @endif
            </div>
            <div class="card-body">
                <p class="text-muted mb-4 text-center fs-6">
                    إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
                </p>
                <div class="form-group row align-items-center mb-3">
                    <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>  
                    <div class="col-sm-4">
                        <select class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInput5()">
                            <option value="">اختر...</option>
                            <option value="1" {{ $currentStatus == 1 ? 'selected' : '' }}>قبول</option>
                            <option value="3" {{ $currentStatus == 3 ? 'selected' : '' }}>رفض</option>
                        </select>
                    </div>
                </div>
                <div class="mb-3 {{ $currentStatus == 3 ? '' : 'd-none' }}" id="motifDiv">
                    <label for="commentaire_motif2" class="form-label fw-bold text-danger">سبب الرفض</label>
                    <textarea name="commentaire_motif2" id="commentaire_motif2" class="form-control border-danger shadow-sm" rows="3" placeholder="الرجاء إدخال سبب الرفض">{{ $currentMotif }}</textarea>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <div class="form-group row">
                <table id="phase-table" class="custom-table table table-bordered text-center">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th> الوثائق حسب الامر عدد 5183 </th>
                            <th> الوثائق المرفوعة </th>
                            <th> الملاحظات </th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($typedocum as $index => $doc)
                        @php
                            $existing = $documents->firstWhere('id_doc', $doc->id_type_doc);
                        @endphp
                        <tr>
                            <td>{{ $index + 1 }}</td>

                            <td>
                                {{ $doc->type_ar }}
                                <input type="hidden" name="doc_fin[{{ $index }}][id_doc]" value="{{ $doc->id_type_doc }}">
                            </td>

                            <td>
                                @if($doc->id_type_doc == 17)
                                        <a href="{{ route('admin.form.show', $projet->id_projet) }}" target="_blank">
                                            📄 اضغط هنا لعرض الملف
                                        </a>

                                    @elseif($doc->id_type_doc == 15)
                                        <a href="{{ route('admin.demande.show', $projet->demande->id_demande_fin ?? '-') }}" target="_blank">
                                            📄 اضغط هنا لعرض الطلب
                                        </a>
                                @else
                                    @if($existing && $existing->file)
                                        <a href="{{ asset('storage/'.$existing->file) }}" 
                                        target="_blank" 
                                        class="btn btn-sm btn-info" 
                                        title="عرض الملف">
                                            📂 عرض الملف
                                        </a>
                                    @else
                                        <span class="text-muted">لا يوجد ملف</span>
                                    @endif
                                @endif
                            </td>

                            

                            <td>
                                <input type="text" name="doc_fin[{{ $index }}][remarques]" 
                                    class="form-control" maxlength="100"
                                    value="{{ $existing->remarques ?? '' }}">
                            </td>
                        </tr>
                    @endforeach
                    </tbody>

                </table>
            </div>
        </div>

        <div class="form-section">
            <div class="form-group row align-items-center">
                <label for="decision_finale" class="col-sm-2 col-form-label"> القرار النهائي </label>
                <div class="col-sm-10 d-flex align-items-center gap-2">
                    <input type="file" class="form-control" id="decision_finale" name="decision_finale" placeholder="">

                    @if(!empty($docList->decision_finale))
                        <small class="text-muted">
                            الملف الحالي: 
                            <a href="{{ asset('storage/' . $docList->decision_finale) }}" target="_blank">عرض/تحميل</a>
                        </small>
                    @endif
                </div>
            </div>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto">
                <button type="submit" class="btn btn-success" style="width:100px;margin-right:250px;">
                    حفظ
                </button>
            </div>
            <div class="col-sm-4 mx-auto">
                <a href="{{ route('admin.doc_fin2.index') }}" class="btn btn-primary" style="width:100px;margin-left:250px;">
                    رجوع
                </a>
            </div>
        </div>
    </form>
</div>

@else
    <script>window.location.href = "{{ route('login') }}";</>
@endif
@endsection
