@extends('backoffice.dashboard')

@section('title', 'قائمة الجامعات الرياضية')

@section('content')

@if(Auth::check())
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title m-0">قائمة الجامعات الرياضية</h2>
                    <a class="btn btn-success btn-sm px-3" href="{{ route('federation.create') }}">
                        <i class="la la-plus me-1"></i> إضافة جامعة
                    </a>
                </div>

                {{-- SEARCH --}}
                <div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="{{ route('federation.index') }}">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input type="text" class="form-control" name="search"
                                    placeholder="بحث باسم الجامعة أو الرئيس"
                                    value="{{ request('search') }}">
                            </div>

                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium"
                                    style="width: 105px;">
                                    بحث
                                </button>
                                <a href="{{ route('federation.index') }}"
                                    class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                    style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="block-card-body">

                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    @endif

                    <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                        <table class="table align-items-center table-flush mb-0 table-hover"
                            style="direction: rtl; text-align: right;">

                            <thead class="thead-light">
                                <tr>
                                    <th>الجامعة / الاتحاد</th>
                                    <th>العنوان</th>
                                    <th>الرئيس</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>الهاتف</th>
                                    
                                    <th>الفاكس</th>
                                    <th>رابط الموقع</th>
                                    <th>الشعار</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse ($federations as $f)
                                <tr>
                                    <td>{{ $f->nom_ar }}</td>
                                    <td>{{ $f->adresse_ar ?? '—' }}</td>
                                    <td>{{ $f->president_ar ?? '—' }}</td>
                                    <td>{{ $f->date_creation ? \Carbon\Carbon::parse($f->date_creation)->format('Y-m-d') : '—' }}</td>
                                    <td>
                                        @if($f->telephone2)
                                            {{ $f->telephone }} / {{ $f->telephone2 }}
                                        @else
                                            {{ $f->telephone ?? '—' }}
                                        @endif
                                    </td>

                                    <td>{{ $f->fax ?? '—' }}</td>

                                    <td>
                                        @if($f->site_web)
                                        <a href="{{ $f->site_web }}" target="_blank">
                                            {{ $f->site_web }}
                                        </a>
                                        @else
                                        —
                                        @endif
                                    </td>

                                    <td>
                                        @if($f->logoSrc)
                                            <img src="{{ $f->logoSrc }}"
                                                alt="شعار الجامعة"
                                                class="rounded shadow-sm border"
                                                style="width: 70px; height: 70px; object-fit: cover;">
                                        @else
                                            <span class="text-muted">—</span>
                                        @endif
                                    </td>

                                    <td>
                                        <div class="d-flex justify-content-center gap-2">
                                            <button type="button"
                                                class="btn-icon btn-icon--warning"
                                                onclick="window.location='{{ route('federation.edit', $f) }}'"
                                                title="تعديل">
                                                <i class="la la-edit"></i>
                                            </button>

                                            <form action="{{ route('federation.destroy', $f->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button"
                                                    onclick="return confirmAction('هل تريد حذف هذه الجامعة؟', null, this.closest('form'))"
                                                    class="btn-icon btn-icon--danger" title="حذف">
                                                    <i class="la la-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="py-4 text-muted text-center">
                                        لا توجد جامعات حالياً.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mt-3">
                        {{ $federations->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- ======= SweetAlert Confirm ======= --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

@else
<script>window.location.href = "{{ route('admin') }}";</script>
@endif

@endsection
