@extends('backoffice.dashboard')

@section('title', 'تعديل وصف الولاية')

@section('content')

@if(Auth::check())
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; }
</style>

<div class="container-fluid">
  <div class="block-card mb-4">

    <div class="block-card-header">
      <h2 class="widget-title">تعديل وصف الولاية</h2>
      <div class="stroke-shape"></div>
    </div>

    <div class="block-card-body">
      <form method="POST"
            action="{{ route('desc_gouvr.update', $desc_gouvr) }}"
            enctype="multipart/form-data"
            novalidate>
        @csrf
        @method('PUT')

        <!-- اختيار الولاية والصورة الرئيسية -->
        <div class="form-group mb-3 row">
            <div class="col-md-6">
                <label>الولاية <span class="text-danger">*</span></label>
                <select name="id_gouv" class="form-control @error('id_gouv') is-invalid @enderror" required>
                    <option value="">اختر الولاية</option>
                    @foreach($gouvernorats as $gouv)
                        <option value="{{ $gouv->id_gouver }}" {{ $desc_gouvr->id_gouv == $gouv->id_gouver ? 'selected' : '' }}>
                            {{ $gouv->nom_ar }}
                        </option>
                    @endforeach
                </select>
                @error('id_gouv') <span class="field-error d-block">{{ $message }}</span> @enderror
            </div>

            
		<div class="col-md-6">
    <label>الصورة الرئيسية للولاية</label>
    <input type="file" name="image_gouv" class="form-control" accept="image/*">
    @if(!empty($desc_gouvr->image_gouvSrc))
        <img src="{{ $desc_gouvr->image_gouvSrc }}"
             alt="الصورة الحالية"
             class="mt-2"
             style="width: 120px; height: 80px; object-fit: cover; border-radius:6px;">
    @else
        {{-- no image --}}
    @endif
    @error('image_gouv') <span class="field-error d-block">{{ $message }}</span> @enderror
</div>

        </div>

        <!-- الوصف الأول -->
        <div class="form-group mb-3">
            <label>الوصف الأول (بالعربية)</label>
            <textarea name="desc1" id="desc1" class="form-control" rows="6">{{ old('desc1', $desc_gouvr->desc1) }}</textarea>
            @error('desc1') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="form-group mb-3">
            <label>الوصف الأول (بالفرنسية)</label>
            <textarea name="desc1_fr" id="desc1_fr" class="form-control" rows="6">{{ old('desc1_fr', $desc_gouvr->desc1_fr) }}</textarea>
            @error('desc1_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="form-group mb-3">
            <label>الوصف الأول (بالإنجليزية)</label>
            <textarea name="desc1_en" id="desc1_en" class="form-control" rows="6">{{ old('desc1_en', $desc_gouvr->desc1_en) }}</textarea>
            @error('desc1_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
       <!-- Image 1 -->
<div class="form-group mb-3">
    <label>الصورة 1</label>
    <input type="file" name="image1" class="form-control" accept="image/*">
    @if(!empty($desc_gouvr->image1Src))
        <img src="{{ $desc_gouvr->image1Src }}"
             alt="الصورة الحالية 1"
             class="mt-2"
             style="width: 80px; height: 52px; object-fit: cover; border-radius:6px;">
    @endif
    @error('image1') <span class="field-error d-block">{{ $message }}</span> @enderror
</div>


        <!-- الوصف الثاني -->
        <div class="form-group mb-3">
            <label>الوصف الثاني (بالعربية)</label>
            <textarea name="desc2" id="desc2" class="form-control" rows="6">{{ old('desc2', $desc_gouvr->desc2) }}</textarea>
            @error('desc2') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="form-group mb-3">
            <label>الوصف الثاني (بالفرنسية)</label>
            <textarea name="desc2_fr" id="desc2_fr" class="form-control" rows="6">{{ old('desc2_fr', $desc_gouvr->desc2_fr) }}</textarea>
            @error('desc2_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="form-group mb-3">
            <label>الوصف الثاني (بالإنجليزية)</label>
            <textarea name="desc2_en" id="desc2_en" class="form-control" rows="6">{{ old('desc2_en', $desc_gouvr->desc2_en) }}</textarea>
            @error('desc2_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
       <!-- Image 2 -->
<div class="form-group mb-3">
    <label>الصورة 2</label>
    <input type="file" name="image2" class="form-control" accept="image/*">
    @if(!empty($desc_gouvr->image2Src))
        <img src="{{ $desc_gouvr->image2Src }}"
             alt="الصورة الحالية 2"
             class="mt-2"
             style="width: 80px; height: 52px; object-fit: cover; border-radius:6px;">
    @endif
    @error('image2') <span class="field-error d-block">{{ $message }}</span> @enderror
</div>


        <!-- الوصف الثالث -->
        <div class="form-group mb-3">
            <label>الوصف الثالث (بالعربية)</label>
            <textarea name="desc3" id="desc3" class="form-control" rows="6">{{ old('desc3', $desc_gouvr->desc3) }}</textarea>
            @error('desc3') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="form-group mb-3">
            <label>الوصف الثالث (بالفرنسية)</label>
            <textarea name="desc3_fr" id="desc3_fr" class="form-control" rows="6">{{ old('desc3_fr', $desc_gouvr->desc3_fr) }}</textarea>
            @error('desc3_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="form-group mb-3">
            <label>الوصف الثالث (بالإنجليزية)</label>
            <textarea name="desc3_en" id="desc3_en" class="form-control" rows="6">{{ old('desc3_en', $desc_gouvr->desc3_en) }}</textarea>
            @error('desc3_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
     <!-- Image 3 -->
<div class="form-group mb-3">
    <label>الصورة 3</label>
    <input type="file" name="image3" class="form-control" accept="image/*">
    @if(!empty($desc_gouvr->image3Src))
        <img src="{{ $desc_gouvr->image3Src }}"
             alt="الصورة الحالية 3"
             class="mt-2"
             style="width: 80px; height: 52px; object-fit: cover; border-radius:6px;">
    @endif
    @error('image3') <span class="field-error d-block">{{ $message }}</span> @enderror
</div>


        <!-- الأزرار -->
        <div class="block-card-footer mt-3 mb-3 text-center">
          <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
            <i class="la la-save mr-1"></i> حفظ التعديلات
          </button>
          <a href="{{ route('desc_gouvr.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
            <i class="la la-times mr-1"></i> إلغاء
          </a>
        </div>

      </form>
    </div>
  </div>
</div>

<!-- TinyMCE لكل المناطق -->
<script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  ['desc1','desc1_fr','desc1_en','desc2','desc2_fr','desc2_en','desc3','desc3_fr','desc3_en'].forEach(id => {
    tinymce.init({
      selector: '#'+id,
      directionality: 'rtl',
      height: 250,
      plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
      toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
      forced_root_block: false,
    });
  });
</script>

@else
<script> window.location.href = "{{ route('admin') }}"; </script>
@endif

@endsection
