@extends('backoffice.dashboard')

@section('content')
<div class="container py-4" dir="rtl" lang="ar">
  <div class="row justify-content-center">
    <div class="col-xl-8 col-lg-10">
      <div class="card shadow-sm border-0 rounded-3 overflow-hidden">
        <!-- Header -->
        <div class="card-header bg-white text-center py-4">
          <h4 class="mb-1">{{ $fieldDefinition->exists ? 'تعديل الحقل' : 'إضافة حقل جديد للنموذج' }}</h4>
          <p class="text-muted small mb-0">الحقول التي تحمل علامة <span class="text-danger">*</span> إلزامية. يمكنك معاينة مفتاح الحقل الذي سيُنشأ تلقائياً.</p>
        </div>

        <div class="card-body p-4">
          @if($errors->any())
            <div class="alert alert-danger text-end">
              <ul class="mb-0">
                @foreach($errors->all() as $err)
                  <li>{{ $err }}</li>
                @endforeach
              </ul>
            </div>
          @endif

          <form action="{{ $fieldDefinition->exists ? route('backoffice.field_definitions.update', $fieldDefinition) : route('field_definitions.store') }}" method="POST" novalidate>
            @csrf
            @if($fieldDefinition->exists) @method('PUT') @endif

            {{-- LABEL + key preview --}}
        <div class="mb-3">
  <label class="form-label d-block text-end fw-semibold">التسمية (label) <span class="text-danger">*</span></label>
  <input id="fld_label" name="label" value="{{ old('label', $fieldDefinition->label) }}" class="form-control form-control-lg shadow-sm" required placeholder="التسمية الظاهرة للمستخدم">

  <div class="d-flex justify-content-between align-items-center mt-2">
    <small class="text-muted">مفتاح الحقل المتوقع: </small>
    <small id="key_preview" class="text-muted">{{ old('label', $fieldDefinition->label) ? \Illuminate\Support\Str::slug(mb_strtolower(old('label', $fieldDefinition->label)), '_') : 'field' }}</small>
  </div>
</div>

            {{-- INPUT TYPE + SORT ORDER --}}
            <div class="row g-3 mb-3">
              <div class="col-md-7">
                <label class="form-label d-block text-end fw-semibold">نوع الحقل (input_type) <span class="text-danger">*</span></label>
                 <select id="input_type" name="input_type" class="form-control form-control-lg shadow-sm" aria-label="نوع الحقل">
               
                @php
                    $types = ['text'=>'نص','textarea'=>'منطقة نص','date'=>'تاريخ','number'=>'رقم','file'=>'ملف','email'=>'بريد إلكتروني','select'=>'قائمة (اختيار)','multiselect'=>'قائمة متعددة','radio'=>'اختيارات راديو','checkbox'=>'مربعات اختيار'];
                   $curType = old('input_type', $fieldDefinition->input_type);
                  @endphp
                  @foreach($types as $k => $label)
                    <option value="{{ $k }}" {{ $curType === $k ? 'selected' : '' }}>{{ $label }}</option>
                  @endforeach
                </select>
              </div>

              <div class="col-md-5">
                <label class="form-label d-block text-end fw-semibold">ترتيب العرض</label>
                <input type="number" name="sort_order" class="form-control form-control-lg shadow-sm" value="{{ old('sort_order', $fieldDefinition->sort_order ?? 100) }}" min="1">
                <div class="form-text text-muted text-end small">قيمة أصغر تعني عرضاً أعلى في الاستمارة</div>
              </div>
            </div>

            {{-- OPTIONS (visible only for select/radio/checkbox/multiselect) --}}
           {{-- OPTIONS (visible only for select/radio/checkbox/multiselect) --}}
<div id="options_wrapper" class="mb-3"
     style="{{ in_array($curType, ['select','multiselect','radio','checkbox']) ? '' : 'display:none;' }}">
  <label class="form-label d-block text-end fw-semibold">خيارات (select / radio / checkbox) — كل خيار في سطر جديد أو مفصول بفاصلة</label>
  <textarea name="options_json" class="form-control shadow-sm" rows="4" placeholder="مثال: خيار1&#10;خيار2">{{ old('options_json', is_array($fieldDefinition->options()) ? implode("\n", $fieldDefinition->options()) : $fieldDefinition->options_json) }}</textarea>
  <div class="form-text text-muted text-end small">يمكنك إدخال JSON array أو كل خيار في سطر جديد أو فاصلة تفصل بين الخيارات.</div>
</div>


            {{-- VISIBLE / REQUIRED toggles --}}
            <div class="row g-2 align-items-center mb-4">
              <div class="col-auto">
                <div class="form-check form-switch d-flex align-items-center">
                  <input class="form-check-input" id="is_visible" name="is_visible" type="checkbox" value="1" {{ old('is_visible', $fieldDefinition->is_visible) ? 'checked' : '' }}>
                  <label class="form-check-label ms-2" for="is_visible">مرئي في الاستمارة</label>
                </div>
              </div>

              <div class="col-auto">
                <div class="form-check form-switch d-flex align-items-center">
                  <input class="form-check-input" id="is_required" name="is_required" type="checkbox" value="1" {{ old('is_required', $fieldDefinition->is_required) ? 'checked' : '' }}>
                  <label class="form-check-label ms-2" for="is_required">إلزامي</label>
                </div>
              </div>

              <div class="col text-muted small text-end">
                {{-- placeholder for alignment --}}
              </div>
            </div>

            {{-- Actions --}}
            <div class="d-flex justify-content-between">
                        <button type="submit" class="btn btn-primary shadow-sm">
                <i class="bi bi-check-lg me-2"></i>{{ $fieldDefinition->exists ? 'حفظ التغييرات' : 'حفظ الحقل' }}
              </button>

              <a href="{{ route('backoffice.field_definitions.index') }}" class="btn btn-secondary shadow-sm">
               العودة
              </a>
            </div>
          </form>
        </div>

        <div class="card-footer bg-white text-center small text-muted py-3">
          يتم تخزين المعلومات بشكل آمن. لأي استفسار تواصل مع المسؤول.
        </div>
      </div>
    </div>
  </div>
</div>

@push('styles')
<style>
  /* visual polish */
  .card { border-radius: .8rem; }
  .form-control, .form-select { border-radius: .5rem; }
  .form-control:focus, .form-select:focus { box-shadow: 0 6px 18px rgba(13,110,253,0.08); outline: none; }
  .card-header { border-bottom: 1px solid rgba(0,0,0,0.04); }
  .fw-semibold { font-weight: 600 !important; }
  /* make small icons & spacing consistent (Bootstrap icons used if available) */
  /* .btn i { vertical-align: -0.125em; } */
  /* ensure long option content doesn't break layout */
  textarea.form-control { resize: vertical; min-height: 96px; }
</style>
@endpush

@push('scripts')
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
  try {
    const labelInput = document.getElementById('fld_label');
    const keyPreview = document.getElementById('key_preview');
    const inputType = document.getElementById('input_type');
    const optionsWrapper = document.getElementById('options_wrapper');

    function slugKey(value) {
      if (!value) return 'field';
      let s = value.trim().toLowerCase();
      s = s.normalize('NFKD').replace(/[^\w\u0600-\u06FF]+/g, '_');
      s = s.replace(/^_+|_+$/g, '').replace(/__+/g, '_');
      return s || 'field';
    }

    if (labelInput && keyPreview) {
      labelInput.addEventListener('input', function () {
        keyPreview.textContent = slugKey(this.value);
      });
    }

    function toggleOptionsVisibility() {
      if (!inputType || !optionsWrapper) return;
      const t = inputType.value;
      const needsOptions = ['select','multiselect','radio','checkbox'].includes(t);
      optionsWrapper.style.display = needsOptions ? 'block' : 'none';
      optionsWrapper.setAttribute('aria-hidden', !needsOptions);
    }

    if (inputType) {
      inputType.addEventListener('change', toggleOptionsVisibility);
      // initial
      toggleOptionsVisibility();
    }
  } catch (err) {
    // keep form usable even if JS fails
    console.error('Field form script error:', err);
  }
});
</script>
@endpush

{{-- Inline fallback in case your layout forgets to render @stack('scripts') --}}
<script>
(function(){
  // run the same small toggle if DOM already loaded and @stack('scripts') wasn't present
  if (!document.getElementById('input_type')) return;
  try {
    const inputType = document.getElementById('input_type');
    const optionsWrapper = document.getElementById('options_wrapper');
    function toggleOptionsVisibility() {
      if (!inputType || !optionsWrapper) return;
      const t = inputType.value;
      const needsOptions = ['select','multiselect','radio','checkbox'].includes(t);
      optionsWrapper.style.display = needsOptions ? 'block' : 'none';
      optionsWrapper.setAttribute('aria-hidden', !needsOptions);
    }
    inputType.addEventListener('change', toggleOptionsVisibility);
    toggleOptionsVisibility();
  } catch(e) { console.warn(e); }
})();
</script>

@endpush
@endsection
