@extends('backoffice.dashboard')

@section('content')


@if(Auth::check())
	
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
   <div class="row">
     <div class="col-lg-12">
           <div class="block-card dashboard-card mb-4 px-0">

        {{-- header (title + create) --}}
         <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
        
            <h2 class="widget-title">المناظرات</h2>
         

    <a class="btn btn-success btn-sm" href="{{ route('concours.create') }}">
              <i class="la la-plus me-1"></i> إنشاء مناظرة
            </a>
        </div>
{{-- Zone de recherche --}}
<div class="block-card-header px-4 border-bottom-0 pb-3">
    <form method="GET" action="{{ route('concours.index') }}">
        <div class="form-row align-items-center" style="direction: rtl;">
            <div class="col-auto" style="width: 250px;">
                <input 
                    type="text" 
                    class="form-control" 
                    name="q" 
                    placeholder="بحث بالعربية أو الفرنسية أو الإنجليزية أو الحالة" 
                    value="{{ request('q') }}"
                >
            </div>

            <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                    بحث
                </button>
                <a href="{{ route('concours.index') }}"
                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                    <i class="fa-solid fa-rotate-right"></i>
                </a>
            </div>
        </div>
    </form>
</div>



        {{-- body --}}
        <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success text-end">{{ session('success') }}</div>
          @endif
          @if(session('error'))
            <div class="alert alert-danger text-end">{{ session('error') }}</div>
          @endif

          <div class="my-table table-responsive">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
              <thead class="thead-light">
                <tr>
                  <th width="30%">العنوان</th>
                  <th width="18%">الفترة</th>
                  <th width="10%">الحالة</th>
                 <th width="12%">المنشئ</th>
                  <th width="10%">المترشحون</th>
                   <th width="10%">عرض</th>
                  <th width="20%" class="text-start">إجراءات</th>
                </tr>
              </thead>
              <tbody>
                @forelse($concours as $c)
                <tr>
                  <td class="fw-semibold">
                    <div>{{ $c->titre_ar }}</div>
                    @if(!empty($c->description))
                      <small class="text-muted d-block mt-1">{{ Str::limit($c->description, 80) }}</small>
                    @endif
                  </td>

                  <td>
                    <div class="small text-muted">
                      {{ optional($c->date_debut)->format('Y-m-d') ?? '—' }}
                      —
                      {{ optional($c->date_fin)->format('Y-m-d') ?? '—' }}
                    </div>
                  </td>

                  <td>
                    @php
                      $etat = $c->etat ?? 'draft';
                      $etatLabel = $c->etat_label ?? ucfirst($etat);
                      $badgeClass = $etat === 'published' ? 'status-badge--success' : ($etat === 'closed' ? 'status-badge--danger' : 'status-badge--danger');
                    @endphp
                    <span class="status-badge {{ $badgeClass }}">{{ $etatLabel }}</span>
                  </td>

                 <td>
  <div class="fw-medium">
    {{ optional($c->user)->nom_prenom ?? '—' }}
  </div>
  {{-- <small class="text-muted">ID: {{ $c->user->id ?? '—' }}</small> --}}
</td>


                  <td>
                    <small class="text-muted">{{ $c->candidates_count ?? $c->candidates()->count() }} مترشح</small>
                  </td>
   <td>
                    <a href="{{ route('concours_ext.index', $c) }}" class="btn btn-sm btn-outline-primary">المترشحين</a>
                 </td>
                  <td class="actions-cell">
                    <div class="actions-cell d-inline-flex gap-2 justify-content-center align-items-center" role="group" aria-label="actions">
      
                      <a href="{{ route('concours.edit', $c) }}"  class="btn-icon btn-icon--warning"
                                                    title="تعديل">
                                                        <i class="la la-edit"></i>
                      </a>

                      <form action="{{ route('concours.destroy', $c) }}" method="POST" class="d-inline ms-1" onsubmit="return confirmAction('هل تريد حذف هذه المسابقة؟ سيتم إزالة الروابط مع المرشحين والحقول.', null, this);">
                        @csrf @method('DELETE')
                        <button type="button" class="btn-icon btn-icon--danger" title="حذف" onclick="return confirmAction('هل تريد حذف هذه المناظرة ?', null, this.closest('form'));">
                           
                                                            <i class="la la-trash"></i>
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
                @empty
                <tr>
                  <td colspan="6" class="text-center py-4">لا توجد مسابقات بعد.</td>
                </tr>
                @endforelse
              </tbody>
            </table>
          </div>

          <div class="mt-3 d-flex justify-content-between align-items-center">
            <div class="text-muted small">إجمالي: {{ $concours->total() }}</div>
            <div>
              {{ $concours->appends(request()->query())->links('pagination::bootstrap-5') }}
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

{{-- SweetAlert2 for nicer confirmations --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>
<style>
.table-sliders th, 
.table-sliders td {
    vertical-align: middle;
    text-align: center;
}

.table-sliders th:nth-child(2),
.table-sliders td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
  display: inline-block;
  padding: 6px 12px;
  border-radius: 12px;
  font-size: 14px;
  font-weight: 600;
  color: #fff;              /* white text */
  min-width: 60px;
  text-align: center;
  box-shadow: 0 2px 4px rgba(0,0,0,0.08);
}
.status-badge.status-published {
  background-color: #89e09dff;   /* green */
}
.status-badge--success {
    background-color: #e8f9ee; 
    color: #88e9b0ff;           
}

.status-badge.status-closed {
  background-color: #fca298ff;   /* red */
}

.status-badge.status-draft {
  background-color: #6c757d;   /* gray */
}
.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}
</style>
@else
    <script>window.location.href = "{{ route('login') }}";</script>
@endif

@endsection
