@extends('backoffice.authentification.layouts_auth.app_auth')
@section('content')

<div class="min-vh-100 d-flex align-items-center py-5"  style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
    <div class="container">
        <div class="row g-0 bg-white shadow-lg rounded-4 overflow-hidden" style="max-width: 1200px; margin: 0 auto;">
            <div class="col-lg-6 d-none d-lg-block position-relative">
              <div class="h-100" style="background: linear-gradient(rgb(109 130 222 / 15%), rgb(109 130 222 / 15%)), url('{{ asset('assets/img/hero/images.jpg') }}'); background-size: cover; background-position: center; min-height: 600px;">
                    <div class="position-absolute bottom-0 start-0 p-5 text-white">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="p-4 p-md-5">
                    <div class="text-center mb-4">
                        <h2 class="h3 mb-3">تسجيل الدخول</h2>
                        <p class="text-muted">الرجاء إدخال بريدك الإلكتروني وكلمة المرور</p>
                    </div>
                    @if(session('success'))
                        <div class="alert alert-success rounded-3 border-0 shadow-sm">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if($errors->any())
                        <div class="alert alert-danger rounded-3 border-0 shadow-sm">
                            {{ $errors->first() }}
                        </div>
                    @endif
                    <form action="{{ route('admin.login.post') }}" method="POST" >
                        @csrf
                        <input type="hidden" name="redirectTo" value="{{ request('redirectTo') }}">
                        <div class="mb-4">
                            <label class="form-label fw-bold">البريد الإلكتروني</label>
                            <input type="email" name="email" required class="form-control form-control-lg rounded-3 shadow-sm" 
                               style="direction: rtl; padding: 0.6rem 0.75rem;" 
								   placeholder="أدخل البريد الإلكتروني" value="{{ old('email') }}" >
                        </div>
                        <div class="mb-4">
                            <label class="form-label fw-bold">كلمة المرور</label>
                            <div class="position-relative">
                                <input type="password" required id="mdp" name="mdp" class="form-control form-control-lg rounded-3 shadow-sm"
                                  padding-right: 45px;" placeholder="أدخل كلمة المرور">
                                <span onclick="togglePassword('mdp', this)" 
                                    class="position-absolute top-50 end-0 translate-middle-y pe-3" 
                                    style="cursor: pointer;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-eye-slash" viewBox="0 0 16 16">
                                        <path d="M13.359 11.238C15.06 9.72 16 8 16 8s-3-5.5-8-5.5a7.028 7.028 0 0 0-2.79.588l.77.771A5.944 5.944 0 0 1 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.134 13.134 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755-.165.165-.337.328-.517.486l.708.709z"/>

                                        <path d="M11.297 9.176a3.5 3.5 0 0 0-4.474-4.474l.823.823a2.5 2.5 0 0 1 2.829 2.829l.822.822zm-2.943 1.299.822.822a3.5 3.5 0 0 1-4.474-4.474l.823.823a2.5 2.5 0 0 0 2.829 2.829z"/>
                                        <path d="M3.35 5.47c-.18.16-.353.322-.518.487A13.134 13.134 0 0 0 1.172 8l.195.288c.335.48.83 1.12 1.465 1.755C4.121 11.332 5.881 12.5 8 12.5c.716 0 1.39-.133 2.02-.36l.77.772A7.029 7.029 0 0 1 8 13.5C3 13.5 0 8 0 8s.939-1.721 2.641-3.238l.708.709zm10.296 8.884-12-12 .708-.708 12 12-.708.708z"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-4">
							   <div class="form-check d-flex align-items-center">
                                <input class="form-check-input" type="checkbox" name="remember" id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    تذكرني
                                </label>
                            </div>
                            <a href="{{ route('admin.password.request')}}" class="text-decoration-none">نسيت كلمة المرور؟</a>
                        </div>
                      <div class="d-flex justify-content-center mb-4">
                            <button class="btn btn-lg it-btn-orange rounded-3" type="submit" >
                                <span class="d-flex align-items-center justify-content-center">
                                    تسجيل الدخول
                                    <svg width="16" height="16" viewBox="0 0 12 13" fill="none" class="ms-2"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                            fill="white" />
                                    </svg>
                                </span>
                            </button>
                        </div>
                       
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function togglePassword(id, el) {

        const input = document.getElementById(id);

        const svg = el.querySelector('svg');

        

        if (input.type === "password") {

            input.type = "text";

            // Icône œil ouvert

            svg.innerHTML = '<path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/><path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>';

            svg.classList.remove('bi-eye-slash');

            svg.classList.add('bi-eye');

        } else {

            input.type = "password";

            // Icône œil barré

            svg.innerHTML = '<path d="M13.359 11.238C15.06 9.72 16 8 16 8s-3-5.5-8-5.5a7.028 7.028 0 0 0-2.79.588l.77.771A5.944 5.944 0 0 1 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.134 13.134 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755-.165.165-.337.328-.517.486l.708.709z"/><path d="M11.297 9.176a3.5 3.5 0 0 0-4.474-4.474l.823.823a2.5 2.5 0 0 1 2.829 2.829l.822.822zm-2.943 1.299.822.822a3.5 3.5 0 0 1-4.474-4.474l.823.823a2.5 2.5 0 0 0 2.829 2.829z"/><path d="M3.35 5.47c-.18.16-.353.322-.518.487A13.134 13.134 0 0 0 1.172 8l.195.288c.335.48.83 1.12 1.465 1.755C4.121 11.332 5.881 12.5 8 12.5c.716 0 1.39-.133 2.02-.36l.77.772A7.029 7.029 0 0 1 8 13.5C3 13.5 0 8 0 8s.939-1.721 2.641-3.238l.708.709zm10.296 8.884-12-12 .708-.708 12 12-.708.708z"/>';

            svg.classList.remove('bi-eye');

            svg.classList.add('bi-eye-slash');

        }

    }

</script>
@endsection
