@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">


@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="" method="POST" enctype="multipart/form-data" lang="ar">    
        <h3 class="mb-4 text-center"> عرض معلومات مركب أو مركز إقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label fw-bold">الإسم بالعربية</label>
            <div class="col-sm-4">
                <span class="d-inline-block">{{ $auberge->nom_ar ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الإسم بالفرنسية</label>
            <div class="col-sm-4">
                <span class="d-inline-block">{{ $auberge->nom_fr ?? '-' }}</span>
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label fw-bold">الإسم بالإنقليزية</label>
            <div class="col-sm-4">
                <span class="d-inline-block">{{ $auberge->nom_en ?? '-' }}</span>
            </div>

            <label class="col-sm-2 col-form-label fw-bold">الصبغة</label>
            <div class="col-sm-4">
                <span class="d-inline-block">{{ $auberge->epa ?? '-' }}</span>
            </div>
        </div>

        <div class="form-group mt-3">
            <label for="description_ar" class="col-sm-6 col-form-label"> تعريف المركز بالعربية<span class="text-danger">*</span> </label>
            <textarea name="description_ar" placeholder="" id="description_ar" class="form-control bg-white" disabled rows="4"  required> {{ old('description_ar', $auberge->description_ar ?? '') }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="description_fr" class="col-sm-6 col-form-label"> تعريف المركز بالفرنسية<span class="text-danger">*</span> </label>
            <textarea name="description_fr" placeholder="" id="description_fr" class="form-control bg-white" disabled  rows="4" required> {{ old('description_fr', $auberge->description_fr ?? '') }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="description_en" class="col-sm-6 col-form-label"> تعريف المركز بالإنقليزية<span class="text-danger">*</span> </label>
            <textarea name="description_en" placeholder="" id="description_en" class="form-control bg-white" disabled  rows="4" required> {{ old('description_en', $auberge->description_en ?? '') }}</textarea>
        </div>

        <!--div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label fw-bold">خط العرض (Latitude)</label>
			<div class="col-sm-4">
				<span class="d-inline-block">{{ $auberge->latitude ?? '-' }}</span>
			</div>

			<label class="col-sm-2 col-form-label fw-bold">خط الطول (Longitude)</label>
			<div class="col-sm-4">
				<span class="d-inline-block">{{ $auberge->longitude ?? '-' }}</span>
			</div>
		</div-->

		<div class="row mt-3">
    <div class="col-12">
        <h5 class="text-end">تحديد موقع المركز على الخريطة</h5>
    </div>
</div>

<div class="row mt-3 text-end">
    <div class="col-sm-2"><strong>رابط Google Map</strong></div>
    <div class="col-sm-10">
        @if($auberge->map_link)
            <a href="{{ $auberge->map_link }}" target="_blank" class="btn btn-outline-primary btn-sm">
                <i class="bi bi-geo-alt"></i>
                عرض على الخريطة
            </a>
        @else
            <span class="text-muted">لم يتم تحديد موقع</span>
        @endif
    </div>
</div>




		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label fw-bold">الوسط الذي توجد به المؤسسة</label>
			<div class="col-sm-4">
				<div class="col-sm-4 pt-2">
						<span>{{ optional($milieux->firstWhere('id_type', $auberge->id_milieu_auberge))->type_ar ?? '-' }}</span>
					</div>
			</div>

		</div>


		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> العنوان بالعربية <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<span class="d-inline-block">{{ $auberge->adresse_ar ?? '-' }}</span>
			</div>

			<label class="col-sm-2 col-form-label"> العنوان بالفرنسية <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<span class="d-inline-block">{{ $auberge->adresse_fr ?? '-' }}</span>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> العنوان بالإنجليزية <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<span class="d-inline-block">{{ $auberge->adresse_en ?? '-' }}</span>
			</div>

			<label class="col-sm-2 col-form-label"> الترقيم البريدي <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<span class="d-inline-block">{{ $auberge->code_postal ?? '-' }}</span>
			</div>
		</div>


<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label fw-bold">الولاية</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->gouvernorat->nom_ar ?? '-' }}</span>
    </div>

    <label class="col-sm-2 col-form-label fw-bold">المعتمدية</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->delegation->nom_ar ?? '-' }}</span>
    </div>
</div>


        <div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label fw-bold">الهاتف القار</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->contact_tel ?? '-' }}</span>
    </div>

    <label class="col-sm-2 col-form-label fw-bold">الفاكس</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->fax ?? '-' }}</span>
    </div>
</div>

<div class="row mt-3 text-end align-items-start">
    <label class="col-sm-2 col-form-label fw-bold">البريد الإلكتروني للمؤسسة</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->contact_email ?? '-' }}</span>
    </div>

    <!--label class="col-sm-2 col-form-label fw-bold">صورة المركب</label>
    <div class="col-sm-4">
        @if(!empty($imageSrc))
					<div class="mt-2 text-center">
						<img src="{{ $imageSrc }}"
							 alt="الصورة الحالية"
							 style="max-width: 200px; max-height: 150px; border-radius: 8px; object-fit: cover; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
					</div>
				@endif
    </div-->
</div>

<!--div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label fw-bold">سعر الليلة (سرير)</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->prix_lit ?? '-' }}</span>
    </div>
</div-->

        

        <div class="form-group mt-3">
            
        </div>

        <h4 class="mt-3"> مدير المؤسسة </h4>

        <div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label fw-bold">الإسم واللقب</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nom_directeur ?? '-' }}</span>
    </div>

    <label class="col-sm-2 col-form-label fw-bold">الهاتف الجوال</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->tel_directeur ?? '-' }}</span>
    </div>
</div>

<h4 class="mt-3">الخدمات</h4>
<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label fw-bold">هل يوجد فضاء للمشروبات ؟</label>
    <div class="col-sm-4">
        <span class="d-inline-block">
            {{ isset($auberge->espace_boisson) ? ($auberge->espace_boisson ? 'نعم' : 'لا') : '-' }}
        </span>
    </div>
    
    <label class="col-sm-2 col-form-label fw-bold">مسبح</label>
    <div class="col-sm-4">
        <span class="d-inline-block">
            {{ isset($auberge->piscine) ? ($auberge->piscine ? 'نعم' : 'لا') : '-' }}
        </span>
    </div>
</div>


<div class="form-group row mt-4">
    <h5 class="text-center mb-3">تعريفات الإقامة</h5>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>فرادى / مجموعات</th>
                <th>نوع الوفد المقيم</th>
                <th>بالمباني</th>
                <th>تحت الخيام</th>
                <th>ملاحظات</th>
            </tr>
        </thead>
        <tbody>
        @forelse($auberge->tarifs as $tarif)
            <tr>
                <td>{{ $tarif->type == 'groupe' ? 'مجموعات' : 'أفراد' }}</td>
                <td>{{ $tarif->typeTarif->type_ar ?? '-' }}</td>
                <td>{{ $tarif->tarif_chambre }}</td>
                <td>{{ $tarif->tarif_tente }}</td>
                <td>{{ $tarif->remarque }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="5" class="text-center">لا توجد تعريفات</td>
            </tr>
        @endforelse
        </tbody>
    </table>
</div>


<div class="form-group row mt-4">
    <h5 class="text-center mb-3">وقف عربات التخييم داخل المركز (في اليوم الواحد) </h5>
   
</div>
 <div class="mb-4">
        <div class="d-inline-block ms-2" style="width:150px;">
            <span class="form-control">{{ $auberge->tarif_camping_cars }}</span>
        </div>
    </div>

    



        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الفضاءات المتوفرة</h5>

    <table id="espaces-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
            </tr>
        </thead>
        <tbody id="espaces-body">
            @php
                $espaces = $auberge->espaces ?? [];
            @endphp

            @foreach($espaces as $espace)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <span class="d-inline-block">{{ $espace->nom_ar ?? '-' }}</span>
                </td>
                <td>
                    <span class="d-inline-block">{{ $espace->nom_fr ?? '-' }}</span>
                </td>
                <td>
                    <span class="d-inline-block">{{ $espace->nom_en ?? '-' }}</span>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الغرف</h5>

    <table id="chambres-table" class="custom-table">
        <thead>
            <tr>
                <th></th>
                <th>نوع الغرفة</th>
                <th>الطاقة الاستيعابية</th>
                <th>رقم الغرفة</th>
            </tr>
        </thead>

        <tbody id="chambres-body">
            @php
                $chambres = $auberge->chambres ?? [];
            @endphp

            @foreach($chambres as $index => $c)
            <tr>
                <td class="row-number">{{ $index + 1 }}</td>

                <td>
                    <span class="d-inline-block">
                        {{ $c->typeChambre->type_ar ?? '-' }}
                    </span>
                </td>

                <td>
                    <span class="d-inline-block">
                        {{ $c->capacite ?? '-' }}
                    </span>
                </td>

                <td>
                    <span class="d-inline-block">
                        {{ $c->num_chambre ?? '-' }}
                    </span>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">طاقة الإستيعاب تحت المباني</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->capacite_batiment ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres ?? 0 }}</span>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف الفردية</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_single ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف ثنائي</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_double ?? 0 }}</span>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف ثلاثي</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_triple ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف رباعي</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_quadra ?? 0 }}</span>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف أكثر من رباعي</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_plus ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">عدد الوحدات الصحية داخل الغرف</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_salles_de_bain ?? 0 }}</span>
    </div>
</div>


        <div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الوحدات الصحية المشتركة</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_salles_de_bain_comm ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف التي تحتوي على تلفاز</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_tv ?? 0 }}</span>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف المكيفة</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_clim ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف التي تحتوي على ثلاجة</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->nb_chambres_frigo ?? 0 }}</span>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">طاقة الإستيعاب تحت الخيام إن وجدت</label>
    <div class="col-sm-4">
        <span class="d-inline-block">{{ $auberge->capacite_tentes ?? 0 }}</span>
    </div>

    <label class="col-sm-2 col-form-label">المطبخ وظيفي</label>
    <div class="col-sm-4">
        <span class="d-inline-block">
            {{ $auberge->cuisine_fonctionnelle === 1 ? 'نعم' : ($auberge->cuisine_fonctionnelle === 0 ? 'لا' : '-') }}
        </span>
    </div>
</div>



       

                <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الملاعب الرياضية</h5>

    <table id="terrains-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
            </tr>
        </thead>
        <tbody id="terrains-body">
            @php
                $terrains = $auberge->terrains ?? [];
            @endphp

            @foreach($terrains as $index => $terrain)
            <tr>
                <td class="row-number">{{ $index + 1 }}</td>
                <td>
                    <span class="d-inline-block">{{ $terrain->nom_ar ?? '-' }}</span>
                </td>
                <td>
                    <span class="d-inline-block">{{ $terrain->nom_fr ?? '-' }}</span>
                </td>
                <td>
                    <span class="d-inline-block">{{ $terrain->nom_en ?? '-' }}</span>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الخدمات المقدمة من طرف المؤسسة</h5>

    <table id="services_auberge-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
            </tr>
        </thead>
        <tbody id="services_auberge-body">
            @foreach($auberge->services_auberge as $index => $service)
            <tr>
                <td class="row-number">{{ $index + 1 }}</td>
                <td><span class="d-inline-block">{{ $service->nom_ar ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $service->nom_fr ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $service->nom_en ?? '-' }}</span></td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="form-group row mt-4">
    <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>
    <table id="restauration-table" class="custom-table">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالإنجليزية</th>
                <th>الوصف بالعربية</th>
                <th>الوصف بالفرنسية</th>
                <th>الوصف بالإنجليزية</th>
                <th>التعريفة (د.ت)</th>
            </tr>
        </thead>
        <tbody id="restauration-body">
            @foreach($auberge->restaurations as $i => $res)
            <tr>
                <td class="row-number">{{ $i + 1 }}</td>
                <td><span class="d-inline-block">{{ $res->nom_ar ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $res->nom_fr ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $res->nom_en ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $res->description_ar ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $res->description_fr ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $res->description_en ?? '-' }}</span></td>
                <td><span class="d-inline-block">{{ $res->tarif ?? 0 }}</span></td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>


        



        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">    المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة بالعربية</label>
            <textarea name="lieux_culturels" id="lieux_culturels" maxlength="250"  class="form-control bg-white" disabled rows="4">{{ old('lieux_culturels', $auberge->lieux_culturels) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">     المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة بالفرنسية</label>
            <textarea name="lieux_culturels_fr" id="lieux_culturels" maxlength="250"  class="form-control bg-white" disabled rows="4">{{ old('lieux_culturels_fr', $auberge->lieux_culturels_fr) }}</textarea>
        </div>


        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">   المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة بالإنقليزية </label>
            <textarea name="lieux_culturels_en" id="lieux_culturels" maxlength="250"  class="form-control bg-white" disabled rows="4">{{ old('lieux_culturels_en', $auberge->lieux_culturels_en) }}</textarea>
        </div>


        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label">     خدمات أخرى بالعربية</label>
            <textarea name="autres_services" maxlength="250" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services"  class="form-control bg-white" disabled rows="4">{{ old('autres_services', $auberge->autres_services) }}</textarea>
        </div>



        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label">    خدمات أخرى  بالفرنسية </label>
            <textarea name="autres_services_fr" maxlength="250" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services"  class="form-control bg-white" disabled rows="4">{{ old('autres_services_fr', $auberge->autres_services_fr) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label">  خدمات أخرى  بالإنقليزية</label>
            <textarea name="autres_services_en" maxlength="250" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services"  class="form-control bg-white" disabled rows="4">{{ old('autres_services_en', $auberge->autres_services_en) }}</textarea>
        </div>



         <div class="block-card-footer mt-3 mb-3 text-center">
			
			<a href="{{ route('auberges.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
			<i class="la la-times mr-1"></i> إلغاء
			</a>
		</div>

    </form>
</div>
<style>
@media print {
    .no-print {
        display: none !important;
    }

    header, footer, nav, aside {
        display: none !important;
    }

    .container {
        width: 100% !important;
        margin: 0 !important;
        padding: 0 !important;
    }

    body {
        margin: 0;
        padding: 0;
        font-size: 12pt;
        line-height: 1.4;
    }

    .form-check, .row {
        page-break-inside: avoid;
    }
}
</style>

@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
