@extends('backoffice.dashboard')

@section('content')

@if($errors->any())
    <ul class="alert alert-warning">
        @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">

                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">عرض التقييم</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="form-group">
                                <label>المستخدم</label>
                                <input class="form-control bg-white" value="{{ $avis->user?->nom_prenom ?? 'مستخدم مجهول' }}" readonly>
                            </div>
                            <div class="form-group">
                                <label>المركب الشبابي</label>
                                <input class="form-control bg-white" value="{{ $avis->auberge?->nom ?? '---' }}" readonly>
                            </div>
                            <div class="form-group">
                                <label>تاريخ التقييم</label>
                                <input class="form-control bg-white" value="{{ $avis->date_avis ? \Carbon\Carbon::parse($avis->date_avis)->format('Y-m-d') : '---' }}" readonly>
                            </div>
                            <div class="form-group">
                                <label>التقييم</label>
                                <textarea class="form-control bg-white" rows="5" readonly>{{ $avis->commentaire ?? '---' }}</textarea>
                            </div>
                        </div>

                        <div class="block-card-footer d-flex gap-2">
                            <a href="{{ route('avis.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-arrow-left mr-1"></i> العودة
                            </a>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
