/**
 * Dashboard Mobile Menu Handler
 * À ajouter dans dashboard.blade.php avant la fermeture de </body>
 */

$(document).ready(function() {
    // Créer le bouton hamburger mobile
    const mobileToggleBtn = $('<button>')
        .addClass('mobile-menu-toggle')
        .attr('aria-label', 'Toggle Menu')
        .html('<i class="ri-menu-line"></i>');
    
    // Créer l'overlay
    const sidebarOverlay = $('<div>').addClass('sidebar-overlay');
    
    // Ajouter les éléments au DOM
    $('body').prepend(mobileToggleBtn, sidebarOverlay);
    
    // Toggle du menu mobile
    mobileToggleBtn.on('click', function() {
        const $sidebar = $('.dashboard-sidebar');
        const $overlay = $('.sidebar-overlay');
        const $btn = $(this);
        
        $sidebar.toggleClass('mobile-active');
        $overlay.toggleClass('active');
        $btn.toggleClass('active');
        
        // Changer l'icône
        const icon = $btn.find('i');
        if ($sidebar.hasClass('mobile-active')) {
            icon.removeClass('ri-menu-line').addClass('ri-close-line');
            $('body').css('overflow', 'hidden'); // Empêcher le scroll du body
        } else {
            icon.removeClass('ri-close-line').addClass('ri-menu-line');
            $('body').css('overflow', ''); // Restaurer le scroll
        }
    });
    
    // Fermer le menu en cliquant sur l'overlay
    sidebarOverlay.on('click', function() {
        closeMobileMenu();
    });
    
    // Fermer le menu avec le bouton X de la sidebar
    $('#sidebar-close').on('click', function() {
        if ($(window).width() <= 991) {
            closeMobileMenu();
        }
    });
    
    // Fonction pour fermer le menu mobile
    function closeMobileMenu() {
        $('.dashboard-sidebar').removeClass('mobile-active');
        $('.sidebar-overlay').removeClass('active');
        $('.mobile-menu-toggle').removeClass('active');
        $('.mobile-menu-toggle i')
            .removeClass('ri-close-line')
            .addClass('ri-menu-line');
        $('body').css('overflow', '');
    }
    
    // Fermer le menu lors du redimensionnement vers desktop
    $(window).on('resize', function() {
        if ($(window).width() > 991) {
            closeMobileMenu();
        }
    });
    
    // Fermer le menu après avoir cliqué sur un lien (optionnel)
    $('.dashboard-sidebar .nav-link').on('click', function(e) {
        // Ne fermer que si c'est un lien direct (pas un dropdown)
        if (!$(this).parent().hasClass('has-submenu') && 
            !$(this).parent().hasClass('dropdown') &&
            $(window).width() <= 991) {
            setTimeout(closeMobileMenu, 300);
        }
    });
    
    // Améliorer le comportement des sous-menus sur mobile
    if ($(window).width() <= 991) {
        $('.has-submenu > .nav-link').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const $parent = $(this).parent();
            const $submenu = $parent.find('.sub-menu');
            
            // Fermer les autres sous-menus
            $('.has-submenu').not($parent).removeClass('active')
                .find('.sub-menu').slideUp(300);
            
            // Toggle le sous-menu actuel
            $parent.toggleClass('active');
            $submenu.slideToggle(300);
        });
    }
    
    // Swipe pour fermer le menu
    let touchStartX = 0;
    let touchEndX = 0;
    
    $('.dashboard-sidebar').on('touchstart', function(e) {
        touchStartX = e.changedTouches[0].screenX;
    });
    
    $('.dashboard-sidebar').on('touchend', function(e) {
        touchEndX = e.changedTouches[0].screenX;
        handleSwipe();
    });
    
    function handleSwipe() {
        // Swipe vers la droite pour fermer (en RTL)
        if (touchEndX > touchStartX + 50) {
            closeMobileMenu();
        }
    }
    
    // Empêcher le scroll du body quand le menu est ouvert
    $('.dashboard-sidebar').on('touchmove', function(e) {
        if ($('.dashboard-sidebar').hasClass('mobile-active')) {
            e.stopPropagation();
        }
    });
    
    console.log('Dashboard mobile menu initialized');
});
