<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('officiel_gests', function (Blueprint $table) {
            $table->id('id_officiel'); // clé primaire auto-incrémentée
            $table->string('nom', 100);
            $table->string('fonction', 255)->nullable();
            $table->unsignedBigInteger('demande_id');

            // clé étrangère
            $table->foreign('demande_id')
                  ->references('id_demande')
                  ->on('demandes_manifestation')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('officiel_gests');
    }
};
