<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assoc_participantes', function (Blueprint $table) {
            $table->id('id_assoc_p'); // clé primaire auto-incrémentée
            $table->string('nom', 100);

            // nombre d’athlètes et participants
            $table->integer('num_athlete_h')->nullable();
            $table->integer('num_athlete_f')->nullable();
            $table->integer('escorte')->nullable();
            $table->integer('accompagnants')->nullable();
            $table->integer('jurie')->nullable();
            $table->integer('officiel')->nullable();
            $table->integer('invitee')->nullable();
            $table->integer('total')->nullable();

            // relation avec Evenement_sportif
            $table->unsignedBigInteger('event_id');
            $table->foreign('event_id')
                  ->references('id_even')
                  ->on('evenement_sportif')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assoc_participantes');
    }
};
