<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('organismes_non_sportifs', function (Blueprint $table) {
            $table->id('id_org');
            $table->string('nom', 100);
            $table->integer('num_visa')->nullable();
            $table->date('date_enregistrement');
            $table->integer('num_enregistrement')->nullable();
            $table->integer('identifiant_fiscal')->nullable();
            $table->string('num_compte_bancaire', 20)->nullable();
            $table->string('adresse', 150)->nullable();
            $table->string('tel', 12)->nullable();
            $table->string('fax', 12)->nullable();
            $table->string('email', 100)->nullable();
            $table->unsignedBigInteger('type_formulaire_id');

            $table->foreign('type_formulaire_id')->references('id_type')->on('tp_type_formulaire')->onDelete('cascade');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('organismes_non_sportifs');
    }
};
