<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visite_3d', function (Blueprint $table) {
            $table->id('id_visite');
            $table->string('url', 255)->nullable();
            $table->boolean('est_actif')->default(true);
            $table->unsignedBigInteger('auberge_id');

            $table->foreign('auberge_id')
                  ->references('id')
                  ->on('auberge')
                  ->onDelete('cascade'); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visite_3d');
    }
};
