<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class ValidLink implements Rule
{
    public function passes($attribute, $value)
    {
        if (empty($value) || trim($value) === '') {
            return true; 
        }

        $url = trim($value);
        
     
        if (str_starts_with($url, '#')) {
            return preg_match('/^#[a-zA-Z0-9\-_]+$/', $url) && strlen($url) > 1;
        }
        
 
        if (str_starts_with($url, '/') || str_starts_with($url, './') || str_starts_with($url, '../')) {
            $pathWithoutPrefix = preg_replace('/^(\/|\.\/|\.\.\/)/', '', $url);
            return !empty($pathWithoutPrefix) && preg_match('/^[a-zA-Z0-9\-._~%!$&\'()*+,;=:@\/]+$/', $pathWithoutPrefix);
        }
        
     
        if (preg_match('/^[a-zA-Z0-9\-_]+$/', $url)) {
            return true;
        }
        
    
        if (filter_var($url, FILTER_VALIDATE_URL)) {
            $parsedUrl = parse_url($url);
            
          
            if (empty($parsedUrl['host'])) {
                return false;
            }
          
            return $this->isValidHost($parsedUrl['host']);
        }
        
       
        $urlWithProtocol = 'https://' . $url;
        if (filter_var($urlWithProtocol, FILTER_VALIDATE_URL)) {
            $parsedUrl = parse_url($urlWithProtocol);
            
            if (empty($parsedUrl['host'])) {
                return false;
            }
            
            return $this->isValidHost($parsedUrl['host']);
        }
        
        return false;
    }

    
    private function isValidHost($hostname)
    {
        $hostname = preg_replace('/^www\./', '', $hostname);
        
       
        $validPatterns = [
           
            '/^[a-zA-Z0-9](?:[a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*\.[a-zA-Z]{2,}$/',
            
          
            '/^localhost$/',
            
          
            '/^(\d{1,3}\.){3}\d{1,3}$/',
        ];
        
        foreach ($validPatterns as $pattern) {
            if (preg_match($pattern, $hostname)) {
                
                if (preg_match('/^(\d{1,3}\.){3}\d{1,3}$/', $hostname)) {
                    $parts = explode('.', $hostname);
                    foreach ($parts as $part) {
                        if ($part < 0 || $part > 255) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        
        return false;
    }

    public function message()
    {
        return 'الرابط غير صالح. أمثلة مقبولة: #contactForm, /about, contact, about-us, https://site.com';
    }
}