<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Type;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Passe la variable $types à toutes les vues
        View::composer('*', function ($view) {
            // Charge tous les types avec leurs guides et sous-guides
            $types = Type::with(['guides.children'])
                        ->orderBy('ordre')
                        ->get();

            $view->with('types', $types);
        });
    }
}
