<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class SalleSportStatutNotification extends Notification
{
    use Queueable;

    public $type;
    public $dateDebut;
    public $commentaire;
    protected $params;
    protected $referenceId;

 
    public function __construct(string $type, $data = null, $referenceId = null)
    {
        $this->type = $type;
        $this->params = [];
        $this->referenceId = $referenceId;

        if (is_array($data)) {
            $this->params = $data;
            $this->commentaire = $data['reason'] ?? null;
            $this->dateDebut = $data['date'] ?? null;
        } else {
            // if string provided, assume it's a reason (for rejected) or date (for accepted)
            if ($type === 'rejected') {
                $this->commentaire = is_string($data) ? $data : null;
                if ($this->commentaire) $this->params['reason'] = $this->commentaire;
            } elseif ($type === 'accepted') {
                $this->dateDebut = $data;
                if ($this->dateDebut) $this->params['date'] = $this->dateDebut;
            } else {
                if (is_string($data) && $data !== '') {
                    // put fallback into a generic param
                    $this->params['info'] = $data;
                }
            }
        }
    }

  
    public function via($notifiable)
    {
        return ['database'];
    }

   
    public function toDatabase($notifiable)
    {
        $translationKey = "site.notifications.salle_sport.{$this->type}";

        return [
            'translation_key' => $translationKey,
            'translation_params' => $this->params,
            'date' => now()->toDateTimeString(),
            'reference_id' => $this->referenceId,
        ];
    }

   
    /*public function toMail($notifiable)
    {
        if ($this->type === 'accepted') {
            return (new MailMessage)
                ->subject('تم قبول طلبكم')
                ->line('طلبكم قد تم قبوله.')
                ->line($this->dateDebut ? 'تاريخ بداية النشاط: ' . $this->dateDebut : '');
        } else {
            return (new MailMessage)
                ->subject('تم رفض طلبكم')
                ->line('نأسف، تم رفض طلبكم.')
                ->line('السبب: ' . ($this->commentaire ?? ''));
        }
    }*/

    public function toArray($notifiable)
    {
        return [
            'type' => $this->type,
            'params' => $this->params,
            'reference_id' => $this->referenceId,
        ];
    }
}
