<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Carbon;

class JeunesseStatutNotification extends Notification
{
    use Queueable;

    public string $type;
    public array $translationParams;
    public $numDossier;

    /**
     * $type: accepted | rejected | incomplete | deferred | status_changed
     */
    public function __construct(string $type, array $translationParams = [], $numDossier = null)
    {
        $this->type = $type;
        $this->translationParams = $translationParams;
        $this->numDossier = $numDossier;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    /*public function toMail($notifiable)
    {
        $messageKey = "site.notifications.documents_formulaire.{$this->type}";
        $subjectKey = "site.notifications.documents_formulaire.mail_subject";

        return (new MailMessage)
            ->subject(__($subjectKey))
            ->line(__($messageKey, $this->translationParams));
    }*/

    public function toDatabase($notifiable)
    {
        return [
            'translation_key'    => "site.notifications.documents_formulaire.{$this->type}",
            'translation_params' => $this->translationParams,
            'num_dossier'        => $this->numDossier,
            'date'               => Carbon::now()->toDateTimeString(),
            'type'               => $this->type,
        ];
    }

    public function toArray($notifiable)
    {
        return $this->toDatabase($notifiable);
    }
}
