<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class Jeunesse2StatutNotification extends Notification
{
    use Queueable;

    public $type;
    public $dateDebut;
    public $motif;
    public $params;

    /**
     * $type: 'accepted'|'rejected'|'incomplete'|'deferred'|'status_changed'
     * $data: optional data (string or array) used to fill translation params
     */
    public function __construct(string $type, $data = null)
    {
        $this->type = $type;
        $this->params = [];

        // normalize $data into params expected by translations
        if ($type === 'accepted') {
            $this->dateDebut = is_string($data) ? $data : ($data['date'] ?? null);
            if ($this->dateDebut) $this->params['date'] = $this->dateDebut;
        } elseif ($type === 'rejected') {
            $this->motif = is_string($data) ? $data : ($data['reason'] ?? null);
            if ($this->motif) $this->params['reason'] = $this->motif;
        } elseif ($type === 'incomplete') {
            $this->params['missing'] = is_string($data) ? $data : ($data['missing'] ?? null);
        } elseif ($type === 'deferred') {
            $this->params['note'] = is_string($data) ? $data : ($data['note'] ?? null);
        } else {
            // allow passing arbitrary params array
            if (is_array($data)) $this->params = $data;
        }
    }

    public function via($notifiable)
    {
        return ['database'];
    }

   

    /**
     * Database channel: store translation_key + translation_params
     * Blade will call __($translation_key, $translation_params)
     */
    public function toDatabase($notifiable)
    {
        // translation key namespace consistent with your other notifications
        $translationKey = "site.notifications.documents_formulaire.{$this->type}";

        return [
            'translation_key' => $translationKey,
            'translation_params' => $this->params,
            'date' => now()->toDateTimeString(),
            // optional: a reference id may be added by the caller if needed
            'reference_id' => null,
        ];
    }

    // fallback for other usages
    public function toArray($notifiable)
    {
        return [
            'type' => $this->type,
            'motif' => $this->motif,
            'params' => $this->params,
        ];
    }
}
