<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Carbon;

class JeuneEnfantStatutNotification extends Notification
{
    use Queueable;

    public $type;
    public $translationParams;
    public $numDossier;

    /**
     * $type: normalized type string (accepted,rejected,incomplete,deferred,status_changed)
     * $translationParams: associative array for __()
     * $numDossier: optional identifier (id_inst / id_projet / id_inv_sport or dossier number)
     */
    public function __construct(string $type, array $translationParams = [], $numDossier = null)
    {
        $this->type = $type;
        $this->translationParams = $translationParams;
        $this->numDossier = $numDossier;
    }

    public function via($notifiable)
    {
        // keep mail + database for backward compatibility with your existing flows
        return ['database'];
    }

    

    public function toDatabase($notifiable)
    {
        $translationKey = "site.notifications.documents_formulaire.{$this->type}";

        return [
            'translation_key'    => $translationKey,
            'translation_params' => $this->translationParams,
            'num_dossier'        => $this->numDossier,
            'date'               => Carbon::now()->toDateTimeString(),
            'type'               => $this->type,
        ];
    }

    public function toArray($notifiable)
    {
        return $this->toDatabase($notifiable);
    }
}
