<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EvenementSportif extends Model
{
    use HasFactory;

    protected $table = 'evenement_sportif';

    protected $primaryKey = 'id_even';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'nom_even',
        'objectifs',
        'contenus',
        'date',
        'heure',
        'instalation_sportives',
        'reference',
        'estimation_evenement',
        'cout_total_evenement',
        'difference_estimee',
        'recompense',
        'moyen_transport',
        'user_id',
        'id_type',
        'gouvernorat_id',
        'delegation_id',
        'id_formulaire',
        'demande_id'
    ];

    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id', 'id');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_type', 'id_statut');
    }

    public function gouvernorat()
    {
        return $this->belongsTo(Gouvernorat::class, 'gouvernorat_id', 'id_gouver');
    }

    public function delegation()
    {
        return $this->belongsTo(Delegation::class, 'delegation_id', 'id_delegation');
    }

    public function formulaire()
    {
        return $this->belongsTo(TpTypeFormulaire::class, 'id_formulaire', 'id_type');
    }
    
    public function athletesIndividuels()
    {
        return $this->hasMany(AthleteIndividuel::class, 'event_id', 'id_even');
    }

    public function membres()
    {
        return $this->hasMany(MembreOrgInvite::class, 'event_id', 'id_even');
    }

    public function invites()
    {
        return $this->hasMany(MembreOrgInvite::class, 'event_id', 'id_even');
    }

    public function assocParticipantes()
    {
        return $this->hasMany(AssocParticipante::class, 'event_id', 'id_even');
    }

    public function sportifs()
    {
        return $this->hasMany(SportifParticipant::class, 'even_id', 'id_even');
    }

    public function etrangeres()
    {
        return $this->hasMany(Etrangere::class, 'even_id', 'id_even');
    }

}
