<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Etrangere extends Model
{
    use HasFactory;

    protected $table = 'etrangere';

    protected $primaryKey = 'id';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'nom_prenom',
        'pays_origine',
        'num_passport',
        'date_arrive',
        'lieu_residence',
        'date_depart',
        'even_id',
        'type_etranger_id',
    ];


    public function evenement()
    {
        return $this->belongsTo(EvenementSportif::class, 'even_id', 'id_even');
    }

    public function typeEtranger()
    {
        return $this->belongsTo(TpTypeEtrangere::class, 'type_etranger_id', 'id_type');
    }
}
