<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentsFormulaire extends Model
{
    use HasFactory;
    protected $table = 'documents_formulaire';
    protected $primaryKey = 'id_doc';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'id_user',
        'copie_cahier_des_charges',
        'copie_originale',
        'facture',
        'contrat',
        'fichier_arrivage',
        'fichier_colisage',
        'copie_registre_fiscal',
        'copie_registre_national_institutions',
        'copie_certificat_propriete',
        'engagement',
        'exemple_projet',
        'id_statut',
        'commentaire_motif',
        'commentaire_acceptation',
        'commentaire_avis',
        'id_formulaire',
        'adresse_projet',
        'nom_projet',
        'id_type_formulaire',
        'immobilier_id',
        'etat_formulaire'
    ];

    public function getNumeroDossierAttribute()
    {
        $cin = $this->utilisateur->cin ?? $this->utilisateur->passport ?? $this->utilisateur->num_fiscal ?? '00000000';
        $year = $this->created_at ? $this->created_at->format('Y') : now()->format('Y');
        return str_pad($this->id_doc, 3, '0', STR_PAD_LEFT) . '_' . $cin . '_' . $year;
    }


    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut', 'id_statut');
    }

    public function typeFormulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function typeFormulaireExoneration()
    {
        return $this->belongsTo(TpTypeFormulaire::class, 'id_type_formulaire', 'id_type');
    }
    
    public function immobilier()
    {
        return $this->belongsTo(Immobilier::class, 'immobilier_id', 'id_imm');
    }

}
