<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DirecteurEtablissement extends Model
{
    use HasFactory;

    protected $table = 'directeur_etablissement';

    protected $primaryKey = 'id_directeur';

    protected $keyType = 'int';

    public $incrementing = true;

    protected $fillable = [
        'nom_prenom_d',
        'num_cin',
        'date_delivrance',
        'lieu_delivrance',
        'niveau_etude',
        'dernier_diplome_obtenu',
    ];

    public $timestamps = false;

    public function projets()
    {
        return $this->hasMany(ProjetDivertissementJeuneEnfant::class, 'id_directeur', 'id_directeur');
    }
}
