<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TypeChambre extends Model
{
    use HasFactory;

    protected $table = 'tp_type_chambre';
    protected $primaryKey = 'id_type';
    public $incrementing = true;
    protected $keyType = 'int'; 

    protected $fillable = [
        'type_ar',
        'type_fr',
        'type_en'
    ];

    public function chambres()
    {
        return $this->hasMany(ChambreTente::class, 'type_chambre_id', 'id_type');
    }
}
