<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TpSportsAuberge extends Model
{
    protected $table = 'tp_sports_auberge';
    protected $primaryKey = 'id_sport';
    public $timestamps = false; // si tu n'as pas created_at / updated_at

    protected $fillable = [
        'nom_ar',
        'nom_fr',
        'nom_en',
    ];

    // Relation Many-to-Many avec Auberge
    public function auberges()
    {
        return $this->belongsToMany(
            Auberge::class,
            'auberge_sports',
            'id_sport',
            'id_auberge'
        );
    }
}
