<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TarifAuberge extends Model
{
    use HasFactory;

    protected $table = 'tarif_auberge';

    protected $primaryKey = 'id_tarif';

    protected $dates = ['created_at', 'updated_at'];

    protected $fillable = [
        'type',
        'id_type_tarif',
        'tarif_chambre',
        'tarif_tente',
        'remarque',
        'id_auberge',
    ];

    // ================= Relations =================

    public function typeTarif()
    {
        return $this->belongsTo(TpTypeTarif::class, 'id_type_tarif', 'id_type');
    }

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'id_auberge', 'id');
    }

}
