<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Superviseur extends Model
{
    use HasFactory;

    protected $table = 'superviseur';

    protected $primaryKey = 'id_sup';

    public $incrementing = true;

    protected $fillable = [
        'nom_prenom_sup',
        'role_sup',
        'profession_sup',
        'tel_sup',
        'email_sup',
    ];

    public $timestamps = false;

    public function projets()
    {
        return $this->hasMany(Projet::class, 'id_superviseur', 'id_sup');
    }
    
}
